/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.JobQueueListener;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.Messages;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueue {
    private static final double TOTAL_TASK_WORK_LOAD = 9900.0;
    private static final double TOTAL_PROGRESS_WORK_LOAD = 10000.0;
    private static final int PROGRESS_UPDATE_DELAY = 300;
    public static final QualifiedName NO_IMMEDIATE_ERROR_PROMPT_PROPERTY = new QualifiedName("org.eclipse.ui.workbench.progress", "delayErrorPrompt");
    private final Job fProgressJob;
    private final int fMaxConcurrentJobs;
    private final int fProgressDelay;
    private final String fName;
    private String fTaskPrefix;
    private final boolean fShowProgress;
    private boolean fIsUnknownProgress;
    private final ListenerList fListeners = new ListenerList();
    private volatile boolean fProgressJobScheduled;
    private volatile String fCurrentTask = "";
    private final AtomicInteger fTotalWork = new AtomicInteger(0);
    private final AtomicInteger fWorkDone = new AtomicInteger(0);
    private final AtomicInteger fProgressShown = new AtomicInteger(0);
    private final AtomicInteger fProgressBuf = new AtomicInteger(0);
    private final AtomicInteger fScheduledJobs = new AtomicInteger(0);
    private final AtomicBoolean fIsSealed = new AtomicBoolean(false);
    private final BlockingQueue<ITask> fOpenTasksQueue;

    public JobQueue(String name, int maxConcurrentJobs, int maxQueueSize, boolean showProgress, int progressDelay) {
        this(name, name, maxConcurrentJobs, maxQueueSize, showProgress, progressDelay);
    }

    public JobQueue(String globalName, String taskPrefix, int maxConcurrentJobs, int maxQueueSize, boolean showProgress, int progressDelay) {
        Assert.isNotNull((Object)globalName);
        Assert.isNotNull((Object)taskPrefix);
        Assert.isLegal((progressDelay >= 0 ? 1 : 0) != 0, (String)"JobQueue Progress delay is negative");
        this.fName = globalName;
        this.fTaskPrefix = taskPrefix;
        this.fMaxConcurrentJobs = maxConcurrentJobs;
        this.fShowProgress = showProgress;
        this.fProgressDelay = progressDelay;
        this.fOpenTasksQueue = new LinkedBlockingQueue<ITask>(maxQueueSize);
        this.fProgressJob = showProgress ? this.createProgressJob() : null;
    }

    public void setUnknownProgress(boolean isUnknownProgress) {
        this.fIsUnknownProgress = isUnknownProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean joinRunning, boolean seal) {
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            if (seal) {
                this.seal();
            }
            this.fOpenTasksQueue.clear();
            Job.getJobManager().cancel((Object)this);
            if (this.fProgressJob != null) {
                this.fProgressJob.cancel();
            }
        }
        if (joinRunning) {
            while (Job.getJobManager().find((Object)this).length != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public void seal() {
        this.fIsSealed.set(true);
    }

    public boolean isQueued(ITask task) {
        return this.fOpenTasksQueue.contains(task);
    }

    public boolean schedule(ITask task) {
        return this.schedule(Collections.singletonList(task));
    }

    public boolean schedule(List<ITask> tasks) {
        int tasksSize = tasks.size();
        if (tasksSize == 0) {
            return true;
        }
        if (this.fIsSealed.get()) {
            return false;
        }
        for (ITask task : tasks) {
            try {
                this.fOpenTasksQueue.put(task);
                this.fTotalWork.incrementAndGet();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (!this.fProgressJobScheduled && this.fShowProgress) {
            this.fProgressJobScheduled = true;
            this.fProgressJob.schedule((long)this.fProgressDelay);
        }
        if (this.fScheduledJobs.get() >= this.fMaxConcurrentJobs) {
            return true;
        }
        int i = 0;
        while (i < tasksSize && !this.fOpenTasksQueue.isEmpty()) {
            if (this.fScheduledJobs.incrementAndGet() > this.fMaxConcurrentJobs) {
                this.fScheduledJobs.decrementAndGet();
                break;
            }
            Job job = this.createJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!JobQueue.this.fOpenTasksQueue.isEmpty()) {
                        event.getJob().schedule();
                    } else {
                        JobQueue.this.fScheduledJobs.decrementAndGet();
                    }
                }
            });
            job.setProperty(NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
            job.setSystem(true);
            job.schedule();
            ++i;
        }
        return true;
    }

    private Job createJob() {
        Job job = new Job(""){

            protected IStatus run(final IProgressMonitor monitor) {
                final ITask task = (ITask)JobQueue.this.fOpenTasksQueue.poll();
                if (task == null) {
                    return Status.OK_STATUS;
                }
                if (!monitor.isCanceled()) {
                    SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                        public void run() throws Exception {
                            JobQueue.this.fCurrentTask = task.getName();
                            IStatus status = task.run(monitor);
                            if ((status.getSeverity() == 4 || status.getSeverity() == 2) && Activator.getDefault() != null) {
                                Activator.getDefault().getLog().log(status);
                            }
                        }
                    });
                    if (!monitor.isCanceled()) {
                        JobQueue.this.fWorkDone.incrementAndGet();
                        int workDifference = JobQueue.this.fTotalWork.get() - JobQueue.this.fWorkDone.get();
                        if (workDifference > 0 && JobQueue.this.fProgressJobScheduled) {
                            int progress = (int)((9900.0 - (double)JobQueue.this.fProgressShown.get()) / (double)workDifference);
                            JobQueue.this.fProgressShown.addAndGet(progress);
                            JobQueue.this.fProgressBuf.addAndGet(progress);
                        }
                    }
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == JobQueue.this;
            }
        };
        return job;
    }

    public synchronized boolean isEmpty() {
        return this.internalIsEmpty();
    }

    private boolean internalIsEmpty() {
        return this.fTotalWork.get() - this.fWorkDone.get() == 0;
    }

    public void addJobQueueListener(JobQueueListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeJobQueueListener(JobQueueListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private Job createProgressJob() {
        return new Job(this.fName){
            private int fLastWorkDone;
            private String fLastTask;
            {
                this.fLastWorkDone = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                boolean interrupted = false;
                if (!JobQueue.this.internalIsEmpty()) {
                    monitor.beginTask(JobQueue.this.fName, JobQueue.this.fIsUnknownProgress ? -1 : 10000);
                }
                while (!monitor.isCanceled() && !JobQueue.this.internalIsEmpty()) {
                    if (!(JobQueue.this.fCurrentTask == null || this.fLastWorkDone == JobQueue.this.fWorkDone.get() && StringUtils.isSet(this.fLastTask))) {
                        this.fLastWorkDone = JobQueue.this.fWorkDone.get();
                        this.fLastTask = JobQueue.this.fCurrentTask;
                        monitor.setTaskName(JobQueue.this.formatTask());
                    }
                    if (JobQueue.this.fProgressBuf.get() > 0) {
                        monitor.worked(JobQueue.this.fProgressBuf.get());
                        JobQueue.this.fProgressBuf.set(0);
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        break;
                    }
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    Job.getJobManager().cancel((Object)JobQueue.this);
                }
                JobQueue jobQueue = JobQueue.this;
                synchronized (jobQueue) {
                    JobQueue.this.reset();
                }
                this.fLastWorkDone = -1;
                this.fLastTask = null;
                JobQueue.this.notifyWorkDone();
                if (monitor.isCanceled() || interrupted) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == JobQueue.this;
            }
        };
    }

    private void notifyWorkDone() {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final JobQueueListener listener = (JobQueueListener)element;
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    listener.workDone();
                }
            });
            ++n2;
        }
    }

    private String formatTask() {
        int workDone = this.fWorkDone.get();
        Object[] bindings = Arrays.asList(this.fTaskPrefix, String.valueOf(workDone != 0 ? workDone : 1), String.valueOf(this.fTotalWork.get()), this.fCurrentTask.replaceAll("&", "&&")).toArray();
        String str = NLS.bind((String)Messages.JobQueue_TASK_NAME, (Object[])bindings);
        return str;
    }

    private void reset() {
        this.fScheduledJobs.set(0);
        this.fProgressJobScheduled = false;
        this.fWorkDone.set(0);
        this.fTotalWork.set(0);
        this.fProgressBuf.set(0);
        this.fProgressShown.set(0);
        this.fCurrentTask = "";
        this.fOpenTasksQueue.clear();
    }
}

