/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.ObjectHeaderAttributes1;
import com.db4o.internal.marshall.ObjectMarshaller;
import com.db4o.internal.slots.Slot;

public class ObjectMarshaller1
extends ObjectMarshaller {
    public void addFieldIndices(final ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, final Slot slot) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata2) {
                if (bl) {
                    fieldMetadata.addIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), null);
                } else {
                    fieldMetadata.addFieldIndex(ObjectMarshaller1.this._family, classMetadata, statefulBuffer, slot);
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    public TreeInt collectFieldIDs(TreeInt treeInt, ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, final String string) {
        final TreeInt[] treeIntArray = new TreeInt[]{treeInt};
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (bl) {
                    return;
                }
                if (string.equals(fieldMetadata.getName())) {
                    treeIntArray[0] = fieldMetadata.collectIDs(ObjectMarshaller1.this._family, treeIntArray[0], statefulBuffer);
                } else {
                    fieldMetadata.incrementOffset(statefulBuffer);
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
        return treeIntArray[0];
    }

    public void deleteMembers(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final StatefulBuffer statefulBuffer, int n, final boolean bl) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl2, ClassMetadata classMetadata) {
                if (bl2) {
                    fieldMetadata.removeIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), null);
                } else {
                    fieldMetadata.delete(ObjectMarshaller1.this._family, statefulBuffer, bl);
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    public boolean findOffset(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final Buffer buffer, final FieldMetadata fieldMetadata) {
        final boolean[] blArray = new boolean[]{false};
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata2, boolean bl, ClassMetadata classMetadata) {
                if (fieldMetadata2 == fieldMetadata) {
                    blArray[0] = !bl;
                    this.cancel();
                    return;
                }
                if (!bl) {
                    fieldMetadata2.incrementOffset(buffer);
                }
            }
        };
        this.traverseFields(classMetadata, buffer, objectHeaderAttributes, traverseFieldCommand);
        return blArray[0];
    }

    public void instantiateFields(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, final ObjectReference objectReference, final Object object, final StatefulBuffer statefulBuffer) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (bl) {
                    fieldMetadata.set(object, null);
                    return;
                }
                try {
                    fieldMetadata.instantiate(ObjectMarshaller1.this._family, objectReference, object, statefulBuffer);
                }
                catch (CorruptionException corruptionException) {
                    this.cancel();
                }
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes, traverseFieldCommand);
    }

    private void marshall(final ObjectReference objectReference, final Object object, ObjectHeaderAttributes1 objectHeaderAttributes1, final StatefulBuffer statefulBuffer, final boolean bl) {
        ClassMetadata classMetadata = objectReference.getYapClass();
        this.writeObjectClassID(statefulBuffer, classMetadata.getID());
        objectHeaderAttributes1.write(statefulBuffer);
        classMetadata.checkUpdateDepth(statefulBuffer);
        final Transaction transaction = statefulBuffer.getTransaction();
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
                buffer.writeInt(classMetadata.i_fields.length);
                return classMetadata.i_fields.length;
            }

            public void processField(FieldMetadata fieldMetadata, boolean bl2, ClassMetadata classMetadata) {
                if (bl2) {
                    fieldMetadata.addIndexEntry(transaction, statefulBuffer.getID(), null);
                    return;
                }
                Object object2 = fieldMetadata.getOrCreate(transaction, object);
                if (object2 instanceof Db4oTypeImpl) {
                    object2 = ((Db4oTypeImpl)object2).storedTo(transaction);
                }
                fieldMetadata.marshall(objectReference, object2, ObjectMarshaller1.this._family, statefulBuffer, classMetadata.configOrAncestorConfig(), bl);
            }
        };
        this.traverseFields(classMetadata, statefulBuffer, objectHeaderAttributes1, traverseFieldCommand);
    }

    public StatefulBuffer marshallNew(Transaction transaction, ObjectReference objectReference, int n) {
        ObjectHeaderAttributes1 objectHeaderAttributes1 = new ObjectHeaderAttributes1(objectReference);
        StatefulBuffer statefulBuffer = this.createWriterForNew(transaction, objectReference, n, objectHeaderAttributes1.objectLength());
        this.marshall(objectReference, objectReference.getObject(), objectHeaderAttributes1, statefulBuffer, true);
        return statefulBuffer;
    }

    public void marshallUpdate(Transaction transaction, int n, ObjectReference objectReference, Object object) {
        ObjectHeaderAttributes1 objectHeaderAttributes1 = new ObjectHeaderAttributes1(objectReference);
        StatefulBuffer statefulBuffer = this.createWriterForUpdate(transaction, n, objectReference.getID(), 0, objectHeaderAttributes1.objectLength());
        if (transaction.i_file != null) {
            transaction.i_file.getSlotForUpdate(statefulBuffer);
        }
        this.marshall(objectReference, object, objectHeaderAttributes1, statefulBuffer, false);
        this.marshallUpdateWrite(transaction, objectReference, object, statefulBuffer);
    }

    public ObjectHeaderAttributes readHeaderAttributes(Buffer buffer) {
        return new ObjectHeaderAttributes1(buffer);
    }

    public Object readIndexEntry(ClassMetadata classMetadata, ObjectHeaderAttributes objectHeaderAttributes, FieldMetadata fieldMetadata, StatefulBuffer statefulBuffer) {
        if (classMetadata == null) {
            return null;
        }
        if (!this.findOffset(classMetadata, objectHeaderAttributes, statefulBuffer, fieldMetadata)) {
            return null;
        }
        return fieldMetadata.readIndexEntry(this._family, statefulBuffer);
    }

    public void readVirtualAttributes(final Transaction transaction, ClassMetadata classMetadata, final ObjectReference objectReference, ObjectHeaderAttributes objectHeaderAttributes, final Buffer buffer) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (!bl) {
                    fieldMetadata.readVirtualAttribute(transaction, buffer, objectReference);
                }
            }
        };
        this.traverseFields(classMetadata, buffer, objectHeaderAttributes, traverseFieldCommand);
    }

    protected boolean isNull(ObjectHeaderAttributes objectHeaderAttributes, int n) {
        return ((ObjectHeaderAttributes1)objectHeaderAttributes).isNull(n);
    }

    public void defragFields(ClassMetadata classMetadata, ObjectHeader objectHeader, final ReaderPair readerPair) {
        ObjectMarshaller.TraverseFieldCommand traverseFieldCommand = new ObjectMarshaller.TraverseFieldCommand(){

            public int fieldCount(ClassMetadata classMetadata, Buffer buffer) {
                return readerPair.readInt();
            }

            public void processField(FieldMetadata fieldMetadata, boolean bl, ClassMetadata classMetadata) {
                if (!bl) {
                    fieldMetadata.defragField(ObjectMarshaller1.this._family, readerPair);
                }
            }
        };
        this.traverseFields(classMetadata, null, objectHeader._headerAttributes, traverseFieldCommand);
    }

    public void writeObjectClassID(Buffer buffer, int n) {
        buffer.writeInt(-n);
    }

    public void skipMarshallerInfo(Buffer buffer) {
        buffer.incrementOffset(1);
    }
}

