/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia.rtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPReport;
import org.jitsi.service.neomedia.rtp.RTCPExtendedReport;
import org.jitsi.service.neomedia.rtp.RTCPReportListener;
import org.jitsi.util.Logger;

public class RTCPReports {
    private static final Logger logger = Logger.getLogger(RTCPReports.class);
    private List<RTCPReportListener> listeners = Collections.emptyList();
    private final Object listenerSyncRoot = new Object();
    private final Map<Integer, RTCPExtendedReport> receivedExtendedReports = new HashMap<Integer, RTCPExtendedReport>();
    private final Map<Integer, RTCPFeedback> receivedFeedbacks = new HashMap<Integer, RTCPFeedback>();
    private final Map<Integer, RTCPReport> receivedReports = new HashMap<Integer, RTCPReport>();
    private final Map<Integer, RTCPExtendedReport.VoIPMetricsReportBlock> receivedVoIPMetrics = new HashMap<Integer, RTCPExtendedReport.VoIPMetricsReportBlock>();
    private final Map<Integer, RTCPExtendedReport> sentExtendedReports = new HashMap<Integer, RTCPExtendedReport>();
    private final Map<Integer, RTCPFeedback> sentFeedbacks = new HashMap<Integer, RTCPFeedback>();
    private final Map<Integer, RTCPReport> sentReports = new HashMap<Integer, RTCPReport>();
    private final Map<Integer, RTCPExtendedReport.VoIPMetricsReportBlock> sentVoIPMetrics = new HashMap<Integer, RTCPExtendedReport.VoIPMetricsReportBlock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTCPReportListener(RTCPReportListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.listenerSyncRoot;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                ArrayList<RTCPReportListener> newListeners = new ArrayList<RTCPReportListener>(this.listeners.size() + 1);
                newListeners.addAll(this.listeners);
                newListeners.add(listener);
                this.listeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport getReceivedRTCPExtendedReport(int ssrc) {
        Map<Integer, RTCPExtendedReport> map = this.receivedExtendedReports;
        synchronized (map) {
            return this.receivedExtendedReports.get(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport[] getReceivedRTCPExtendedReports() {
        Map<Integer, RTCPExtendedReport> map = this.receivedExtendedReports;
        synchronized (map) {
            Collection<RTCPExtendedReport> values = this.receivedExtendedReports.values();
            return values.toArray(new RTCPExtendedReport[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPFeedback getReceivedRTCPFeedback(int sourceSSRC) {
        Map<Integer, RTCPReport> map = this.receivedReports;
        synchronized (map) {
            return this.receivedFeedbacks.get(sourceSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPFeedback[] getReceivedRTCPFeedbacks() {
        Map<Integer, RTCPReport> map = this.receivedReports;
        synchronized (map) {
            Collection<RTCPFeedback> values = this.receivedFeedbacks.values();
            return values.toArray(new RTCPFeedback[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPReport getReceivedRTCPReport(int senderSSRC) {
        Map<Integer, RTCPReport> map = this.receivedReports;
        synchronized (map) {
            return this.receivedReports.get(senderSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPReport[] getReceivedRTCPReports() {
        Map<Integer, RTCPReport> map = this.receivedReports;
        synchronized (map) {
            Collection<RTCPReport> values = this.receivedReports.values();
            return values.toArray(new RTCPReport[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport.VoIPMetricsReportBlock[] getReceivedRTCPVoIPMetrics() {
        Map<Integer, RTCPExtendedReport> map = this.receivedExtendedReports;
        synchronized (map) {
            Collection<RTCPExtendedReport.VoIPMetricsReportBlock> values = this.receivedVoIPMetrics.values();
            return values.toArray(new RTCPExtendedReport.VoIPMetricsReportBlock[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport.VoIPMetricsReportBlock getReceivedRTCPVoIPMetrics(int sourceSSRC) {
        Map<Integer, RTCPExtendedReport> map = this.receivedExtendedReports;
        synchronized (map) {
            return this.receivedVoIPMetrics.get(sourceSSRC);
        }
    }

    public List<RTCPReportListener> getRTCPReportListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport getSentRTCPExtendedReport(int ssrc) {
        Map<Integer, RTCPExtendedReport> map = this.sentExtendedReports;
        synchronized (map) {
            return this.sentExtendedReports.get(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport[] getSentRTCPExtendedReports() {
        Map<Integer, RTCPExtendedReport> map = this.sentExtendedReports;
        synchronized (map) {
            Collection<RTCPExtendedReport> values = this.sentExtendedReports.values();
            return values.toArray(new RTCPExtendedReport[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPFeedback getSentRTCPFeedback(int sourceSSRC) {
        Map<Integer, RTCPReport> map = this.sentReports;
        synchronized (map) {
            return this.sentFeedbacks.get(sourceSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPFeedback[] getSentRTCPFeedbacks() {
        Map<Integer, RTCPReport> map = this.sentReports;
        synchronized (map) {
            Collection<RTCPFeedback> values = this.sentFeedbacks.values();
            return values.toArray(new RTCPFeedback[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPReport getSentRTCPReport(int senderSSRC) {
        Map<Integer, RTCPReport> map = this.sentReports;
        synchronized (map) {
            return this.sentReports.get(senderSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPReport[] getSentRTCPReports() {
        Map<Integer, RTCPReport> map = this.sentReports;
        synchronized (map) {
            Collection<RTCPReport> values = this.sentReports.values();
            return values.toArray(new RTCPReport[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport.VoIPMetricsReportBlock[] getSentRTCPVoIPMetrics() {
        Map<Integer, RTCPExtendedReport> map = this.sentExtendedReports;
        synchronized (map) {
            Collection<RTCPExtendedReport.VoIPMetricsReportBlock> values = this.sentVoIPMetrics.values();
            return values.toArray(new RTCPExtendedReport.VoIPMetricsReportBlock[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTCPExtendedReport.VoIPMetricsReportBlock getSentRTCPVoIPMetrics(int sourceSSRC) {
        Map<Integer, RTCPExtendedReport> map = this.sentExtendedReports;
        synchronized (map) {
            return this.sentVoIPMetrics.get(sourceSSRC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTCPReportListener(RTCPReportListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.listenerSyncRoot;
        synchronized (object) {
            int index = this.listeners.indexOf(listener);
            if (index != -1) {
                if (this.listeners.size() == 1) {
                    this.listeners = Collections.emptyList();
                } else {
                    ArrayList<RTCPReportListener> newListeners = new ArrayList<RTCPReportListener>(this.listeners);
                    newListeners.remove(index);
                    this.listeners = Collections.unmodifiableList(newListeners);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpExtendedReportReceived(RTCPExtendedReport extendedReport) {
        boolean fire;
        if (extendedReport == null) {
            throw new NullPointerException("extendedReport");
        }
        Map<Integer, RTCPExtendedReport> map = this.receivedExtendedReports;
        synchronized (map) {
            RTCPExtendedReport oldValue = this.receivedExtendedReports.put(extendedReport.getSSRC(), extendedReport);
            if (((Object)((Object)extendedReport)).equals((Object)oldValue)) {
                fire = false;
            } else {
                if (extendedReport.getSystemTimeStamp() == 0L) {
                    extendedReport.setSystemTimeStamp(System.currentTimeMillis());
                }
                for (RTCPExtendedReport.ReportBlock reportBlock : extendedReport.getReportBlocks()) {
                    if (!(reportBlock instanceof RTCPExtendedReport.VoIPMetricsReportBlock)) continue;
                    RTCPExtendedReport.VoIPMetricsReportBlock voipMetrics = (RTCPExtendedReport.VoIPMetricsReportBlock)reportBlock;
                    this.receivedVoIPMetrics.put(voipMetrics.getSourceSSRC(), voipMetrics);
                }
                fire = true;
            }
        }
        if (fire) {
            for (RTCPReportListener listener : this.getRTCPReportListeners()) {
                listener.rtcpExtendedReportReceived(extendedReport);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Received " + (Object)((Object)extendedReport) + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpExtendedReportSent(RTCPExtendedReport extendedReport) {
        boolean fire;
        if (extendedReport == null) {
            throw new NullPointerException("extendedReport");
        }
        Map<Integer, RTCPExtendedReport> map = this.sentExtendedReports;
        synchronized (map) {
            RTCPExtendedReport oldValue = this.sentExtendedReports.put(extendedReport.getSSRC(), extendedReport);
            if (((Object)((Object)extendedReport)).equals((Object)oldValue)) {
                fire = false;
            } else {
                if (extendedReport.getSystemTimeStamp() == 0L) {
                    extendedReport.setSystemTimeStamp(System.currentTimeMillis());
                }
                for (RTCPExtendedReport.ReportBlock reportBlock : extendedReport.getReportBlocks()) {
                    if (!(reportBlock instanceof RTCPExtendedReport.VoIPMetricsReportBlock)) continue;
                    RTCPExtendedReport.VoIPMetricsReportBlock voipMetrics = (RTCPExtendedReport.VoIPMetricsReportBlock)reportBlock;
                    this.sentVoIPMetrics.put(voipMetrics.getSourceSSRC(), voipMetrics);
                }
                fire = true;
            }
        }
        if (fire) {
            for (RTCPReportListener listener : this.getRTCPReportListeners()) {
                listener.rtcpExtendedReportSent(extendedReport);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Sent " + (Object)((Object)extendedReport) + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpReportReceived(RTCPReport report) {
        boolean fire;
        if (report == null) {
            throw new NullPointerException("report");
        }
        Map<Integer, RTCPReport> map = this.receivedReports;
        synchronized (map) {
            RTCPReport oldValue = this.receivedReports.put((int)report.getSSRC(), report);
            if (report.equals(oldValue)) {
                fire = false;
            } else {
                Vector feedbacks;
                if (report.getSystemTimeStamp() == 0L) {
                    report.setSystemTimeStamp(System.currentTimeMillis());
                }
                if ((feedbacks = report.getFeedbackReports()) != null) {
                    for (RTCPFeedback feedback : feedbacks) {
                        this.receivedFeedbacks.put((int)feedback.getSSRC(), feedback);
                    }
                }
                fire = true;
            }
        }
        if (fire) {
            for (RTCPReportListener listener : this.getRTCPReportListeners()) {
                listener.rtcpReportReceived(report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpReportSent(RTCPReport report) {
        boolean fire;
        if (report == null) {
            throw new NullPointerException("report");
        }
        Map<Integer, RTCPReport> map = this.sentReports;
        synchronized (map) {
            RTCPReport oldValue = this.sentReports.put((int)report.getSSRC(), report);
            if (report.equals(oldValue)) {
                fire = false;
            } else {
                Vector feedbacks;
                if (report.getSystemTimeStamp() == 0L) {
                    report.setSystemTimeStamp(System.currentTimeMillis());
                }
                if ((feedbacks = report.getFeedbackReports()) != null) {
                    for (RTCPFeedback feedback : feedbacks) {
                        this.sentFeedbacks.put((int)feedback.getSSRC(), feedback);
                    }
                }
                fire = true;
            }
        }
        if (fire) {
            for (RTCPReportListener listener : this.getRTCPReportListeners()) {
                listener.rtcpReportSent(report);
            }
        }
    }
}

