/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.wireformats.ContentCreationException;
import com.google.gdata.wireformats.ObjectConverter;
import com.google.gdata.wireformats.XmlParser;
import java.io.IOException;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlHandler
extends XmlParser.ElementHandler {
    protected final ValidationContext vc;
    protected final Element parentElement;
    protected final ElementMetadata<?, ?> metadata;
    protected final Element element;

    public XmlHandler(ValidationContext vc, Element parent, Element element, ElementMetadata<?, ?> metadata) {
        this.vc = vc;
        this.parentElement = parent;
        this.element = element;
        this.metadata = metadata;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public void processAttribute(QName qn, String value) throws ParseException {
        AttributeKey<?> attKey;
        if (this.element.hasAttribute(qn)) {
            throw new ParseException(CoreErrorDomain.ERR.duplicateAttributeValue.withInternalReason("Duplicate value for attribute " + qn));
        }
        AttributeKey<?> attributeKey = attKey = this.metadata == null ? null : this.metadata.findAttribute(qn);
        if (attKey != null) {
            this.element.setAttributeValue(attKey, ObjectConverter.getValue(value, attKey.getDatatype()));
        } else {
            this.element.setAttributeValue(qn, (Object)value);
        }
    }

    @Override
    public XmlHandler getChildHandler(QName qName, Attributes attrs, List<XmlNamespace> namespaces) throws ParseException, IOException {
        Element parent;
        ElementMetadata<?, ?> childMeta = this.findMetadata(qName);
        Element childElement = this.createChildElement(qName, childMeta);
        if (childMeta != null && childMeta.getCardinality() == ElementMetadata.Cardinality.SET) {
            parent = this.element;
        } else {
            this.element.addElement(childElement);
            parent = null;
        }
        return this.createHandler(qName, parent, childElement, childMeta);
    }

    protected XmlHandler createHandler(QName qName, Element parent, Element child, ElementMetadata<?, ?> metadata) {
        return new XmlHandler(this.vc, parent, child, metadata);
    }

    protected ElementMetadata<?, ?> findMetadata(QName qName) {
        if (this.metadata == null) {
            return null;
        }
        ElementKey<?, ?> childKey = this.metadata.findElement(qName);
        if (childKey == null) {
            return null;
        }
        ElementMetadata<?, ?> childMeta = this.metadata.bindElement(childKey);
        return childMeta;
    }

    protected Element createChildElement(QName qName, ElementMetadata<?, ?> metadata) throws ParseException {
        if (metadata == null) {
            return new Element(qName);
        }
        try {
            return metadata.createElement();
        }
        catch (ContentCreationException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void processEndElement() throws ParseException {
        if (this.value != null) {
            this.value = this.value.trim();
            if (!this.value.equals("")) {
                ElementKey<?, ?> elementKey = this.element.getElementKey();
                this.element.setTextValue(ObjectConverter.getValue(this.value, elementKey.getDatatype()));
            }
        }
        if (this.parentElement != null) {
            this.parentElement.addElement(this.element);
        }
    }
}

