/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output;

import com.google.gdata.util.ContentType;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.output.CharacterGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlGenerator<S>
extends CharacterGenerator<S> {
    protected static final List<ContentType> XML_CONTENT_TYPES = Collections.unmodifiableList(Arrays.asList(ContentType.TEXT_XML, ContentType.TEXT_PLAIN));

    protected XmlWriter getXmlWriter(Writer w, OutputProperties outProps, String charset) throws IOException {
        EnumSet<XmlWriter.WriterFlags> writerFlags = EnumSet.of(XmlWriter.WriterFlags.WRITE_HEADER);
        if (this.usePrettyPrint(outProps)) {
            writerFlags.add(XmlWriter.WriterFlags.PRETTY_PRINT);
        }
        return new XmlWriter(w, writerFlags, charset);
    }

    protected static List<ContentType> createMatchingXmlList(ContentType ... types) {
        ArrayList<ContentType> matchingTypes = new ArrayList<ContentType>(types.length + XML_CONTENT_TYPES.size());
        for (ContentType contentType : types) {
            matchingTypes.add(contentType);
        }
        matchingTypes.addAll(XML_CONTENT_TYPES);
        return Collections.unmodifiableList(matchingTypes);
    }

    @Override
    public void generate(Writer w, OutputProperties outProps, S source) throws IOException {
        String charset = XmlGenerator.getCharsetEncoding(outProps);
        XmlWriter xw = this.getXmlWriter(w, outProps, charset);
        this.generateXml(xw, outProps, source);
        w.flush();
    }

    public abstract void generateXml(XmlWriter var1, OutputProperties var2, S var3) throws IOException;
}

