/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.MiscTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.DummyFailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionEventListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionSettings;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.StateBasedRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.TimeoutHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.TimerTimeoutHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ControllerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ChecksummingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectingToProxyEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.FileCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.LocallyCancelledEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ResolvingProxyEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.StartedControllerEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.StartingControllerEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.StoppingControllerEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.WaitingForConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SuccessfulStateInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;
import org.jetbrains.annotations.Nullable;

public abstract class RvConnectionImpl
implements RvConnection,
StateBasedRvConnection {
    private static final Logger LOGGER = Logger.getLogger(RvConnectionImpl.class.getName());
    private static final List<RvConnectionState> COOL_STATES = Arrays.asList(RvConnectionState.WAITING, RvConnectionState.PREPARING, RvConnectionState.CONNECTING, RvConnectionState.CONNECTED);
    private final RendezvousSessionHandler rvSessionHandler;
    private final CopyOnWriteArrayList<RvConnectionEventListener> listeners = new CopyOnWriteArrayList();
    private final EventPost eventPost = new EventPostImpl();
    private final ControllerListener controllerListener = new InternalControllerListener();
    private final List<StateChangeEvent> eventQueue = new CopyOnWriteArrayList();
    private final RvConnectionSettings settings = new RvConnectionSettings();
    private final RvSessionConnectionInfo sessionInfo;
    private final Screenname screenname;
    private StateController controller = null;
    @Nullable
    private StateController lastConnectionController = null;
    @Nullable
    private StateController retried = null;
    private boolean retriedLast = false;
    private StateController previousController = null;
    private RvConnectionState state = RvConnectionState.WAITING;
    private boolean done = false;
    private volatile TimeoutHandler timeoutHandler = new TimerTimeoutHandler(this);

    public static boolean isLanController(StateController oldController) {
        return oldController instanceof OutgoingConnectionController && ((OutgoingConnectionController)oldController).getTimeoutType() == ConnectionType.LAN;
    }

    public static boolean isInternetController(StateController oldController) {
        return oldController instanceof OutgoingConnectionController && ((OutgoingConnectionController)oldController).getTimeoutType() == ConnectionType.INTERNET;
    }

    protected RvConnectionImpl(AimProxyInfo proxy, Screenname myScreenname, RvSessionConnectionInfo rvsessioninfo) {
        this.rvSessionHandler = this.createSessionHandler();
        this.settings.setProxyInfo(proxy);
        this.sessionInfo = rvsessioninfo;
        this.screenname = myScreenname;
    }

    protected void fireEvent(RvConnectionEvent event) {
        assert (!Thread.holdsLock(this));
        for (RvConnectionEventListener listener : this.listeners) {
            listener.handleEvent(this, event);
        }
    }

    protected void fireStateChange(RvConnectionState newState, RvConnectionEvent event) {
        assert (!Thread.holdsLock(this));
        for (RvConnectionEventListener listener : this.listeners) {
            listener.handleEventWithStateChange(this, newState, event);
        }
    }

    public synchronized RvConnectionState getState() {
        return this.state;
    }

    public void setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
    }

    public TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    protected boolean startStateController(StateController controller) {
        return this.changeStateController(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean changeStateController(StateController newController) {
        StateController last;
        RvConnectionImpl rvConnectionImpl = this;
        synchronized (rvConnectionImpl) {
            StateController old = this.controller;
            if (!this.isValidNextController(old, newController)) {
                return false;
            }
            last = this.storeNextController(newController);
            assert (last == old);
        }
        this.stopThenStart(last, newController);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidNextController(StateController oldController, StateController newController) {
        ConnectedController conn;
        RvConnectionImpl rvConnectionImpl = this;
        synchronized (rvConnectionImpl) {
            if (this.done) {
                LOGGER.warning("Someone tried changing controller for " + this + " to " + newController + ", but we are done so it is being " + "ignored");
                return false;
            }
        }
        return !this.isConnectedController(oldController) || !(conn = (ConnectedController)oldController).isConnected() || this.canInterruptConnectedController(conn, newController);
    }

    private void stopThenStart(StateController last, StateController controller) {
        if (last != null) {
            this.fireEvent(new StoppingControllerEvent(last));
            last.stop();
        }
        if (controller != null) {
            this.fireEvent(new StartingControllerEvent(controller));
            controller.start(this, last);
            this.fireEvent(new StartedControllerEvent(controller));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean changeStateControllerFrom(StateController oldController, boolean succeeded) {
        StateController next;
        LOGGER.finer("Changing state controller from " + oldController);
        StateController virtualOldController = oldController;
        RvConnectionImpl rvConnectionImpl = this;
        synchronized (rvConnectionImpl) {
            if (this.controller == oldController) {
                NextStateControllerInfo nextInfo = this.getNextController();
                StateController stateController = next = nextInfo == null ? null : nextInfo.getController();
                if (!succeeded && next == null) {
                    if (!this.retriedLast && this.isSomeConnectionController(oldController)) {
                        this.retriedLast = true;
                        NextStateControllerInfo retryInfo = this.getControllerForRetryingLast(oldController);
                        next = this.queueEventsForNextController(retryInfo);
                        if (next != null) {
                            LOGGER.fine("Retrying last state controller " + next);
                        }
                        virtualOldController = this.previousController;
                    } else {
                        next = this.queueEventsForNextController(nextInfo);
                    }
                } else {
                    next = this.queueEventsForNextController(nextInfo);
                }
                if (!this.isValidNextController(oldController, next)) {
                    return false;
                }
                this.storeNextController(next);
            } else {
                next = null;
            }
        }
        this.flushEventQueue();
        this.stopThenStart(virtualOldController, next);
        return next != null;
    }

    private StateController queueEventsForNextController(NextStateControllerInfo nextInfo) {
        StateController next;
        if (nextInfo == null) {
            next = null;
        } else {
            next = nextInfo.getController();
            RvConnectionState state = nextInfo.getState();
            RvConnectionEvent event = nextInfo.getEvent();
            if (state != null) {
                if (event == null) {
                    event = new RvConnectionEvent(){};
                }
                this.queueStateChange(state, event);
            } else if (event != null) {
                this.queueEvent(event);
            }
        }
        return next;
    }

    protected synchronized NextStateControllerInfo getControllerForRetryingLast(StateController oldController) {
        if (this.previousController == null) {
            return null;
        }
        return this.getNextController(this.previousController, this.previousController.getEndStateInfo());
    }

    private synchronized StateController storeNextController(StateController controller) {
        StateController last;
        LOGGER.info("Transfer " + this + " changing to state controller " + controller);
        this.previousController = last = this.controller;
        this.controller = controller;
        if (this.isSomeConnectionController(controller)) {
            this.lastConnectionController = controller;
        }
        if (controller != null) {
            controller.addControllerListener(this.controllerListener);
        }
        return last;
    }

    public synchronized StateController getStateController() {
        return this.controller;
    }

    public RendezvousSessionHandler getRvSessionHandler() {
        return this.rvSessionHandler;
    }

    public boolean close() {
        this.setState(RvConnectionState.FAILED, new LocallyCancelledEvent());
        return true;
    }

    public void close(RvConnectionEvent error) {
        this.setState(RvConnectionState.FAILED, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(RvConnectionState state, RvConnectionEvent event) {
        StateController controller;
        assert (!Thread.holdsLock(this));
        RvConnectionImpl rvConnectionImpl = this;
        synchronized (rvConnectionImpl) {
            if (this.done) {
                return false;
            }
            assert (this.isValidChange(this.state, state));
            this.state = state;
            if (state == RvConnectionState.FAILED || state == RvConnectionState.FINISHED) {
                LOGGER.fine("New state for " + this + " is " + state + ", so we're done (from event " + event + ")");
                this.done = true;
            }
            controller = this.controller;
        }
        LOGGER.finer("Changing state of " + this + " to " + state + " because of " + event);
        if (state == RvConnectionState.FAILED) {
            this.sessionInfo.getRequestMaker().sendRvReject();
        }
        if (controller != null && (state == RvConnectionState.FAILED || state == RvConnectionState.FINISHED)) {
            controller.stop();
        }
        this.fireStateChange(state, event);
        return true;
    }

    private boolean isValidChange(RvConnectionState old, RvConnectionState state) {
        if (old.equals(state)) {
            return true;
        }
        int oidx = COOL_STATES.indexOf(old);
        int nidx = COOL_STATES.indexOf(state);
        if (oidx != -1 && nidx != -1) {
            return nidx >= oidx;
        }
        if (state == RvConnectionState.FINISHED && old == RvConnectionState.FAILED) {
            return false;
        }
        return state != RvConnectionState.FAILED || old != RvConnectionState.FINISHED;
    }

    public void addEventListener(RvConnectionEventListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    public void removeEventListener(RvConnectionEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public EventPost getEventPost() {
        return this.eventPost;
    }

    public Screenname getBuddyScreenname() {
        return new Screenname(this.sessionInfo.getRvSession().getScreenname());
    }

    protected synchronized void queueEvent(RvConnectionEvent event) {
        this.eventQueue.add(new StateChangeEvent(null, event));
    }

    protected synchronized void queueStateChange(RvConnectionState rvConnectionState, RvConnectionEvent event) {
        this.eventQueue.add(new StateChangeEvent(rvConnectionState, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEventQueue() {
        Iterator<StateChangeEvent> it;
        assert (!Thread.holdsLock(this));
        RvConnectionImpl rvConnectionImpl = this;
        synchronized (rvConnectionImpl) {
            it = this.eventQueue.iterator();
            this.eventQueue.clear();
        }
        while (it.hasNext()) {
            StateChangeEvent event = it.next();
            if (event.getState() == null) {
                this.fireEvent(event.getEvent());
                continue;
            }
            this.setState(event.getState(), event.getEvent());
        }
    }

    protected abstract RendezvousSessionHandler createSessionHandler();

    public RvConnectionSettings getSettings() {
        return this.settings;
    }

    public Screenname getMyScreenname() {
        return this.screenname;
    }

    public RvSessionConnectionInfo getRvSessionInfo() {
        return this.sessionInfo;
    }

    public synchronized NextStateControllerInfo getNextController() {
        StateController oldController = this.getStateController();
        return this.getNextController(oldController, oldController.getEndStateInfo());
    }

    private NextStateControllerInfo getNextController(StateController oldController, StateInfo endState) {
        LOGGER.finer("Getting next controller for " + oldController + " (ended with " + endState + ")");
        if (endState instanceof SuccessfulStateInfo) {
            if (this.isSomeConnectionController(oldController)) {
                return new NextStateControllerInfo(this.createConnectedController(endState));
            }
            return this.getNextControllerFromSuccess(oldController, endState);
        }
        if (endState instanceof FailedStateInfo) {
            if (this.isConnectedController(oldController) && !((ConnectedController)oldController).didConnect()) {
                NextStateControllerInfo next = this.getNextControllerFromConnectedError(oldController, endState, this.lastConnectionController);
                LOGGER.fine("Connection controller " + oldController + " failed; " + "moving from last connected controller " + this.lastConnectionController + " to " + next);
                return next;
            }
            return this.getNextControllerFromError(oldController, endState);
        }
        throw new IllegalStateException("Unknown previous state " + endState);
    }

    protected NextStateControllerInfo getNextControllerFromConnectedError(StateController oldController, StateInfo endState, StateController lastConnectionController) {
        return this.getNextControllerFromError(lastConnectionController, new DummyFailedStateInfo());
    }

    public boolean isOpen() {
        return this.getState().isOpen();
    }

    protected abstract NextStateControllerInfo getNextControllerFromError(StateController var1, StateInfo var2);

    protected abstract NextStateControllerInfo getNextControllerFromSuccess(StateController var1, StateInfo var2);

    protected abstract ConnectedController createConnectedController(StateInfo var1);

    protected abstract boolean isSomeConnectionController(StateController var1);

    protected boolean canInterruptConnectedController(ConnectedController connected, StateController newController) {
        return newController == null;
    }

    protected abstract boolean isConnectedController(StateController var1);

    @Nullable
    protected NextStateControllerInfo tryRetry(StateController oldController, RvConnectionEvent event, StateController newController) {
        if (event instanceof ConnectionTimedOutEvent && oldController != this.retried) {
            this.retried = newController;
            return new NextStateControllerInfo(newController);
        }
        return null;
    }

    public String toString() {
        return MiscTools.getClassName((Object)this) + " with " + this.getBuddyScreenname();
    }

    private class InternalControllerListener
    implements ControllerListener {
        private InternalControllerListener() {
        }

        public void handleControllerSucceeded(StateController c, SuccessfulStateInfo info) {
            this.goNext(c, true);
        }

        public void handleControllerFailed(StateController c, FailedStateInfo info) {
            this.goNext(c, false);
        }

        private void goNext(StateController c, boolean succeeded) {
            c.removeControllerListener(this);
            RvConnectionImpl.this.changeStateControllerFrom(c, succeeded);
        }
    }

    private class EventPostImpl
    implements EventPost {
        private EventPostImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(RvConnectionEvent event) {
            boolean fireState;
            RvConnectionState newState = null;
            RvConnectionImpl rvConnectionImpl = RvConnectionImpl.this;
            synchronized (rvConnectionImpl) {
                RvConnectionState oldState = RvConnectionImpl.this.state;
                if (event instanceof ConnectingEvent || event instanceof ConnectingToProxyEvent || event instanceof ResolvingProxyEvent || event instanceof WaitingForConnectionEvent) {
                    newState = RvConnectionState.CONNECTING;
                } else if (event instanceof ConnectedEvent) {
                    newState = RvConnectionState.CONNECTED;
                } else if (event instanceof TransferringFileEvent || event instanceof FileCompleteEvent) {
                    newState = FileTransferState.TRANSFERRING;
                } else if (event instanceof ChecksummingEvent && oldState == RvConnectionState.WAITING) {
                    newState = RvConnectionState.PREPARING;
                }
                if (!RvConnectionImpl.this.done && newState != null && newState != oldState) {
                    fireState = true;
                    RvConnectionImpl.this.state = newState;
                } else {
                    fireState = false;
                }
            }
            if (fireState) {
                RvConnectionImpl.this.fireStateChange(newState, event);
            } else {
                RvConnectionImpl.this.fireEvent(event);
            }
        }
    }

    protected static class StateChangeEvent {
        private RvConnectionState state;
        private RvConnectionEvent event;

        public StateChangeEvent(RvConnectionState state, RvConnectionEvent event) {
            this.state = state;
            this.event = event;
        }

        public RvConnectionState getState() {
            return this.state;
        }

        public RvConnectionEvent getEvent() {
            return this.event;
        }
    }
}

