/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.border.FocusStateMatteBorder;
import com.explodingpixels.macwidgets.BottomBarSize;
import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.painter.FocusStatePainter;
import com.explodingpixels.painter.GradientPainter;
import com.explodingpixels.widgets.WindowDragger;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class BottomBar {
    private final TriAreaComponent fBottomBar = new TriAreaComponent(5);

    public BottomBar(BottomBarSize size) {
        this.createAndInstallBackgroundPainter();
        this.createAndInstallBorder();
        this.fBottomBar.forceAreasToHaveTheSameWidth();
        int height = size.getHeight() + 2;
        this.fBottomBar.getComponent().setPreferredSize(new Dimension(-1, height));
    }

    public void addComponentToLeft(JComponent toolToAdd) {
        this.fBottomBar.addComponentToLeft(toolToAdd);
    }

    public void addComponentToLeft(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToLeft(toolToAdd, spacer_pixels);
    }

    public void addComponentToCenter(JComponent toolToAdd) {
        this.fBottomBar.addComponentToCenter(toolToAdd);
    }

    public void addComponentToCenter(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToCenter(toolToAdd, spacer_pixels);
    }

    public void addComponentToRight(JComponent toolToAdd) {
        this.fBottomBar.addComponentToRight(toolToAdd);
    }

    public void addComponentToRight(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToRight(toolToAdd, spacer_pixels);
    }

    public void installWindowDraggerOnWindow(Window window) {
        new WindowDragger(window, this.getComponent());
    }

    public JComponent getComponent() {
        return this.fBottomBar.getComponent();
    }

    private void createAndInstallBackgroundPainter() {
        GradientPainter focusedPainter = new GradientPainter(MacColorUtils.OS_X_BOTTOM_BAR_ACTIVE_TOP_COLOR, MacColorUtils.OS_X_BOTTOM_BAR_ACTIVE_BOTTOM_COLOR);
        GradientPainter unfocusedPainter = new GradientPainter(MacColorUtils.OS_X_BOTTOM_BAR_INACTIVE_TOP_COLOR, MacColorUtils.OS_X_BOTTOM_BAR_INACTIVE_BOTTOM_COLOR);
        FocusStatePainter painter = new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
        this.fBottomBar.setBackgroundPainter(painter);
    }

    private void createAndInstallBorder() {
        FocusStateMatteBorder outterBorder = new FocusStateMatteBorder(1, 0, 0, 0, MacColorUtils.OS_X_UNIFIED_TOOLBAR_FOCUSED_BOTTOM_COLOR, MacColorUtils.OS_X_UNIFIED_TOOLBAR_UNFOCUSED_BORDER_COLOR, this.fBottomBar.getComponent());
        MatteBorder innerBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, MacColorUtils.OS_X_BOTTOM_BAR_BORDER_HIGHLIGHT_COLOR);
        CompoundBorder lineBorders = BorderFactory.createCompoundBorder(outterBorder, innerBorder);
        int padding = 5;
        this.fBottomBar.getComponent().setBorder(BorderFactory.createCompoundBorder(lineBorders, BorderFactory.createEmptyBorder(0, padding, 0, padding)));
    }
}

