/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.painter.Painter;
import com.explodingpixels.swingx.EPToggleButton;
import com.explodingpixels.widgets.PopupMenuCustomizer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopdownButton {
    private final EPToggleButton fButton;
    private PopupMenuCustomizer fPopupMenuCustomizer;
    private JPopupMenu fPopupMenu = new JPopupMenu();

    public PopdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        if (popupMenuCustomizer == null) {
            throw new IllegalArgumentException("The list of items to add tothe popup menu cannot be null.");
        }
        this.fButton = new EPToggleButton(icon);
        this.fButton.setPressedIcon(icon);
        this.fPopupMenuCustomizer = popupMenuCustomizer;
        this.init();
    }

    private void init() {
        this.fButton.addMouseListener(this.createToggleButtonMouseListener());
        this.fButton.addMouseMotionListener(this.createToggleButtonMouseMotionListener());
        this.fPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.fButton.putClientProperty("doNotCancelPopup", preventHide);
    }

    public void setBackgroundPainter(Painter<AbstractButton> painter) {
        this.fButton.setBackgroundPainter(painter);
    }

    public JComponent getComponent() {
        return this.fButton;
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.fButton.setPressedIcon(pressedIcon);
    }

    private void showPopupMenu() {
        this.fPopupMenu.pack();
        this.fPopupMenu.show(this.fButton, 0, this.fButton.getHeight());
    }

    private void hidePopupMenu() {
        this.fPopupMenu.setVisible(false);
        this.fButton.setSelected(false);
    }

    private MouseListener createToggleButtonMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!PopdownButton.this.fButton.isSelected()) {
                    PopdownButton.this.hidePopupMenu();
                }
            }

            public void mousePressed(MouseEvent e) {
                PopdownButton.this.showPopupMenu();
            }

            public void mouseReleased(MouseEvent e) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.processMouseEvent(e);
            }
        };
    }

    private MouseMotionListener createToggleButtonMouseMotionListener() {
        return new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                PopdownButton.this.fPopupMenuCustomizer.customizePopup(PopdownButton.this.fPopupMenu);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                PopdownButton.this.fButton.setSelected(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }
}

