/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Profiler4JError;

public class ClassUtil {
    public static final AtomicLong totalWriteTime = new AtomicLong(0L);
    public static final AtomicLong totalReadTime = new AtomicLong(0L);
    private static final byte[] classBuffer = new byte[64000];
    private static File lockFile;
    private static FileLock lock;
    private static FileChannel channel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveClassBackup(String className, ClassLoader loader, byte[] classBytes) throws IOException {
        long t0 = System.nanoTime();
        try {
            File bkpFile = ClassUtil.getClassFile(className, loader);
            if (bkpFile.exists()) {
                throw new Profiler4JError("Backup file already exists: " + bkpFile);
            }
            Log.print(2, "saving backup " + bkpFile);
            FileOutputStream fos = new FileOutputStream(bkpFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            bos.write(classBytes);
            bos.close();
        }
        finally {
            long dt = System.nanoTime() - t0;
            totalWriteTime.addAndGet(dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadClassBackup(Class c) throws IOException {
        long t0 = System.nanoTime();
        try {
            File classFile = ClassUtil.getClassFile(c);
            if (classFile.exists()) {
                Log.print(2, "retrieving backup " + classFile);
                byte[] buffer = new byte[(int)classFile.length()];
                FileInputStream fis = new FileInputStream(classFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                bis.read(buffer);
                bis.close();
                byte[] byArray = buffer;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            long dt = System.nanoTime() - t0;
            totalReadTime.addAndGet(dt);
        }
    }

    public static File getClassFile(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return ClassUtil.getClassFile(clazz.getName(), loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadClassBytesAsResource(Class clazz) throws IOException {
        if (clazz.isSynthetic()) {
            throw new Profiler4JError("Cannot load a synthetic class");
        }
        String name = "/" + clazz.getName().replaceAll("\\.", "/") + ".class";
        InputStream is = clazz.getResourceAsStream(name);
        if (is == null) {
            throw new Profiler4JError("Could not find resource for " + clazz);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] byArray = classBuffer;
        synchronized (classBuffer) {
            int n = bis.read(classBuffer);
            byte[] buffer = new byte[n];
            System.arraycopy(classBuffer, 0, buffer, 0, n);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return buffer;
        }
    }

    public static File getClassFile(String className, ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String preffix = loader == null ? "BOOTCL_" : String.format("CL@%08X_", System.identityHashCode(loader));
        return new File(ClassUtil.getUninstrumentedDir(), preffix + className.replace('.', '_'));
    }

    public static File getUninstrumentedDir() {
        return new File(ClassUtil.getTempDir().getAbsolutePath(), "uninstrumented_classes");
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"), "profiler4j.tmp");
    }

    public static void releaseLock() {
        if (lock != null) {
            try {
                lock.release();
                channel.close();
                lock = null;
                channel = null;
                lockFile.delete();
                ClassUtil._removeTempDir();
                Log.print(0, "Lock released successfully");
            }
            catch (IOException e) {
                Log.print(0, "Caught an I/O error while releasing lock: " + e.getMessage());
            }
        }
    }

    private static void _removeTempDir() {
        Log.print(0, "Cleaning work directory...");
        File[] files = ClassUtil.getUninstrumentedDir().listFiles();
        if (files != null) {
            int n = 0;
            for (File f : files) {
                if (f.delete()) {
                    ++n;
                    continue;
                }
                f.deleteOnExit();
            }
            Log.print(0, "Removed " + n + " classes in backup dir");
        }
        ClassUtil.getUninstrumentedDir().deleteOnExit();
        ClassUtil.getTempDir().deleteOnExit();
    }

    public static boolean acquireLock() {
        ClassUtil.getTempDir().mkdirs();
        Log.print(0, "Work dir set to " + ClassUtil.getTempDir());
        try {
            Log.print(0, "Acquiring lock on work directory...");
            lockFile = new File(ClassUtil.getTempDir(), ".lock");
            channel = new RandomAccessFile(lockFile, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (IOException e) {
            throw new Profiler4JError("I/O error while acquiring lock", e);
        }
        if (lock == null) {
            Log.print(0, "ERROR: Another Profiler4j Agent is using the current work dir");
            return false;
        }
        if (ClassUtil.getTempDir().exists()) {
            ClassUtil._removeTempDir();
        }
        ClassUtil.getUninstrumentedDir().mkdirs();
        Log.print(0, "Lock acquired successfully");
        return true;
    }
}

