/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.profiler4j.console.LinkView;
import net.sf.profiler4j.console.util.hover.HoverWindow;

public class LinkHoverWindow
extends HoverWindow {
    private JLabel[] labels;
    private Font boldFont = new Font("Monospaced", 1, 12);
    private Font plainFont = new Font("Monospaced", 0, 12);
    private Color bgColor = Color.decode("#ffffaa");
    private JPanel panel;

    public LinkHoverWindow() {
        this.setLayout(new BorderLayout());
        this.setAlwaysOnTop(true);
        this.panel = new JPanel(new GridLayout(1, 1));
        this.add((Component)this.panel, "Center");
        this.panel.setBackground(this.bgColor);
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.labels = new JLabel[1];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel();
            this.labels[i].setFont(this.plainFont);
            this.panel.add(this.labels[i]);
        }
        this.labels[0].setFont(this.boldFont);
    }

    public boolean supportsElement(Object e) {
        return e instanceof LinkView;
    }

    public void prepareForElement(Object e) {
        LinkView link = (LinkView)e;
        this.labels[0].setText(String.format("Net: %.3fms", link.getSrc().method.getChildTime(link.getDst().method)));
        this.pack();
    }
}

