/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot {
    private Properties systemProperties;
    private Map<Integer, Method> methods;
    private long time;

    public static Snapshot load(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return Snapshot.read(bais);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Snapshot load(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            Snapshot snapshot = Snapshot.read(bis);
            return snapshot;
        }
        finally {
            bis.close();
        }
    }

    public static Snapshot read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        Snapshot snapshot = new Snapshot();
        if (dis.readInt() != -1162163712) {
            throw new IOException("Invalid magic number");
        }
        if (dis.readInt() != 1) {
            throw new IOException("Unsupported protocol version");
        }
        if (dis.readInt() != 1) {
            throw new IOException("Dump type mismath");
        }
        dis.readInt();
        snapshot.time = dis.readLong();
        int mCount = dis.readInt();
        snapshot.methods = new LinkedHashMap<Integer, Method>(mCount);
        for (int i = 0; i < mCount; ++i) {
            Method m = new Method();
            m.id = dis.readInt();
            m.name = dis.readUTF();
            m.hits = dis.readInt();
            m.netTime = (double)dis.readLong() / 1000000.0;
            m.selfTime = (double)dis.readLong() / 1000000.0;
            int childCount = dis.readInt();
            Method.access$502(m, new int[childCount]);
            Method.access$602(m, new long[childCount]);
            for (int j = 0; j < childCount; ++j) {
                ((Method)m).tmp_childrenIds[j] = dis.readInt();
                ((Method)m).tmp_childrenTimes[j] = dis.readLong();
            }
            snapshot.methods.put(m.id, m);
        }
        for (Method m : snapshot.methods.values()) {
            m.childrenTimes = new HashMap(m.tmp_childrenIds.length);
            for (int i = 0; i < m.tmp_childrenIds.length; ++i) {
                m.childrenTimes.put(snapshot.methods.get(m.tmp_childrenIds[i]), (double)m.tmp_childrenTimes[i] / 1000000.0);
            }
            Method.access$502(m, null);
            Method.access$602(m, null);
        }
        return snapshot;
    }

    public Map<Integer, Method> getMethods() {
        return this.methods;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public long getTime() {
        return this.time;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Method {
        private String className = null;
        private String classSimpleName = null;
        private String methodName = null;
        private int id;
        private String name;
        private double netTime;
        private double selfTime;
        private int hits;
        private Map<Method, Double> childrenTimes;
        private int[] tmp_childrenIds;
        private long[] tmp_childrenTimes;

        public double getTotalChildrenTime() {
            return this.netTime - this.selfTime;
        }

        public double getChildTime(Method method) {
            return this.childrenTimes.get(method);
        }

        public Map<Method, Double> getChildrenTimes() {
            return this.childrenTimes;
        }

        public int getHits() {
            return this.hits;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getMethodName() {
            if (this.methodName == null) {
                int p1 = this.name.indexOf(40);
                int p0 = this.name.substring(0, p1).lastIndexOf(46);
                this.methodName = this.name.substring(p0 + 1, p1);
            }
            return this.methodName;
        }

        public String getClassName() {
            if (this.className == null) {
                int p1 = this.name.indexOf(40);
                int p0 = this.name.substring(0, p1).lastIndexOf(46);
                this.className = this.name.substring(0, p0);
            }
            return this.className;
        }

        public String getClassSimpleName() {
            if (this.classSimpleName == null) {
                int p = this.getClassName().lastIndexOf(46);
                this.classSimpleName = p == -1 ? this.className : this.name.substring(p + 1);
            }
            return this.classSimpleName;
        }

        public double getSelfTime() {
            return this.selfTime;
        }

        public double getNetTime() {
            return this.netTime;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((Method)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        static /* synthetic */ int[] access$502(Method x0, int[] x1) {
            x0.tmp_childrenIds = x1;
            return x1;
        }

        static /* synthetic */ long[] access$602(Method x0, long[] x1) {
            x0.tmp_childrenTimes = x1;
            return x1;
        }
    }
}

