/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.util.hover;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import net.sf.profiler4j.console.util.hover.HoverWindow;
import net.sf.profiler4j.console.util.hover.HoverablePanel;

public class HoverManager
implements MouseMotionListener,
ActionListener {
    private int targetX;
    private int targetY;
    private HoverWindow activeHover;
    private HoverablePanel panel;
    private List<HoverWindow> hovers = new ArrayList<HoverWindow>();
    private Timer timer = new Timer(400, this);

    public void registerHover(HoverWindow h) {
        this.hovers.add(h);
    }

    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        Point p = this.panel.getLocationOnScreen();
        int screenX = p.x + this.targetX + 16;
        int screenY = p.y + this.targetY + 16;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension sdim = tk.getScreenSize();
        int correctionX = Math.max(screenX + this.activeHover.getWidth() - sdim.width + 36, 0);
        int correctionY = Math.max(screenY + this.activeHover.getHeight() - sdim.height + 42, 0);
        this.activeHover.setLocation(screenX - correctionX, screenY - correctionY);
        this.activeHover.setVisible(true);
    }

    public void setContainer(HoverablePanel panel) {
        if (this.panel != null) {
            this.panel.removeMouseMotionListener(this);
        }
        this.panel = panel;
        this.panel.addMouseMotionListener(this);
        if (this.activeHover != null) {
            this.activeHover.setVisible(false);
        }
        this.activeHover = null;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.disableHover();
        Object element = this.panel.findHoverable(e.getX(), e.getY());
        if (element != null) {
            for (HoverWindow hw : this.hovers) {
                if (!hw.supportsElement(element)) continue;
                this.activeHover = hw;
                this.targetX = e.getX();
                this.targetY = e.getY();
                hw.prepareForElement(element);
                this.timer.start();
                break;
            }
        }
    }

    private void disableHover() {
        this.timer.stop();
        if (this.activeHover != null && this.activeHover.isVisible()) {
            this.activeHover.setVisible(false);
        }
        this.activeHover = null;
    }

    public void reset() {
        this.disableHover();
    }
}

