/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.util.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.profiler4j.console.util.task.LongTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LongTaskExecutorDialog
extends JDialog {
    private static final Log log = LogFactory.getLog(LongTaskExecutorDialog.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JProgressBar progressBar = null;
    private JLabel label = null;
    private JScrollPane statusScrollPane = null;
    private JTextArea statusTextArea = null;
    private Throwable error;

    public LongTaskExecutorDialog(Frame owner) {
        super(owner);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setSize(486, 107);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("Remote Command Monitor");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.label = new JLabel();
            this.label.setBounds(new Rectangle(15, 16, 451, 15));
            this.label.setText("Long running task...");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.add((Component)this.getProgressBar(), null);
            this.jPanel.add((Component)this.label, null);
            this.jPanel.add((Component)this.getStatusScrollPane(), null);
        }
        return this.jPanel;
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setBounds(new Rectangle(15, 45, 451, 18));
            this.progressBar.setIndeterminate(true);
        }
        return this.progressBar;
    }

    private JScrollPane getStatusScrollPane() {
        if (this.statusScrollPane == null) {
            this.statusScrollPane = new JScrollPane();
            this.statusScrollPane.setBounds(new Rectangle(15, 75, 451, 256));
            this.statusScrollPane.setViewportView(this.getStatusTextArea());
        }
        return this.statusScrollPane;
    }

    private JTextArea getStatusTextArea() {
        if (this.statusTextArea == null) {
            this.statusTextArea = new JTextArea();
            this.statusTextArea.setBackground(SystemColor.info);
            this.statusTextArea.setFont(new Font("Monospaced", 0, 11));
            this.statusTextArea.setEditable(false);
        }
        return this.statusTextArea;
    }

    public void setMessage(String s) {
        this.label.setText(s);
    }

    public void runTask(final LongTask task) {
        this.label.setText("<html>Executing long-running task...");
        task.setDialog(this);
        Thread t = new Thread("PROFILER4J_TASK"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                log.debug((Object)"TASK STARTED");
                try {
                    task.executeInBackground();
                }
                catch (Throwable e) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                log.error((Object)"Caugh task error", e);
                                LongTaskExecutorDialog.this.error = e;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                log.debug((Object)"TASK COMPLETED");
                                if (LongTaskExecutorDialog.this.error != null) {
                                    LongTaskExecutorDialog.this.setDefaultCloseOperation(2);
                                    LongTaskExecutorDialog.this.progressBar.setIndeterminate(false);
                                    LongTaskExecutorDialog.this.setSize(486, 379);
                                    LongTaskExecutorDialog.this.setVisible(true);
                                    LongTaskExecutorDialog.this.toFront();
                                    ((JComponent)LongTaskExecutorDialog.this.statusTextArea.getParent()).revalidate();
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    LongTaskExecutorDialog.this.error.printStackTrace(pw);
                                    LongTaskExecutorDialog.this.statusTextArea.setText(sw.toString());
                                    LongTaskExecutorDialog.this.statusTextArea.setCaretPosition(0);
                                    task.setError(LongTaskExecutorDialog.this.error);
                                } else {
                                    LongTaskExecutorDialog.this.setVisible(false);
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        t.setName("LongTaskRunner");
        t.setPriority(1);
        t.setDaemon(false);
        t.start();
        this.setLocation(this.getLocation().x, this.getLocation().y - 120);
        this.setVisible(true);
    }
}

