/*
 * Decompiled with CFR 0.152.
 */
package ch.imvs.sdes4j.srtp;

import ch.imvs.sdes4j.SDesFactory;
import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import ch.imvs.sdes4j.srtp.SrtpCryptoSuite;
import ch.imvs.sdes4j.srtp.SrtpKeyParam;
import ch.imvs.sdes4j.srtp.SrtpSessionParam;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class SrtpSDesFactory
implements SDesFactory {
    private Random r = null;

    public SrtpCryptoAttribute createCryptoAttribute(int tag, String keyAlg) {
        return this.createCryptoAttribute(tag, keyAlg, null);
    }

    public SrtpCryptoAttribute createCryptoAttribute(int tag, String keyAlg, SrtpSessionParam[] params) {
        SrtpCryptoSuite suite = this.createCryptoSuite(keyAlg);
        byte[] keyData = new byte[(suite.getEncKeyLength() + suite.getSaltKeyLength()) / 8];
        this.getRandom().nextBytes(keyData);
        SrtpKeyParam key = new SrtpKeyParam("inline", keyData, 0, 0, 0);
        return new SrtpCryptoAttribute(tag, suite, new SrtpKeyParam[]{key}, params);
    }

    private Random getRandom() {
        if (this.r == null) {
            try {
                this.r = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                this.r = new SecureRandom();
            }
        }
        return this.r;
    }

    public void setRandomGenerator(Random r) {
        this.r = r;
    }

    public SrtpCryptoAttribute createCryptoAttribute() {
        return new SrtpCryptoAttribute();
    }

    public SrtpCryptoSuite createCryptoSuite(String suite) {
        return new SrtpCryptoSuite(suite);
    }

    public SrtpKeyParam createKeyParam(String keyParam) {
        return new SrtpKeyParam(keyParam);
    }

    public SrtpKeyParam[] createKeyParamArray(int size) {
        return new SrtpKeyParam[size];
    }

    public SrtpSessionParam createSessionParam(String sessionParam) {
        return SrtpSessionParam.create(sessionParam);
    }

    public SrtpSessionParam[] createSessionParamArray(int size) {
        return new SrtpSessionParam[size];
    }
}

