/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.rmic.DefaultRmicAdapter;
import org.apache.tools.ant.types.Commandline;

public class WLRmic
extends DefaultRmicAdapter {
    public static final String WLRMIC_CLASSNAME = "weblogic.rmic";
    public static final String COMPILER_NAME = "weblogic";
    public static final String ERROR_NO_WLRMIC_ON_CLASSPATH = "Cannot use WebLogic rmic, as it is not available.  A common solution is to set the environment variable CLASSPATH.";
    public static final String ERROR_WLRMIC_FAILED = "Error starting WebLogic rmic: ";
    public static final String WL_RMI_STUB_SUFFIX = "_WLStub";
    public static final String WL_RMI_SKEL_SUFFIX = "_WLSkel";
    static /* synthetic */ Class array$Ljava$lang$String;

    public boolean execute() throws BuildException {
        this.getRmic().log("Using WebLogic rmic", 3);
        Commandline cmd = this.setupRmicCommand(new String[]{"-noexit"});
        AntClassLoader loader = null;
        try {
            Class<?> c = null;
            if (this.getRmic().getClasspath() == null) {
                c = Class.forName(WLRMIC_CLASSNAME);
            } else {
                loader = this.getRmic().getProject().createClassLoader(this.getRmic().getClasspath());
                c = Class.forName(WLRMIC_CLASSNAME, true, loader);
            }
            Method doRmic = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WLRmic.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            doRmic.invoke(null, new Object[]{cmd.getArguments()});
            boolean bl = true;
            return bl;
        }
        catch (ClassNotFoundException ex) {
            throw new BuildException(ERROR_NO_WLRMIC_ON_CLASSPATH, this.getRmic().getLocation());
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException(ERROR_WLRMIC_FAILED, ex, this.getRmic().getLocation());
        }
        finally {
            if (loader != null) {
                loader.cleanup();
            }
        }
    }

    public String getStubClassSuffix() {
        return WL_RMI_STUB_SUFFIX;
    }

    public String getSkelClassSuffix() {
        return WL_RMI_SKEL_SUFFIX;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

