/*
 * Decompiled with CFR 0.152.
 */
package ymsg.support;

import java.awt.Color;
import java.util.Enumeration;

class FadeEnumeration
implements Enumeration {
    private int index;
    private Section[] fades;

    FadeEnumeration(Color[] colorArray, int n) {
        int n2;
        if (colorArray.length == 1) {
            Color[] colorArray2 = new Color[]{colorArray[0], colorArray[0]};
            colorArray = colorArray2;
        }
        this.fades = new Section[colorArray.length];
        float f = (float)(n - 1) / (float)(colorArray.length - 1);
        for (n2 = 0; n2 < colorArray.length - 1; ++n2) {
            int n3 = (int)(f * (float)(n2 + 1)) - (int)(f * (float)n2);
            this.fades[n2] = new Section(colorArray[n2], colorArray[n2 + 1], n3);
        }
        this.fades[n2] = new Section(colorArray[n2], colorArray[n2], 1);
        this.index = 0;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.index < this.fades.length - 1) {
            return true;
        }
        return this.fades[this.index].hasMoreElements();
    }

    public Object nextElement() {
        while (!this.fades[this.index].hasMoreElements() && this.index < this.fades.length) {
            ++this.index;
        }
        if (this.index >= this.fades.length) {
            return null;
        }
        return this.fades[this.index].nextElement();
    }

    private class Section
    implements Enumeration {
        private float scaleR;
        private float scaleG;
        private float scaleB;
        private int startR;
        private int startG;
        private int startB;
        private int size;
        private int index;

        Section(Color color, Color color2, int n) {
            this.startR = color.getRed();
            this.startG = color.getGreen();
            this.startB = color.getBlue();
            this.size = n;
            this.scaleR = (float)(color2.getRed() - this.startR) / (float)this.size;
            this.scaleG = (float)(color2.getGreen() - this.startG) / (float)this.size;
            this.scaleB = (float)(color2.getBlue() - this.startB) / (float)this.size;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            int n = this.index % this.size;
            Color color = new Color((int)((float)this.startR + this.scaleR * (float)n), (int)((float)this.startG + this.scaleG * (float)n), (int)((float)this.startB + this.scaleB * (float)n));
            ++this.index;
            return color;
        }
    }
}

