/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.soap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingQRY;
import net.sf.jml.protocol.soap.ContactList;
import net.sf.jml.protocol.soap.DummyTrustManager;
import net.sf.jml.protocol.soap.SSO;
import net.sf.jml.protocol.soap.XmlEntity;
import net.sf.jml.util.Base64;
import net.sf.jml.util.XmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIM {
    private static final String oim_url = "https://rsi.hotmail.com/rsi/rsi.asmx";
    private static final String oim_getmetadat_soap = "http://www.hotmail.msn.com/ws/2004/09/oim/rsi/GetMetadata";
    private static final String oim_getmsgs_soap = "http://www.hotmail.msn.com/ws/2004/09/oim/rsi/GetMessage";
    private static final String oim_deletemsgs_soap = "http://www.hotmail.msn.com/ws/2004/09/oim/rsi/DeleteMessages";
    private static final String oim_send_url = "https://ows.messenger.msn.com/OimWS/oim.asmx";
    private static final String oim_send_soap = "http://messenger.live.com/ws/2006/09/oim/Store2";
    private static final Log logger = LogFactory.getLog(OIM.class);
    private SSO sso;
    private MsnSession session;
    private static boolean postDel = true;
    private static int sentMsgNumber = 1;
    private String lockkey = "e745d4e406790fb5c5ca70041fbe06df";
    ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
    DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
    HttpParams params = null;
    BasicHttpProcessor httpproc = null;

    public OIM(MsnSession session) {
        this.sso = session.getSSO();
        this.session = session;
    }

    public Iterator<MsnInstantMessage> getOfflineMessages() {
        return null;
    }

    public static String[] parseMdata(String mdata) {
        Document doc;
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setIgnoringComments(true);
        try {
            DocumentBuilder docBuilder = dbfactory.newDocumentBuilder();
            ByteArrayInputStream in = new ByteArrayInputStream(mdata.getBytes());
            doc = docBuilder.parse(in);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(OIM.class.getName()).log(Level.SEVERE, null, ex);
            return new String[0];
        }
        catch (SAXException ex) {
            Logger.getLogger(OIM.class.getName()).log(Level.SEVERE, null, ex);
            return new String[0];
        }
        catch (IOException ex) {
            Logger.getLogger(OIM.class.getName()).log(Level.SEVERE, null, ex);
            return new String[0];
        }
        return OIM.getMsgIds(doc.getDocumentElement());
    }

    private static String[] getMsgIds(Element parent) {
        List els = XmlUtils.findChildrenByChain(parent, new String[]{"M", "I"});
        String[] res = new String[els.size()];
        int c = 0;
        for (Element e : els) {
            res[c++] = XmlUtils.getText(e);
        }
        return res;
    }

    private String getMetaDataStr() {
        String t = this.sso.getWebTicket();
        String tt = t.substring(t.indexOf("t=") + 2, t.indexOf("&p="));
        String pp = t.substring(t.indexOf("&p=") + 3);
        StringBuilder mess = new StringBuilder();
        mess.append("<?xml version=\"1.0\" encoding=\"utf-8\"?> ");
        mess.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" >");
        mess.append("  <soap:Header>");
        mess.append("    <PassportCookie xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">");
        mess.append("      <t>" + tt.replaceAll("&", "&amp;") + "</t> ");
        mess.append("      <p>" + pp.replaceAll("&", "&amp;") + "</p>");
        mess.append("    </PassportCookie>");
        mess.append("  </soap:Header>");
        mess.append("  <soap:Body>");
        mess.append("    <GetMetadata xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\" />");
        mess.append("  </soap:Body>");
        mess.append("</soap:Envelope>");
        try {
            HttpResponse resp = this.sendRequest(mess.toString(), oim_url, oim_getmetadat_soap);
            return EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            logger.error((Object)"send or receive mailinitdata!", (Throwable)e);
            return null;
        }
    }

    public List getMsgs(String mdata) {
        return null;
    }

    public void retrieveCurrentOfflineMessages(String mail) {
        if (mail == null) {
            return;
        }
        String[] ids = OIM.parseMdata(mail);
        ArrayList<OfflineMsg> oims = new ArrayList<OfflineMsg>();
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            OfflineMsg oim = this.getMessage(id);
            if (oim == null) continue;
            oims.add(oim);
        }
        Collections.sort(oims);
        for (OfflineMsg msg : oims) {
            ((AbstractMessenger)this.session.getMessenger()).fireOfflineMessageReceived(msg.body, msg.contentType, msg.encoding, msg.date, msg.contact);
        }
        if (ids.length > 0 && postDel) {
            this.deleteMessage(ids);
        }
    }

    public void retreiveOfflineMessages() {
        String resp = this.getMetaDataStr();
        if (resp == null) {
            return;
        }
        Element el = this.getDocumentElem(resp);
        Element msgs = XmlUtils.locateElement(el, "GetMetadataResponse", "xmlns", "http://www.hotmail.msn.com/ws/2004/09/oim/rsi");
        if (msgs == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)resp);
            }
            return;
        }
        String[] ids = OIM.getMsgIds((Element)msgs.getFirstChild());
        ArrayList<OfflineMsg> oims = new ArrayList<OfflineMsg>();
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            OfflineMsg oim = this.getMessage(id);
            if (oim == null) continue;
            oims.add(oim);
        }
        Collections.sort(oims);
        for (OfflineMsg msg : oims) {
            ((AbstractMessenger)this.session.getMessenger()).fireOfflineMessageReceived(msg.body, msg.contentType, msg.encoding, msg.date, msg.contact);
        }
        if (ids.length > 0 && postDel) {
            this.deleteMessage(ids);
        }
    }

    public OfflineMsg getMessage(String id) {
        String t = this.sso.getWebTicket();
        String tt = t.substring(t.indexOf("t=") + 2, t.indexOf("&p="));
        String pp = t.substring(t.indexOf("&p=") + 3);
        StringBuilder mess = new StringBuilder();
        mess.append("<?xml version=\"1.0\" encoding=\"utf-8\"?> ");
        mess.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" >");
        mess.append("  <soap:Header>");
        mess.append("    <PassportCookie xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">");
        mess.append("      <t>" + tt.replaceAll("&", "&amp;") + "</t> ");
        mess.append("      <p>" + pp.replaceAll("&", "&amp;") + "</p>");
        mess.append("    </PassportCookie>");
        mess.append("  </soap:Header>");
        mess.append("  <soap:Body>");
        mess.append("    <GetMessage xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">");
        mess.append("    <messageId>" + id + "</messageId>");
        mess.append("    <alsoMarkAsRead>true</alsoMarkAsRead>");
        mess.append("    </GetMessage>");
        mess.append("  </soap:Body>");
        mess.append("</soap:Envelope>");
        HttpResponse resp = this.sendRequest(mess.toString(), oim_url, oim_getmsgs_soap);
        String respStr = null;
        try {
            respStr = EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (resp.getStatusLine().getStatusCode() == 200) {
            try {
                return this.parseMessage(respStr);
            }
            catch (Exception e) {
                logger.error((Object)"Error parsing msg!", (Throwable)e);
            }
        } else {
            logger.error((Object)("Error sending request to retreive offline msg! " + respStr));
        }
        return null;
    }

    public void deleteMessage(String[] ids) {
        String t = this.sso.getWebTicket();
        String tt = t.substring(t.indexOf("t=") + 2, t.indexOf("&p="));
        String pp = t.substring(t.indexOf("&p=") + 3);
        StringBuilder mess = new StringBuilder();
        mess.append("<?xml version=\"1.0\" encoding=\"utf-8\"?> ");
        mess.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" >");
        mess.append("  <soap:Header>");
        mess.append("    <PassportCookie xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">");
        mess.append("      <t>" + tt.replaceAll("&", "&amp;") + "</t> ");
        mess.append("      <p>" + pp.replaceAll("&", "&amp;") + "</p>");
        mess.append("    </PassportCookie>");
        mess.append("  </soap:Header>");
        mess.append("  <soap:Body>");
        mess.append("    <DeleteMessages xmlns=\"http://www.hotmail.msn.com/ws/2004/09/oim/rsi\">");
        mess.append("    <messageIds>");
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            mess.append("    <messageId>" + id + "</messageId>");
        }
        mess.append("    </messageIds>");
        mess.append("    </DeleteMessages>");
        mess.append("  </soap:Body>");
        mess.append("</soap:Envelope>");
        HttpResponse resp = this.sendRequest(mess.toString(), oim_url, oim_deletemsgs_soap);
        String respStr = null;
        try {
            respStr = EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (resp.getStatusLine().getStatusCode() != 200) {
            logger.error((Object)("Error deleting offline msg! " + respStr));
        }
    }

    private OfflineMsg parseMessage(String xml) throws Exception {
        Element el = XmlUtils.locateElement(this.getDocumentElem(xml), "GetMessageResponse", "xmlns", "http://www.hotmail.msn.com/ws/2004/09/oim/rsi");
        if (el == null) {
            logger.error((Object)("error parsing " + xml));
            return null;
        }
        Element el1 = XmlUtils.findChild(el, "GetMessageResult");
        if (el1 == null) {
            logger.error((Object)("error parsing " + xml));
            return null;
        }
        BufferedReader in = new BufferedReader(new StringReader(XmlUtils.getText(el1)));
        String from = null;
        String displayName = null;
        String contentType = null;
        String encoding = null;
        String body = null;
        Date date = null;
        int seqNum = -1;
        StringBuilder bodyBuilder = new StringBuilder();
        boolean isBodyReached = false;
        String line = null;
        while ((line = in.readLine()) != null) {
            if (isBodyReached) {
                bodyBuilder.append(line);
                continue;
            }
            if (line.startsWith("From")) {
                int ix1 = line.indexOf("&lt;");
                int ix1len = 1;
                if (ix1 == -1) {
                    ix1 = line.indexOf("<");
                } else {
                    ix1len = 4;
                }
                int ix2 = line.indexOf("&gt;");
                if (ix2 == -1) {
                    ix2 = line.indexOf(">");
                }
                if (ix1 == -1) {
                    from = line.replaceAll("From:", "").trim();
                    continue;
                }
                from = line.substring(ix1 + ix1len, ix2);
                continue;
            }
            if (line.startsWith("Content-Type")) {
                line = line.replaceAll("Content-Type:", "");
                StringTokenizer toks = new StringTokenizer(line, ";");
                while (toks.hasMoreTokens()) {
                    String t = toks.nextToken().trim();
                    if (t.contains("text")) {
                        contentType = t;
                        continue;
                    }
                    if (!t.contains("charset")) continue;
                    encoding = t.replaceAll("charset=", "");
                }
                continue;
            }
            if (line.startsWith("X-OIM-Sequence-Num")) {
                try {
                    seqNum = Integer.parseInt(line.replaceAll("X-OIM-Sequence-Num:", "").trim());
                }
                catch (Exception e) {}
                continue;
            }
            if (line.startsWith("X-OriginalArrivalTime: ")) {
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
                line = line.replaceAll("X-OriginalArrivalTime: ", "");
                line = line.substring(0, line.indexOf(46));
                try {
                    date = df.parse(line + " UTC");
                }
                catch (ParseException e) {
                    logger.error((Object)"Error parsing OIM date");
                }
                continue;
            }
            if (line.trim().length() != 0) continue;
            isBodyReached = true;
        }
        body = new String(Base64.decode(bodyBuilder.toString()), encoding);
        MsnContactImpl contact = (MsnContactImpl)this.session.getMessenger().getContactList().getContactByEmail(Email.parseStr(from));
        if (contact == null) {
            contact = new MsnContactImpl(this.session.getMessenger().getContactList());
            contact.setEmail(Email.parseStr(from));
            contact.setDisplayName(displayName);
        }
        return new OfflineMsg(body, contentType, encoding, contact, seqNum, date);
    }

    private Element getDocumentElem(String xml) {
        Document doc;
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setIgnoringComments(true);
        try {
            DocumentBuilder docBuilder = dbfactory.newDocumentBuilder();
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            doc = docBuilder.parse(in);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(ContactList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (SAXException ex) {
            Logger.getLogger(ContactList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ContactList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return doc.getDocumentElement();
    }

    private String getOfflineMsg(Email email, String txt) {
        StringBuilder mess = new StringBuilder();
        String displayName = new String();
        String finaltxt = new String();
        try {
            displayName = new String(Base64.encode(this.session.getMessenger().getOwner().getDisplayName().getBytes("UTF-8")));
            txt = new String(Base64.encode(txt.getBytes("UTF-8")));
            StringBuffer txtbuf = new StringBuffer(txt);
            for (int i = 1; i < txtbuf.length(); ++i) {
                if (i % 40 != 0) continue;
                txtbuf.insert(i, "\n");
            }
            finaltxt = txtbuf.toString();
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        mess.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        mess.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\n xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" >");
        mess.append("  <soap:Header>");
        mess.append("  <From memberName=\"" + this.session.getMessenger().getOwner().getEmail().getEmailAddress() + "\" friendlyName=\"=?utf-8?B?" + displayName + "?=\"\r\n xml:lang=\"nl-nl\"\r\n proxy=\"MSNMSGR\"\r\n xmlns=\"http://messenger.msn.com/ws/2004/09/oim/\"\r\n msnpVer=\"MSNP15\"\r\n buildVer=\"8.5.1288.816\"/>");
        mess.append("    <To memberName=\"" + email.getEmailAddress() + "\" xmlns=\"http://messenger.msn.com/ws/2004/09/oim/\"/>");
        mess.append("    <Ticket passport=\"" + this.sso.getOimTicket().replaceAll("&", "&amp;") + "\"\r\n appid=\"PROD0119GSJUC$18\"\r\n lockkey=\"" + this.lockkey + "\"\r\n xmlns=\"http://messenger.msn.com/ws/2004/09/oim/\"/>");
        mess.append("    <Sequence xmlns=\"http://schemas.xmlsoap.org/ws/2003/03/rm\">\r\n");
        mess.append("      <Identifier xmlns=\"http://schemas.xmlsoap.org/ws/2002/07/utility\">http://messenger.msn.com</Identifier>\r\n");
        mess.append("      <MessageNumber>" + sentMsgNumber + "</MessageNumber>\r\n");
        mess.append("    </Sequence>\r\n");
        mess.append("  </soap:Header>\r\n");
        mess.append("  <soap:Body>\r\n");
        mess.append("    <MessageType xmlns=\"http://messenger.msn.com/ws/2004/09/oim/\">text</MessageType>\r\n");
        mess.append("    <Content xmlns=\"http://messenger.msn.com/ws/2004/09/oim/\">MIME-Version: 1.0\r\n");
        mess.append("Content-Type: text/plain; charset=UTF-8\r\n");
        mess.append("Content-Transfer-Encoding: base64\r\n");
        mess.append("X-OIM-Message-Type: OfflineMessage\r\n");
        mess.append("X-OIM-Run-Id: {3A3BE82C-684D-4F4F-8005-CBE8D4F82BAD}\r\n");
        mess.append("X-OIM-Sequence-Num: " + sentMsgNumber + "\r\n\r\n");
        mess.append("      " + finaltxt + "");
        mess.append("  </Content>");
        mess.append("  </soap:Body>");
        mess.append("</soap:Envelope>");
        return mess.toString();
    }

    public void sendOfflineMsg(Email email, String txt) {
        ++sentMsgNumber;
        HttpResponse resp = this.sendRequest(this.getOfflineMsg(email, txt), oim_send_url, oim_send_soap);
        String respStr = null;
        try {
            respStr = EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resp.getStatusLine().getStatusCode() == 500) {
            Element el = XmlUtils.locateElement(this.getDocumentElem(respStr), "faultcode", "xmlns:q0", "http://messenger.msn.com/ws/2004/09/oim/");
            if (el != null) {
                String fault = XmlUtils.getText(el).toLowerCase();
                if (fault.indexOf("AuthenticationFailed".toLowerCase()) != -1) {
                    Element el1 = XmlUtils.locateElement(this.getDocumentElem(respStr), "LockKeyChallenge", "xmlns", "http://messenger.msn.com/ws/2004/09/oim/");
                    if (el1 != null) {
                        String k = XmlUtils.getText(el1).trim();
                        this.lockkey = new OutgoingQRY(this.session.getMessenger().getActualMsnProtocol()).calc(k);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("new lockkey " + this.lockkey));
                        }
                        resp = this.sendRequest(this.getOfflineMsg(email, txt), oim_send_url, oim_send_soap);
                        try {
                            respStr = EntityUtils.toString((HttpEntity)resp.getEntity());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (resp.getStatusLine().getStatusCode() != 200) {
                            logger.error((Object)("Error sending offline msg! " + respStr));
                        }
                    }
                } else {
                    logger.error((Object)"Unexpected 500 error");
                }
            } else {
                logger.error((Object)("Error sending offline msg! " + respStr));
            }
        } else if (resp.getStatusLine().getStatusCode() != 200) {
            logger.error((Object)("Error sending offline msg! " + respStr));
        }
    }

    private synchronized HttpResponse sendRequest(String body, String address, String soapAddress) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Will send body: " + body));
            }
            URL url = new URL(address);
            if (this.params == null) {
                this.params = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)this.params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)this.params, (String)"UTF-8");
                HttpProtocolParams.setUseExpectContinue((HttpParams)this.params, (boolean)false);
                this.httpproc = new BasicHttpProcessor();
                this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
                this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
                this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
                this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
                this.httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
            }
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            BasicHttpContext context = new BasicHttpContext(null);
            HttpHost host = new HttpHost(url.getHost(), 443, "https");
            context.setAttribute("http.connection", (Object)this.conn);
            context.setAttribute("http.target_host", (Object)host);
            if (!this.conn.isOpen()) {
                SSLContext sc = SSLContext.getInstance("SSLv3");
                TrustManager[] tma = new TrustManager[]{new DummyTrustManager()};
                sc.init(null, tma, null);
                SSLSocketFactory factory = sc.getSocketFactory();
                Socket socket = factory.createSocket(host.getHostName(), host.getPort());
                this.conn.bind(socket, this.params);
            }
            BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", url.getPath());
            request.setEntity((HttpEntity)new XmlEntity(body));
            context.setAttribute("http.request", (Object)request);
            request.setParams(this.params);
            if (soapAddress != null) {
                request.addHeader("SOAPAction", soapAddress);
            }
            request.addHeader("Host", url.getHost());
            httpexecutor.preProcess((HttpRequest)request, (HttpProcessor)this.httpproc, (HttpContext)context);
            HttpResponse response = httpexecutor.execute((HttpRequest)request, (HttpClientConnection)this.conn, (HttpContext)context);
            httpexecutor.postProcess(response, (HttpProcessor)this.httpproc, (HttpContext)context);
            if (!this.connStrategy.keepAlive(response, (HttpContext)context)) {
                this.conn.close();
            }
            return response;
        }
        catch (Exception e) {
            Logger.getLogger(ContactList.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public void setPostDel(boolean postDel) {
        OIM.postDel = postDel;
    }

    public boolean isPostDel() {
        return postDel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OfflineMsg
    implements Comparable<OfflineMsg> {
        String body;
        String contentType;
        String encoding;
        Date date;
        MsnContact contact;
        int seqNum;

        public OfflineMsg(String body, String contentType, String encoding, MsnContact contact, int seqNum, Date date) {
            this.body = body;
            this.contentType = contentType;
            this.encoding = encoding;
            this.contact = contact;
            this.seqNum = seqNum;
            this.date = date;
        }

        @Override
        public int compareTo(OfflineMsg o) {
            return this.seqNum - o.seqNum;
        }
    }
}

