/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;

public class BibLatexEntryTypes {
    public static final BibtexEntryType ARTICLE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Article";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "journaltitle", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"translator", "annotator", "commentator", "subtitle", "titleaddon", "editor", "editora", "editorb", "editorc", "journalsubtitle", "issuetitle", "issuesubtitle", "language", "origlanguage", "series", "volume", "number", "eid", "issue", "date", "month", "year", "pages", "version", "note", "issn", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "editor", "series", "volume", "number", "eid", "issue", "date", "month", "year", "pages", "note", "issn", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType BOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Book";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType INBOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Inbook";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"bookauthor", "editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"bookauthor", "editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType BOOKINBOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Bookinbook";
        }

        @Override
        public String[] getRequiredFields() {
            return INBOOK.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return INBOOK.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return INBOOK.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType SUPPBOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Suppbook";
        }

        @Override
        public String[] getRequiredFields() {
            return INBOOK.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return INBOOK.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return INBOOK.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType BOOKLET = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Booklet";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "howpublished", "type", "note", "location", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "howpublished", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType COLLECTION = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Collection";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"translator", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType INCOLLECTION = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Incollection";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "booktitle", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"translator", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType SUPPCOLLECTION = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Suppcollection";
        }

        @Override
        public String[] getRequiredFields() {
            return INCOLLECTION.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return INCOLLECTION.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return INCOLLECTION.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType MANUAL = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Manual";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "edition", "type", "series", "number", "version", "note", "organization", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "edition", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType MISC = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Misc";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "howpublished", "type", "version", "note", "organization", "location", "date", "month", "year", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "howpublished", "location", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType ONLINE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Online";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "year", "date", "url"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "version", "note", "organization", "date", "month", "year", "addendum", "pubstate", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "note", "organization", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType PATENT = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Patent";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "number", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"holder", "subtitle", "titleaddon", "type", "version", "location", "note", "date", "month", "year", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"holder", "subtitle", "titleaddon", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType PERIODICAL = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Periodical";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editora", "editorb", "editorc", "subtitle", "issuetitle", "issuesubtitle", "language", "series", "volume", "number", "issue", "date", "month", "year", "note", "issn", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "issuetitle", "issuesubtitle", "issn", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType SUPPPERIODICAL = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Suppperiodical";
        }

        @Override
        public String[] getRequiredFields() {
            return ARTICLE.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return ARTICLE.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return ARTICLE.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType PROCEEDINGS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Proceedings";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"editor", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "eventtitle", "eventdate", "venue", "language", "volume", "part", "volumes", "series", "number", "note", "organization", "publisher", "location", "month", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "eventtitle", "volume", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType INPROCEEDINGS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Inproceedings";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "editor", "title", "booktitle", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "eventtitle", "eventdate", "venue", "language", "volume", "part", "volumes", "series", "number", "note", "organization", "publisher", "location", "month", "isbn", "chapter", "pages", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon", "eventtitle", "volume", "publisher", "isbn", "chapter", "pages", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType REFERENCE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Reference";
        }

        @Override
        public String[] getRequiredFields() {
            return COLLECTION.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return COLLECTION.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return COLLECTION.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType INREFERENCE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Inreference";
        }

        @Override
        public String[] getRequiredFields() {
            return INCOLLECTION.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return INCOLLECTION.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return INCOLLECTION.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType REPORT = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Report";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "type", "institution", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "number", "version", "note", "location", "month", "isrn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "number", "isrn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType SET = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Set";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"entryset", "crossref"};
        }

        @Override
        public String[] getOptionalFields() {
            return null;
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return null;
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType THESIS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Thesis";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "type", "institution", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "note", "location", "month", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType UNPUBLISHED = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Unpublished";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "language", "howpublished", "note", "location", "date", "month", "year", "addendum", "pubstate", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "howpublished", "pubstate", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType CONFERENCE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Conference";
        }

        @Override
        public String[] getRequiredFields() {
            return INPROCEEDINGS.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return INPROCEEDINGS.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return INPROCEEDINGS.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType ELECTRONIC = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Electronic";
        }

        @Override
        public String[] getRequiredFields() {
            return ONLINE.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return ONLINE.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return ONLINE.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType MASTERSTHESIS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Mastersthesis";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "institution", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "language", "note", "location", "month", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType PHDTHESIS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Phdthesis";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "institution", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "language", "note", "location", "month", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType TECHREPORT = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Techreport";
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "institution", "year", "date"};
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "language", "number", "version", "note", "location", "month", "isrn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "titleaddon", "type", "number", "isrn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprintclass", "eprinttype", "url", "urldate"};
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType WWW = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Www";
        }

        @Override
        public String[] getRequiredFields() {
            return ONLINE.getRequiredFields();
        }

        @Override
        public String[] getOptionalFields() {
            return ONLINE.getOptionalFields();
        }

        @Override
        public String[] getPrimaryOptionalFields() {
            return ONLINE.getPrimaryOptionalFields();
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType IEEETRANBSTCTL = new BibtexEntryType(){

        @Override
        public String getName() {
            return "IEEEtranBSTCTL";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"ctluse_article_number", "ctluse_paper", "ctluse_forced_etal", "ctlmax_names_forced_etal", "ctlnames_show_etal", "ctluse_alt_spacing", "ctlalt_stretch_factor", "ctldash_repeated_names", "ctlname_format_string", "ctlname_latex_cmd", "ctlname_url_prefix"};
        }

        @Override
        public String[] getRequiredFields() {
            return null;
        }

        @Override
        public String describeRequiredFields() {
            return "None";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return true;
        }
    };
}

