/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryContainer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.PdfPreviewPanel;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.Util;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.gui.PreviewPanelTransferHandler;

public class PreviewPanel
extends JPanel
implements VetoableChangeListener,
SearchTextListener,
EntryContainer {
    BibtexEntry entry;
    MetaData metaData;
    BibtexDatabase database;
    Layout layout;
    String layoutFile;
    public JEditorPane previewPane;
    JScrollPane scrollPane;
    PdfPreviewPanel pdfPreviewPanel;
    BasePanel panel;
    Action printAction;
    Action closeAction;
    private ArrayList<String> wordsToHighlight = null;

    public PreviewPanel(BibtexDatabase database, BibtexEntry entry, BasePanel panel, MetaData metaData, String layoutFile) {
        this(database, entry, panel, metaData, layoutFile, false);
    }

    public PreviewPanel(BibtexDatabase database, BibtexEntry entry, BasePanel panel, MetaData metaData, String layoutFile, boolean withPDFPreview) {
        this(panel, metaData, layoutFile, withPDFPreview);
        this.database = database;
        this.setEntry(entry);
    }

    public PreviewPanel(BasePanel panel, MetaData metaData, String layoutFile) {
        this(panel, metaData, layoutFile, false);
    }

    private PreviewPanel(BasePanel panel, MetaData metaData, String layoutFile, boolean withPDFPreview) {
        super(new BorderLayout(), true);
        withPDFPreview = withPDFPreview && JabRefPreferences.getInstance().getBoolean("pdfPreview");
        this.panel = panel;
        this.metaData = metaData;
        this.layoutFile = layoutFile;
        this.previewPane = this.createPreviewPane();
        this.pdfPreviewPanel = withPDFPreview ? new PdfPreviewPanel(metaData) : null;
        if (panel != null) {
            this.previewPane.setTransferHandler(new PreviewPanelTransferHandler(panel.frame(), this, this.previewPane.getTransferHandler()));
        }
        this.scrollPane = new JScrollPane(this.previewPane, 20, 31);
        this.scrollPane.setBorder(null);
        if (panel != null && JabRefPreferences.getInstance().getBoolean("previewPrintButton")) {
            this.add((Component)this.createToolBar(), "Before");
        }
        if (withPDFPreview) {
            JSplitPane splitPane = new JSplitPane(1, this.scrollPane, this.pdfPreviewPanel);
            splitPane.setOneTouchExpandable(true);
            int oneThird = 400;
            splitPane.setDividerLocation(oneThird * 2);
            this.add(splitPane);
        } else {
            this.add((Component)this.scrollPane, "Center");
        }
    }

    public Action getPrintAction() {
        if (this.printAction == null) {
            this.printAction = new PrintAction();
        }
        return this.printAction;
    }

    public Action getCloseAction() {
        if (this.closeAction == null) {
            this.closeAction = new CloseAction();
        }
        return this.closeAction;
    }

    JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getPrintAction());
        if (this.panel != null) {
            menu.add(this.panel.frame.switchPreview);
        }
        return menu;
    }

    JToolBar createToolBar() {
        JToolBar tlb = new JToolBar(1);
        JabRefPreferences prefs = JabRefPreferences.getInstance();
        Action printAction = this.getPrintAction();
        Action closeAction = this.getCloseAction();
        tlb.setMargin(new Insets(0, 0, 0, 2));
        ActionMap am = tlb.getActionMap();
        InputMap im = tlb.getInputMap(2);
        im.put(prefs.getKey("Close entry preview"), "close");
        am.put("close", closeAction);
        im.put(prefs.getKey("Print entry preview"), "print");
        am.put("print", printAction);
        tlb.setFloatable(false);
        tlb.add(closeAction);
        tlb.addSeparator();
        tlb.add(printAction);
        Component[] comps = tlb.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JComponent)comps[i]).setOpaque(false);
        }
        return tlb;
    }

    JEditorPane createPreviewPane() {
        JEditorPane previewPane = new JEditorPane(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        previewPane.setMargin(new Insets(3, 3, 3, 3));
        previewPane.setComponentPopupMenu(this.createPopupMenu());
        previewPane.setEditable(false);
        previewPane.setDragEnabled(true);
        previewPane.setContentType("text/html");
        previewPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String address = hyperlinkEvent.getURL().toString();
                        Util.openExternalViewer(PreviewPanel.this.metaData, address, "url");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return previewPane;
    }

    public void setDatabase(BibtexDatabase db) {
        this.database = db;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public void readLayout(String layoutFormat) throws Exception {
        this.layoutFile = layoutFormat;
        this.readLayout();
    }

    public void readLayout() throws Exception {
        StringReader sr = new StringReader(this.layoutFile.replaceAll("__NEWLINE__", "\n"));
        this.layout = new LayoutHelper(sr).getLayoutFromText("net.sf.jabref.export.layout.format.");
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setEntry(BibtexEntry newEntry) {
        if (newEntry != this.entry) {
            if (this.entry != null) {
                this.entry.removePropertyChangeListener(this);
            }
            newEntry.addPropertyChangeListener(this);
        }
        this.entry = newEntry;
        try {
            this.readLayout();
            this.update();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public BibtexEntry getEntry() {
        return this.entry;
    }

    public void update() {
        StringBuffer sb = new StringBuffer();
        ExportFormats.entryNumber = 1;
        if (this.entry != null) {
            sb.append(this.layout.doLayout(this.entry, this.database, this.wordsToHighlight));
        }
        this.previewPane.setText(sb.toString());
        this.previewPane.revalidate();
        final JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                bar.setValue(0);
            }
        });
        if (this.pdfPreviewPanel != null) {
            this.pdfPreviewPanel.updatePanel(this.entry);
        }
    }

    public boolean hasEntry() {
        return this.entry != null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.update();
    }

    @Override
    public void searchText(ArrayList<String> words) {
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.wordsToHighlight = words;
            this.update();
        } else if (this.wordsToHighlight != null) {
            this.wordsToHighlight = null;
            this.update();
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"), GUIGlobals.getImage("close"));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewPanel.this.panel.hideBottomComponent();
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(Globals.lang("Print Preview"), GUIGlobals.getImage("psSmall"));
            this.putValue("ShortDescription", Globals.lang("Print Preview"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
                        pras.add(new JobName(PreviewPanel.this.entry.getCiteKey(), null));
                        PreviewPanel.this.previewPane.print(null, null, true, null, pras, false);
                    }
                    catch (PrinterException e) {
                        JOptionPane.showMessageDialog(PreviewPanel.this, Globals.lang("Could not print preview") + ".\n" + e.getMessage(), Globals.lang("Printing Entry Preview"), 0);
                    }
                }
            }.start();
        }
    }
}

