/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Map;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;

public class SimpleSearchRule
implements SearchRule {
    final boolean m_caseSensitiveSearch;
    static RemoveLatexCommands removeBrackets = new RemoveLatexCommands();

    public SimpleSearchRule(boolean caseSensitive) {
        this.m_caseSensitiveSearch = caseSensitive;
    }

    @Override
    public boolean validateSearchStrings(Map<String, String> searchStrings) {
        return true;
    }

    @Override
    public int applyRule(Map<String, String> searchStrings, BibtexEntry bibtexEntry) {
        String searchString = searchStrings.values().iterator().next();
        if (!this.m_caseSensitiveSearch) {
            searchString = searchString.toLowerCase();
        }
        int score = 0;
        int counter = 0;
        for (String field : bibtexEntry.getAllFields()) {
            String fieldContentAsObject = bibtexEntry.getField(field);
            if (fieldContentAsObject != null) {
                try {
                    String fieldContent = removeBrackets.format(fieldContentAsObject.toString());
                    if (!this.m_caseSensitiveSearch) {
                        fieldContent = fieldContent.toLowerCase();
                    }
                    counter = fieldContent.indexOf(searchString, counter);
                    while (counter >= 0) {
                        ++score;
                        counter = fieldContent.indexOf(searchString, counter + 1);
                    }
                }
                catch (Throwable t) {
                    System.err.println("sorting error: " + t);
                }
            }
            counter = 0;
        }
        return score;
    }
}

