/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableRemoveString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringDialog
extends JDialog {
    BibtexDatabase base;
    JabRefFrame frame;
    BasePanel panel;
    JabRefPreferences prefs;
    TreeSet<BibtexString> stringsSet;
    Object[] strings;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    Container conPane = this.getContentPane();
    JToolBar tlb = new JToolBar();
    JPanel pan = new JPanel();
    StringTable table;
    HelpAction helpAction;
    CloseAction closeAction = new CloseAction(this);
    NewStringAction newStringAction = new NewStringAction(this);
    StoreContentAction storeContentAction = new StoreContentAction(this);
    RemoveStringAction removeStringAction = new RemoveStringAction(this);
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();

    public StringDialog(JabRefFrame frame, BasePanel panel, BibtexDatabase base, JabRefPreferences prefs) {
        super(frame);
        this.frame = frame;
        this.panel = panel;
        this.base = base;
        this.prefs = prefs;
        this.sortStrings();
        this.helpAction = new HelpAction(frame.helpDiag, "StringEditorHelp.html", "Help");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StringDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component c) {
                return super.accept(c) && c instanceof StringTable;
            }
        });
        this.setLocation(prefs.getInt("stringsPosX"), prefs.getInt("stringsPosY"));
        this.setSize(prefs.getInt("stringsSizeX"), prefs.getInt("stringsSizeY"));
        this.pan.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weighty = 1.0;
        this.con.weightx = 1.0;
        StringTableModel stm = new StringTableModel(this, base);
        this.table = new StringTable(stm);
        if (base.getStringCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.gbl.setConstraints(this.table.getPane(), this.con);
        this.pan.add(this.table.getPane());
        InputMap im = this.tlb.getInputMap(2);
        ActionMap am = this.tlb.getActionMap();
        im.put(prefs.getKey("String dialog, add string"), "add");
        am.put("add", this.newStringAction);
        im.put(prefs.getKey("String dialog, remove string"), "remove");
        am.put("remove", this.removeStringAction);
        im.put(prefs.getKey("Close dialog"), "close");
        am.put("close", this.closeAction);
        im.put(prefs.getKey("Help"), "help");
        am.put("help", this.helpAction);
        im.put(prefs.getKey("Undo"), "undo");
        am.put("undo", this.undoAction);
        im.put(prefs.getKey("Redo"), "redo");
        am.put("redo", this.redoAction);
        this.tlb.add(this.newStringAction);
        this.tlb.add(this.removeStringAction);
        this.tlb.addSeparator();
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        this.conPane.add((Component)this.tlb, "North");
        this.conPane.add((Component)this.pan, "Center");
        if (panel.getFile() != null) {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + panel.getFile().getName());
        } else {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + Globals.lang(GUIGlobals.untitledTitle));
        }
    }

    private void sortStrings() {
        this.stringsSet = new TreeSet<BibtexString>(new BibtexStringComparator(false));
        for (String s : this.base.getStringKeySet()) {
            this.stringsSet.add(this.base.getString(s));
        }
        this.strings = this.stringsSet.toArray();
    }

    public void refreshTable() {
        this.sortStrings();
        this.table.revalidate();
        this.table.clearSelection();
        this.table.repaint();
    }

    protected boolean isNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected void assureNotEditing() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", Globals.lang("Redo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringDialog.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", Globals.lang("Undo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringDialog.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RemoveStringAction
    extends AbstractAction {
        StringDialog parent;

        public RemoveStringAction(StringDialog parent) {
            super("Remove selected strings", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Remove selected strings"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = StringDialog.this.table.getSelectedRows();
            if (sel.length > 0) {
                StringDialog.this.assureNotEditing();
                String msg = Globals.lang("Really delete the selected") + " " + (sel.length > 1 ? sel.length + " " + Globals.lang("entries") : Globals.lang("entry")) + "?";
                int answer = JOptionPane.showConfirmDialog(this.parent, msg, Globals.lang("Delete strings"), 0, 3);
                if (answer == 0) {
                    CompoundEdit ce = new CompoundEdit();
                    for (int i = sel.length - 1; i >= 0; --i) {
                        BibtexString subject = (BibtexString)StringDialog.this.strings[sel[i]];
                        ce.addEdit(new UndoableRemoveString(StringDialog.this.panel, StringDialog.this.base, subject));
                        StringDialog.this.base.removeString(subject.getId());
                    }
                    ce.end();
                    StringDialog.this.panel.undoManager.addEdit(ce);
                    StringDialog.this.refreshTable();
                    if (StringDialog.this.base.getStringCount() > 0) {
                        StringDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                }
            }
        }
    }

    class StoreContentAction
    extends AbstractAction {
        StringDialog parent;

        public StoreContentAction(StringDialog parent) {
            super("Store string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Store string"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class NewStringAction
    extends AbstractAction {
        StringDialog parent;

        public NewStringAction(StringDialog parent) {
            super("New string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("New string"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(this.parent, (Object)Globals.lang("Please enter the string's label"));
            if (name == null) {
                return;
            }
            if (StringDialog.this.isNumber(name)) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                return;
            }
            if (name.indexOf("#") >= 0) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                return;
            }
            if (name.indexOf(" ") >= 0) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                return;
            }
            try {
                String newId = Util.createNeutralId();
                BibtexString bs = new BibtexString(newId, name, "");
                StringDialog.this.panel.undoManager.addEdit(new UndoableInsertString(StringDialog.this.panel, StringDialog.this.panel.database, bs));
                StringDialog.this.base.addString(bs);
                StringDialog.this.refreshTable();
                StringDialog.this.panel.markBaseChanged();
            }
            catch (KeyCollisionException ex) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        StringDialog parent;

        public CloseAction(StringDialog parent) {
            super("Close window");
            this.putValue("ShortDescription", Globals.lang("Close dialog"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringDialog.this.panel.stringsClosing();
            StringDialog.this.dispose();
            Point p = StringDialog.this.getLocation();
            Dimension d = StringDialog.this.getSize();
            StringDialog.this.prefs.putInt("stringsPosX", p.x);
            StringDialog.this.prefs.putInt("stringsPosY", p.y);
            StringDialog.this.prefs.putInt("stringsSizeX", d.width);
            StringDialog.this.prefs.putInt("stringsSizeY", d.height);
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        BibtexDatabase base;
        StringDialog parent;

        public StringTableModel(StringDialog parent, BibtexDatabase base) {
            this.parent = parent;
            this.base = base;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? ((BibtexString)StringDialog.this.strings[row]).getName() : ((BibtexString)StringDialog.this.strings[row]).getContent();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                if (!((String)value).equals(((BibtexString)StringDialog.this.strings[row]).getName())) {
                    if (this.base.hasStringLabel((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
                    } else if (((String)value).indexOf(" ") >= 0) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                    } else if (((String)value).indexOf("#") >= 0) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                    } else if (StringDialog.this.isNumber((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                    } else {
                        BibtexString subject = (BibtexString)StringDialog.this.strings[row];
                        StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, subject, true, subject.getName(), (String)value));
                        subject.setName((String)value);
                        StringDialog.this.panel.markBaseChanged();
                        StringDialog.this.refreshTable();
                    }
                }
            } else {
                BibtexString subject = (BibtexString)StringDialog.this.strings[row];
                if (!((String)value).equals(subject.getContent())) {
                    try {
                        new LatexFieldFormatter().format((String)value, "__dummy");
                    }
                    catch (IllegalArgumentException ex) {
                        return;
                    }
                    StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, subject, false, subject.getContent(), (String)value));
                    subject.setContent((String)value);
                    StringDialog.this.panel.markBaseChanged();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StringDialog.this.strings.length;
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? Globals.lang("Name") : Globals.lang("Content");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }

    class StringTable
    extends JTable {
        JScrollPane sp;

        public StringTable(StringTableModel stm) {
            super(stm);
            this.sp = new JScrollPane(this);
            this.setShowVerticalLines(true);
            this.setShowHorizontalLines(true);
            this.setColumnSelectionAllowed(true);
            DefaultCellEditor dce = new DefaultCellEditor(new JTextField());
            dce.setClickCountToStart(2);
            this.setDefaultEditor(String.class, dce);
            TableColumnModel cm = this.getColumnModel();
            cm.getColumn(0).setPreferredWidth(800);
            cm.getColumn(1).setPreferredWidth(2000);
            this.sp.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
            this.getInputMap().put(StringDialog.this.frame.prefs.getKey("Close dialog"), "close");
            this.getActionMap().put("close", StringDialog.this.closeAction);
            this.getInputMap().put(StringDialog.this.frame.prefs.getKey("Help"), "help");
            this.getActionMap().put("help", StringDialog.this.helpAction);
        }

        public JComponent getPane() {
            return this.sp;
        }
    }
}

