/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.TreeSet;

public class VerifyingWriter
extends OutputStreamWriter {
    CharsetEncoder encoder;
    private boolean couldEncodeAll = true;
    private TreeSet<Character> problemCharacters = new TreeSet();

    public VerifyingWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
        this.encoder = Charset.forName(encoding).newEncoder();
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
        if (!this.encoder.canEncode(str)) {
            for (int i = 0; i < str.length(); ++i) {
                if (this.encoder.canEncode(str.charAt(i))) continue;
                this.problemCharacters.add(new Character(str.charAt(i)));
            }
            this.couldEncodeAll = false;
        }
    }

    public boolean couldEncodeAll() {
        return this.couldEncodeAll;
    }

    public String getProblemCharacters() {
        StringBuffer chars = new StringBuffer();
        for (Character ch : this.problemCharacters) {
            chars.append(ch.charValue());
        }
        return chars.toString();
    }
}

