/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class ScifinderImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Scifinder";
    }

    @Override
    public String getCLIId() {
        return "scifinder";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        for (int i = 0; (str = in.readLine()) != null && i < 50; ++i) {
            if (!str.trim().equals("START_RECORD")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        String number = "";
        String country = "";
        String kindcode = "";
        while ((str = in.readLine()) != null) {
            sb.append(str);
        }
        String[] entries = sb.toString().split("START_RECORD");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 1; i < entries.length; ++i) {
            String[] fields = entries[i].split("FIELD ");
            String journal = null;
            String Type2 = "";
            hm.clear();
            for (int j = 0; j < fields.length; ++j) {
                String[] tmp;
                if (fields[j].indexOf(":") < 0 || (tmp = new String[]{fields[j].substring(0, fields[j].indexOf(":")), fields[j].substring(fields[j].indexOf(":") + 1).trim()}).length <= 1) continue;
                if (tmp[0].equals("Author")) {
                    hm.put("author", AuthorList.fixAuthor_lastNameFirst(tmp[1].replaceAll(";", " and ")));
                    continue;
                }
                if (tmp[0].equals("Title")) {
                    hm.put("title", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Journal Title")) {
                    journal = tmp[1];
                    continue;
                }
                if (tmp[0].equals("Volume")) {
                    hm.put("volume", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Page")) {
                    hm.put("pages", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Publication Year")) {
                    hm.put("year", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Abstract")) {
                    hm.put("abstract", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Supplementary Terms")) {
                    hm.put("keywords", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Inventor Name") && tmp[1].trim().length() > 0) {
                    hm.put("author", AuthorList.fixAuthor_lastNameFirst(tmp[1].replaceAll(";", " and ")));
                    continue;
                }
                if (tmp[0].equals("Patent Assignee")) {
                    hm.put("institution", tmp[1]);
                    continue;
                }
                if (tmp[0].equals("Patent Kind Code")) {
                    kindcode = " " + tmp[1];
                    continue;
                }
                if (tmp[0].equals("Patent Country")) {
                    country = tmp[1] + " ";
                    continue;
                }
                if (tmp[0].equals("Patent Number")) {
                    number = tmp[1];
                    continue;
                }
                if (tmp[0].equals("Priority Application Date")) {
                    hm.put("number", country + number + kindcode);
                    continue;
                }
                if (!tmp[0].equals("Document Type")) continue;
                Type2 = tmp[1].startsWith("Journal") || tmp[1].startsWith("Review") ? "article" : (tmp[1].equals("Dissertation") ? "phdthesis" : (tmp[1].equals("Patent") ? "patent" : (tmp[1].startsWith("Conference") ? "conference" : tmp[1])));
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            if (journal != null) {
                if (Type2.equals("conference")) {
                    b.setField("booktitle", journal);
                } else {
                    b.setField("journal", journal);
                }
            }
            bibitems.add(b);
        }
        return bibitems;
    }
}

