/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.mods.MODSEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MODSDatabase {
    protected Set<MODSEntry> entries;

    public MODSDatabase() {
        this.entries = new HashSet<MODSEntry>();
    }

    public MODSDatabase(BibtexDatabase bibtex) {
        this.addEntries(bibtex, bibtex.getKeySet());
    }

    public MODSDatabase(BibtexDatabase bibtex, Set<String> keySet) {
        if (keySet == null) {
            keySet = bibtex.getKeySet();
        }
        this.addEntries(bibtex, keySet);
    }

    private void addEntries(BibtexDatabase database, Set<String> keySet) {
        this.entries = new HashSet<MODSEntry>();
        Iterator<String> iter = keySet.iterator();
        while (iter.hasNext()) {
            BibtexEntry entry = database.getEntryById(iter.next());
            MODSEntry newMods = new MODSEntry(entry);
            this.entries.add(newMods);
        }
    }

    public Document getDOMrepresentation() {
        Document result = null;
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = dbuild.newDocument();
            Element modsCollection = result.createElement("modsCollection");
            modsCollection.setAttribute("xmlns", "http://www.loc.gov/mods/v3");
            modsCollection.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            modsCollection.setAttribute("xsi:schemaLocation", "http://www.loc.gov/mods/v3 http://www.loc.gov/standards/mods/v3/mods-3-0.xsd");
            for (MODSEntry entry : this.entries) {
                Element node = entry.getDOMrepresentation(result);
                modsCollection.appendChild(node);
            }
            result.appendChild(modsCollection);
        }
        catch (Exception e) {
            System.out.println("Exception caught..." + e);
            e.printStackTrace();
        }
        return result;
    }
}

