/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.oo.OOPreFormatter;

public class OOBibStyle
implements Comparable {
    public static final String UNDEFINED_CITATION_MARKER = "??";
    String name = null;
    SortedSet<String> journals = new TreeSet<String>();
    LayoutFormatter fieldFormatter = new OOPreFormatter();
    Layout defaultBibLayout;
    HashMap<String, Layout> bibLayout = new HashMap();
    HashMap properties = new HashMap();
    HashMap citProperties = new HashMap();
    Pattern numPattern = Pattern.compile("-?\\d+");
    boolean valid = false;
    static final int NONE = 0;
    static final int LAYOUT = 1;
    static final int PROPERTIES = 2;
    static final int CITATION = 3;
    static final int NAME = 4;
    static final int JOURNALS = 5;
    static final String LAYOUT_MRK = "LAYOUT";
    static final String PROPERTIES_MARK = "PROPERTIES";
    static final String CITATION_MARK = "CITATION";
    static final String NAME_MARK = "NAME";
    static final String JOURNALS_MARK = "JOURNALS";
    static final String DEFAULT_MARK = "default";
    private File styleFile = null;
    private static long styleFileModificationTime = Long.MIN_VALUE;
    private String COMBINED_ENTRIES_SEPARATOR = "-";
    private Pattern quoted = Pattern.compile("\".*\"");

    public OOBibStyle(File styleFile) throws Exception {
        this(new FileReader(styleFile));
        this.styleFile = styleFile;
        styleFileModificationTime = styleFile.lastModified();
    }

    public OOBibStyle(Reader in) throws Exception {
        this.properties.put("Title", "Bibliography");
        this.properties.put("SortAlgorithm", "alphanumeric");
        this.properties.put("IsSortByPosition", Boolean.FALSE);
        this.properties.put("IsNumberEntries", Boolean.FALSE);
        this.properties.put("BracketBefore", "[");
        this.properties.put("BracketAfter", "]");
        this.properties.put("ReferenceParagraphFormat", "Default");
        this.properties.put("ReferenceHeaderParagraphFormat", "Heading 1");
        this.citProperties.put("AuthorField", "author/editor");
        this.citProperties.put("YearField", "year");
        this.citProperties.put("MaxAuthors", 3);
        this.citProperties.put("MaxAuthorsFirst", -1);
        this.citProperties.put("AuthorSeparator", ", ");
        this.citProperties.put("AuthorLastSeparator", " & ");
        this.citProperties.put("AuthorLastSeparatorInText", null);
        this.citProperties.put("EtAlString", " et al.");
        this.citProperties.put("YearSeparator", ", ");
        this.citProperties.put("InTextYearSeparator", " ");
        this.citProperties.put("BracketBefore", "(");
        this.citProperties.put("BracketAfter", ")");
        this.citProperties.put("CitationSeparator", "; ");
        this.citProperties.put("PageInfoSeparator", "; ");
        this.citProperties.put("GroupedNumbersSeparator", "-");
        this.citProperties.put("MinimumGroupingCount", 3);
        this.citProperties.put("FormatCitations", Boolean.FALSE);
        this.citProperties.put("CitationCharacterFormat", "Default");
        this.citProperties.put("ItalicCitations", Boolean.FALSE);
        this.citProperties.put("BoldCitations", Boolean.FALSE);
        this.citProperties.put("SuperscriptCitations", Boolean.FALSE);
        this.citProperties.put("SubscriptCitations", Boolean.FALSE);
        this.citProperties.put("MultiCiteChronological", Boolean.TRUE);
        this.citProperties.put("BibtexKeyCitations", Boolean.FALSE);
        this.citProperties.put("ItalicEtAl", Boolean.FALSE);
        this.initialize(in);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.styleFile;
    }

    public Set<String> getJournals() {
        return Collections.unmodifiableSet(this.journals);
    }

    private void initialize(Reader in) throws IOException {
        this.name = null;
        this.readFormatFile(in);
    }

    public void ensureUpToDate() throws Exception {
        if (!this.isUpToDate()) {
            this.reload();
        }
    }

    public void reload() throws Exception {
        if (this.styleFile != null) {
            styleFileModificationTime = this.styleFile.lastModified();
            this.initialize(new FileReader(this.styleFile));
        }
    }

    public boolean isUpToDate() {
        if (this.styleFile != null) {
            return this.styleFile.lastModified() == styleFileModificationTime;
        }
        return true;
    }

    private void readFormatFile(Reader in) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = in.read()) != -1) {
            sb.append((char)c);
        }
        String[] lines = sb.toString().split("\n");
        int mode = 0;
        block8: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
            if (line.equals(NAME_MARK)) {
                mode = 4;
                continue;
            }
            if (line.equals(LAYOUT_MRK)) {
                mode = 1;
                continue;
            }
            if (line.equals(PROPERTIES_MARK)) {
                mode = 2;
                continue;
            }
            if (line.equals(CITATION_MARK)) {
                mode = 3;
                continue;
            }
            if (line.equals(JOURNALS_MARK)) {
                mode = 5;
                continue;
            }
            switch (mode) {
                case 4: {
                    if (line.trim().length() > 0) {
                        this.name = line.trim();
                    }
                }
                case 1: {
                    this.handleStructureLine(line);
                    continue block8;
                }
                case 2: {
                    this.handlePropertiesLine(line, this.properties);
                    continue block8;
                }
                case 3: {
                    this.handlePropertiesLine(line, this.citProperties);
                    continue block8;
                }
                case 5: {
                    this.handleJournalsLine(line);
                }
            }
        }
        if (mode != 0) {
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void handleStructureLine(String line) throws IOException {
        int index = line.indexOf("=");
        if (index > 0 && index < line.length() - 1) {
            String formatString = line.substring(index + 1);
            boolean setDefault = line.substring(0, index).equals(DEFAULT_MARK);
            String type = line.substring(0, index);
            try {
                Layout layout = new LayoutHelper(new StringReader(formatString)).getLayoutFromText("net.sf.jabref.export.layout.format.");
                if (setDefault) {
                    this.defaultBibLayout = layout;
                } else {
                    this.bibLayout.put(type.toLowerCase(), layout);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handlePropertiesLine(String line, HashMap map) throws IOException {
        int index = line.indexOf("=");
        if (index > 0 && index <= line.length() - 1) {
            String propertyName = line.substring(0, index).trim();
            String value = line.substring(index + 1);
            if (value.trim().length() > 2 && this.quoted.matcher(value.trim()).matches()) {
                value = value.trim().substring(1, value.trim().length() - 1);
            }
            Object toSet = value;
            if (this.numPattern.matcher(value).matches()) {
                toSet = Integer.parseInt(value);
            } else if (value.toLowerCase().trim().equals("true")) {
                toSet = Boolean.TRUE;
            } else if (value.toLowerCase().trim().equals("false")) {
                toSet = Boolean.FALSE;
            }
            map.put(propertyName, toSet);
        }
    }

    private void handleJournalsLine(String line) throws IOException {
        if (line.trim().length() > 0) {
            this.journals.add(line.trim());
        }
    }

    public Layout getReferenceFormat(String type) {
        Layout l = this.bibLayout.get(type.toLowerCase());
        if (l != null) {
            return l;
        }
        return this.defaultBibLayout;
    }

    public String getNumCitationMarker(int[] number, int minGroupingCount, boolean inList) {
        String bracketBefore = (String)this.citProperties.get("BracketBefore");
        if (inList && this.citProperties.get("BracketBeforeInList") != null) {
            bracketBefore = (String)this.citProperties.get("BracketBeforeInList");
        }
        String bracketAfter = (String)this.citProperties.get("BracketAfter");
        if (inList && this.citProperties.get("BracketAfterInList") != null) {
            bracketAfter = (String)this.citProperties.get("BracketAfterInList");
        }
        int[] lNum = new int[number.length];
        for (int i = 0; i < lNum.length; ++i) {
            lNum[i] = number[i];
        }
        Arrays.sort(lNum);
        StringBuilder sb = new StringBuilder(bracketBefore);
        int combineFrom = -1;
        int written = 0;
        for (int i = 0; i < lNum.length; ++i) {
            int i1 = lNum[i];
            if (combineFrom < 0) {
                if (i < lNum.length - 1 && lNum[i + 1] == i1 + 1) {
                    combineFrom = i1;
                    continue;
                }
                if (i > 0) {
                    sb.append((String)this.citProperties.get("CitationSeparator"));
                }
                sb.append(lNum[i] > 0 ? String.valueOf(lNum[i]) : UNDEFINED_CITATION_MARKER);
                ++written;
                continue;
            }
            if (i != lNum.length - 1 && lNum[i + 1] == i1 + 1) continue;
            if (written > 0) {
                sb.append((String)this.citProperties.get("CitationSeparator"));
            }
            if (minGroupingCount > 0 && i1 + 1 - combineFrom >= minGroupingCount) {
                sb.append(combineFrom);
                sb.append((String)this.citProperties.get("GroupedNumbersSeparator"));
                sb.append(i1);
                ++written;
            } else {
                for (int jj = combineFrom; jj <= i1; ++jj) {
                    sb.append(jj);
                    if (jj < i1) {
                        sb.append((String)this.citProperties.get("CitationSeparator"));
                    }
                    ++written;
                }
            }
            combineFrom = -1;
        }
        sb.append(bracketAfter);
        return sb.toString();
    }

    public String getCitationMarker(BibtexEntry entry, BibtexDatabase database, boolean inParenthesis, String uniquefier, int unlimAuthors) {
        return this.getCitationMarker(new BibtexEntry[]{entry}, database, inParenthesis, new String[]{uniquefier}, new int[]{unlimAuthors});
    }

    public String getCitationMarker(BibtexEntry[] entries, BibtexDatabase database, boolean inParenthesis, String[] uniquefiers, int[] unlimAuthors) {
        int piv = -1;
        String tmpMarker = null;
        if (uniquefiers != null) {
            for (int i = 0; i < uniquefiers.length; ++i) {
                if (uniquefiers[i] != null && uniquefiers[i].length() > 0) {
                    int prevALim;
                    String authorField = (String)this.citProperties.get("AuthorField");
                    int maxAuthors = (Integer)this.citProperties.get("MaxAuthors");
                    if (piv == -1) {
                        piv = i;
                        tmpMarker = this.getAuthorYearParenthesisMarker(new BibtexEntry[]{entries[i]}, database, authorField, (String)this.citProperties.get("YearField"), maxAuthors, (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), null, unlimAuthors);
                        continue;
                    }
                    String thisMarker = this.getAuthorYearParenthesisMarker(new BibtexEntry[]{entries[i]}, database, authorField, (String)this.citProperties.get("YearField"), maxAuthors, (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), null, unlimAuthors);
                    String author = this.getCitationMarkerField(entries[i], database, authorField);
                    AuthorList al = AuthorList.getAuthorList(author);
                    int n = prevALim = i > 0 ? unlimAuthors[i - 1] : unlimAuthors[0];
                    if (thisMarker.equals(tmpMarker) && (al.size() <= maxAuthors || unlimAuthors[i] == prevALim)) continue;
                    if (piv > -1 && i > piv + 1) {
                        this.group(entries, uniquefiers, piv, i - 1, (String)this.citProperties.get("UniquefierSeparator"));
                    }
                    tmpMarker = thisMarker;
                    piv = i;
                    continue;
                }
                if (piv > -1 && i > piv + 1) {
                    this.group(entries, uniquefiers, piv, i - 1, (String)this.citProperties.get("UniquefierSeparator"));
                }
                piv = -1;
            }
            if (piv >= 0) {
                this.group(entries, uniquefiers, piv, uniquefiers.length - 1, (String)this.citProperties.get("UniquefierSeparator"));
            }
        }
        if (inParenthesis) {
            return this.getAuthorYearParenthesisMarker(entries, database, (String)this.citProperties.get("AuthorField"), (String)this.citProperties.get("YearField"), (Integer)this.citProperties.get("MaxAuthors"), (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), uniquefiers, unlimAuthors);
        }
        String authorLastSeparator = (String)this.citProperties.get("AuthorLastSeparator");
        String alsInText = (String)this.citProperties.get("AuthorLastSeparatorInText");
        if (alsInText != null) {
            authorLastSeparator = alsInText;
        }
        return this.getAuthorYearInTextMarker(entries, database, (String)this.citProperties.get("AuthorField"), (String)this.citProperties.get("YearField"), (Integer)this.citProperties.get("MaxAuthors"), (String)this.citProperties.get("AuthorSeparator"), authorLastSeparator, (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("InTextYearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), uniquefiers, unlimAuthors);
    }

    private void group(BibtexEntry[] entries, String[] uniquefiers, int from, int to, String separator) {
        StringBuilder sb = new StringBuilder(uniquefiers[from]);
        for (int i = from + 1; i <= to; ++i) {
            sb.append(separator);
            sb.append(uniquefiers[i]);
            entries[i] = null;
        }
        uniquefiers[from] = sb.toString();
    }

    public String getAuthorYearParenthesisMarker(BibtexEntry[] entries, BibtexDatabase database, String authorField, String yearField, int maxA, String authorSep, String andString, String etAlString, String yearSep, String startBrace, String endBrace, String citationSeparator, String[] uniquifiers, int[] unlimAuthors) {
        StringBuffer sb = new StringBuffer(startBrace);
        for (int j = 0; j < entries.length; ++j) {
            String year;
            String author;
            int unlimA = unlimAuthors != null ? unlimAuthors[j] : -1;
            int maxAuthors = unlimA > 0 ? unlimA : maxA;
            BibtexEntry entry = entries[j];
            if (entry == null) continue;
            if (j > 0) {
                sb.append(citationSeparator);
            }
            if ((author = this.getCitationMarkerField(entry, database, authorField)) != null) {
                AuthorList al = AuthorList.getAuthorList(author);
                sb.append(this.getAuthorLastName(al, 0));
                if (al.size() > 1 && (al.size() <= maxAuthors || maxAuthors < 0)) {
                    for (int i = 1; i < al.size() - 1; ++i) {
                        sb.append(authorSep);
                        sb.append(this.getAuthorLastName(al, i));
                    }
                    sb.append(andString);
                    sb.append(this.getAuthorLastName(al, al.size() - 1));
                } else if (al.size() > maxAuthors) {
                    sb.append(etAlString);
                }
                sb.append(yearSep);
            }
            if ((year = this.getCitationMarkerField(entry, database, yearField)) != null) {
                sb.append(year);
            }
            if (uniquifiers == null || uniquifiers[j] == null) continue;
            sb.append(uniquifiers[j]);
        }
        sb.append(endBrace);
        return sb.toString();
    }

    public String getAuthorYearInTextMarker(BibtexEntry[] entries, BibtexDatabase database, String authorField, String yearField, int maxA, String authorSep, String andString, String etAlString, String yearSep, String startBrace, String endBrace, String citationSeparator, String[] uniquefiers, int[] unlimAuthors) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < entries.length; ++i) {
            String author;
            int maxAuthors;
            int unlimA = unlimAuthors != null ? unlimAuthors[i] : -1;
            int n = maxAuthors = unlimA > 0 ? unlimA : maxA;
            if (entries[i] == null) continue;
            if (i > 0) {
                sb.append(citationSeparator);
            }
            if ((author = this.getCitationMarkerField(entries[i], database, authorField)) != null) {
                AuthorList al = AuthorList.getAuthorList(author);
                if (al.size() > 0) {
                    sb.append(this.getAuthorLastName(al, 0));
                }
                if (al.size() > 1 && (al.size() <= maxAuthors || maxAuthors < 0)) {
                    for (int j = 1; j < al.size() - 1; ++j) {
                        sb.append(authorSep);
                        sb.append(this.getAuthorLastName(al, j));
                    }
                    sb.append(andString);
                    sb.append(this.getAuthorLastName(al, al.size() - 1));
                } else if (al.size() > maxAuthors) {
                    sb.append(etAlString);
                }
                sb.append(yearSep);
            }
            sb.append(startBrace);
            String year = this.getCitationMarkerField(entries[i], database, yearField);
            if (year != null) {
                sb.append(year);
            }
            if (uniquefiers != null && uniquefiers[i] != null) {
                sb.append(uniquefiers[i]);
            }
            sb.append(endBrace);
        }
        return sb.toString();
    }

    public String getCitationMarkerField(BibtexEntry entry, BibtexDatabase database, String field) {
        String[] fields = field.split("/");
        for (int i = 0; i < fields.length; ++i) {
            String s = fields[i];
            String content = BibtexDatabase.getResolvedField(s, entry, database);
            if (content == null || content.trim().length() <= 0) continue;
            if (this.fieldFormatter != null) {
                content = this.fieldFormatter.format(content);
            }
            return content;
        }
        return "";
    }

    public String getAuthorLastName(AuthorList al, int number) {
        StringBuilder sb = new StringBuilder();
        if (al.size() > number) {
            AuthorList.Author a = al.getAuthor(number);
            if (a.getVon() != null && a.getVon().length() > 0) {
                String von = a.getVon();
                sb.append(von);
                sb.append(' ');
            }
            sb.append(a.getLast());
        }
        return sb.toString();
    }

    public String insertPageInfo(String citation, String pageInfo) {
        String bracketAfter = this.getStringCitProperty("BracketAfter");
        if (citation.endsWith(bracketAfter)) {
            String first = citation.substring(0, citation.length() - bracketAfter.length());
            return first + this.getStringCitProperty("PageInfoSeparator") + pageInfo + bracketAfter;
        }
        return citation + this.getStringCitProperty("PageInfoSeparator") + pageInfo;
    }

    public boolean isNumberEntries() {
        return (Boolean)this.getProperty("IsNumberEntries");
    }

    public boolean isSortByPosition() {
        return (Boolean)this.getProperty("IsSortByPosition");
    }

    public boolean isItalicCitations() {
        return (Boolean)this.citProperties.get("ItalicCitations");
    }

    public boolean isBoldCitations() {
        return (Boolean)this.citProperties.get("BoldCitations");
    }

    public boolean isFormatCitations() {
        return (Boolean)this.citProperties.get("FormatCitations");
    }

    public boolean isBibtexKeyCiteMarkers() {
        return (Boolean)this.citProperties.get("BibtexKeyCitations");
    }

    public boolean getBooleanCitProperty(String key) {
        return (Boolean)this.citProperties.get(key);
    }

    public int getIntCitProperty(String key) {
        return (Integer)this.citProperties.get(key);
    }

    public String getStringCitProperty(String key) {
        return (String)this.citProperties.get(key);
    }

    public String getCitationCharacterFormat() {
        return (String)this.citProperties.get("CitationCharacterFormat");
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public int compareTo(Object o) {
        OOBibStyle other = (OOBibStyle)o;
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        return this.styleFile.equals(((OOBibStyle)o).styleFile);
    }
}

