/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstaller;

public class ManagePluginsDialog {
    private JabRefFrame frame;
    private JDialog diag;
    private SortedList<PluginInstaller.NameAndVersion> plugins;
    private SortedList<PluginInstaller.NameAndVersion> pluginsOther;
    private JTable table;
    private JTable tableOther;
    private TableFormat tableFormat;
    private TableFormat tableFormatOther;
    private JButton close = new JButton(Globals.lang("Close"));
    private JButton install = new JButton(Globals.lang("Install plugin"));
    private JButton download = new JButton(Globals.lang("Download plugin"));
    private JButton remove = new JButton(Globals.lang("Delete"));
    private JButton help = new JButton(Globals.lang("Help"));

    public ManagePluginsDialog(JabRefFrame frame) {
        this.frame = frame;
        this.diag = new JDialog(frame, Globals.lang("Plugin manager"), false);
        this.help.addActionListener(new HelpAction(Globals.helpDiag, "Plugin.html", "Help"));
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        JLabel lab = new JLabel(Globals.lang("Plugins installed in your user plugin directory (%0):", PluginCore.userPluginDir.getPath()));
        lab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pan.add((Component)lab, "North");
        this.table = new JTable();
        this.tableOther = new JTable();
        this.tableOther.setRowSelectionAllowed(false);
        this.tableOther.setColumnSelectionAllowed(false);
        this.tableOther.setCellSelectionEnabled(false);
        this.buildList();
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.tableOther.setPreferredScrollableViewportSize(new Dimension(500, 100));
        pan.add((Component)new JScrollPane(this.table), "Center");
        this.diag.getContentPane().add((Component)pan, "North");
        pan = new JPanel();
        pan.setLayout(new BorderLayout());
        lab = new JLabel(Globals.lang("Plugins installed in other locations:"));
        lab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pan.add((Component)lab, "North");
        pan.add((Component)new JScrollPane(this.tableOther), "Center");
        this.diag.getContentPane().add((Component)pan, "Center");
        ButtonBarBuilder b = new ButtonBarBuilder();
        b.addGlue();
        b.addButton((JComponent)this.install);
        b.addButton((JComponent)this.download);
        b.addButton((JComponent)this.remove);
        b.addButton((JComponent)this.close);
        b.addRelatedGap();
        b.addButton((JComponent)this.help);
        b.addGlue();
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)b.getPanel(), "South");
        this.diag.pack();
        this.diag.setLocationRelativeTo(frame);
        this.install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManagePluginsDialog.this.installPlugin();
            }
        });
        this.download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManagePluginsDialog.this.downloadPlugin();
            }
        });
        AbstractAction closeListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManagePluginsDialog.this.diag.dispose();
            }
        };
        this.close.addActionListener(closeListener);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManagePluginsDialog.this.removeSelected();
            }
        });
        ActionMap am = b.getPanel().getActionMap();
        InputMap im = b.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeListener);
    }

    private void removeSelected() {
        int[] sel = this.table.getSelectedRows();
        if (sel.length > 0) {
            int reply;
            String message = Globals.lang("Delete the %0 selected plugins?", String.valueOf(sel.length));
            String title = Globals.lang("Delete plugins");
            if (sel.length == 1) {
                message = Globals.lang("Delete the selected plugin?");
                title = Globals.lang("Delete plugin");
            }
            if ((reply = JOptionPane.showConfirmDialog(this.frame, message, title, 0)) != 0) {
                return;
            }
            boolean success = true;
            for (int i = 0; i < sel.length; ++i) {
                PluginInstaller.NameAndVersion nav = (PluginInstaller.NameAndVersion)this.plugins.get(sel[i]);
                success = PluginInstaller.deletePlugin(nav) & success;
            }
            if (!success) {
                JOptionPane.showMessageDialog(this.frame, sel.length > 1 ? Globals.lang("Plugins will be deleted next time JabRef starts up.") : Globals.lang("Plugin will be deleted next time JabRef starts up."), sel.length > 1 ? Globals.lang("Delete plugins") : Globals.lang("Delete plugin"), 1);
            }
            this.buildList();
        }
    }

    private void buildList() {
        this.plugins = new SortedList<PluginInstaller.NameAndVersion>(PluginInstaller.findInstalledPlugins());
        BasicEventList<PluginInstaller.NameAndVersion> outsideUserDir = new BasicEventList<PluginInstaller.NameAndVersion>();
        Iterator<PluginInstaller.NameAndVersion> i = this.plugins.iterator();
        while (i.hasNext()) {
            PluginInstaller.NameAndVersion nav = i.next();
            if (nav.inUserDirectory) continue;
            outsideUserDir.add(nav);
            i.remove();
        }
        this.pluginsOther = new SortedList(outsideUserDir);
        this.tableFormatOther = new PluginTableFormat();
        EventTableModel<PluginInstaller.NameAndVersion> tableModel = new EventTableModel<PluginInstaller.NameAndVersion>(this.pluginsOther, this.tableFormatOther);
        this.tableOther.setModel(tableModel);
        this.tableOther.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tableOther.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.tableOther.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.tableFormat = new PluginTableFormat();
        EventTableModel<PluginInstaller.NameAndVersion> tableModelOther = new EventTableModel<PluginInstaller.NameAndVersion>(this.plugins, this.tableFormat);
        this.table.setModel(tableModelOther);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
    }

    public void setVisible(boolean visible) {
        this.diag.setVisible(visible);
    }

    public void installPlugin() {
        String filename = FileDialogs.getNewFile(this.frame, new File(System.getProperty("user.home")), ".jar", 0, false);
        if (filename == null) {
            return;
        }
        File f = new File(filename);
        if (f != null) {
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ".", Globals.lang("Plugin installer"), 0);
            } else {
                this.installFromFile(f);
            }
        }
    }

    public void downloadPlugin() {
        String url = JOptionPane.showInputDialog(Globals.lang("Enter download URL"));
        if (url == null) {
            return;
        }
        try {
            this.installFromURL(new URL(url));
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL"), Globals.lang("Plugin installer"), 0);
        }
    }

    public void installFromURL(URL url) {
        try {
            File tmpFile = File.createTempFile("jabref-plugin", ".jar");
            tmpFile.deleteOnExit();
            URLDownload ud = new URLDownload(this.frame, url, tmpFile);
            ud.download();
            String path = url.getPath();
            int pos = path.lastIndexOf(47);
            if (pos >= 0 && pos < path.length() - 1) {
                path = path.substring(pos + 1);
            }
            PluginInstaller.installPlugin(this.frame, tmpFile, path);
            tmpFile.delete();
            this.buildList();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void installFromFile(File file) {
        PluginInstaller.installPlugin(this.frame, file, null);
        this.buildList();
    }

    class PluginTableFormat
    implements TableFormat<PluginInstaller.NameAndVersion> {
        PluginTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Globals.lang("Plugin name");
            }
            if (col == 1) {
                return Globals.lang("Version");
            }
            return Globals.lang("Status");
        }

        @Override
        public Object getColumnValue(PluginInstaller.NameAndVersion nav, int col) {
            if (col == 0) {
                return nav.name;
            }
            if (col == 1) {
                if (!nav.version.equals(PluginInstaller.VersionNumber.ZERO)) {
                    return nav.version.toString();
                }
                return Globals.lang("Unknown");
            }
            int status = nav.getStatus();
            if (status == 0) {
                return Globals.lang("Not loaded");
            }
            if (status == 1) {
                return Globals.lang("Loaded");
            }
            return Globals.lang("Error");
        }
    }
}

