/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.plugin.util.Util;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.ParameterMultiplicity;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    public static void main(String[] args) {
        String directory = args.length < 1 ? "./plugins" : args[0];
        boolean overwrite = args.length < 2 ? false : Boolean.parseBoolean(args[1]);
        CodeGenerator.generatePlugins(directory, overwrite);
    }

    public static void generatePlugins(String pluginLocations, boolean overwrite) {
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        PluginManager manager = objectFactory.createManager();
        try {
            DefaultPluginsCollector collector = new DefaultPluginsCollector();
            ExtendedProperties ep = new ExtendedProperties();
            ep.setProperty("org.java.plugin.boot.pluginsRepositories", pluginLocations);
            collector.configure(ep);
            Collection<PluginManager.PluginLocation> plugins = collector.collectPluginLocations();
            if (plugins.size() <= 0) {
                System.out.println("No plugins found.");
                System.exit(0);
            }
            manager.publishPlugins(collector.collectPluginLocations().toArray(new PluginManager.PluginLocation[0]));
            for (PluginDescriptor desc : manager.getRegistry().getPluginDescriptors()) {
                PrintWriter writer;
                boolean doPlugin = false;
                System.out.println("\nCreating Classes for " + desc.getId());
                File pluginBaseFolder = new File(desc.getLocation().getFile()).getParentFile();
                String targetDir = "src/";
                String helperClassName = null;
                PluginAttribute jpfCodeGenAttribute = desc.getAttribute("jpfcodegen");
                if (jpfCodeGenAttribute != null) {
                    PluginAttribute targetDirAttribute;
                    PluginAttribute helperAttribute = jpfCodeGenAttribute.getSubAttribute("helperClassName");
                    if (helperAttribute != null) {
                        helperClassName = helperAttribute.getValue();
                    }
                    if ((targetDirAttribute = jpfCodeGenAttribute.getSubAttribute("targetDir")) != null && (targetDir = targetDirAttribute.getValue()).length() == 0) {
                        System.err.println("targetDir attribute in " + desc.getId() + " is invalid. Proceeding with 'src/'");
                        targetDir = "src/";
                    }
                }
                String className = null;
                if (helperClassName == null) {
                    String pluginClassName = desc.getPluginClassName();
                    if (pluginClassName != null) {
                        doPlugin = true;
                        className = pluginClassName;
                    }
                } else {
                    doPlugin = false;
                    className = helperClassName;
                }
                if (className == null) {
                    System.out.println("  Code Generator can only generate code for plugins that either have...\n    ...the class attribute set in the plugin or\n    ...the plugin-attribute 'helperClassName' set to the classname to generate");
                    continue;
                }
                int lastDot = className.lastIndexOf(46);
                String pluginClassName = className.substring(lastDot + 1);
                String pluginPackageName = className.substring(0, lastDot);
                String[] parts = pluginPackageName.split("\\.");
                StringBuilder path = new StringBuilder();
                for (String part : parts) {
                    path.append(part).append("/");
                }
                File pluginFolder = new File(new File(pluginBaseFolder, targetDir), path.toString());
                File pluginClassFile = new File(pluginFolder, pluginClassName + ".java");
                Properties p = new Properties();
                p.setProperty("velocimacro.library", "resources/templates/macro.vm");
                p.setProperty("resource.loader", "class, file");
                p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                Velocity.init((Properties)p);
                VelocityContext context = new VelocityContext();
                context.put("packageName", (Object)pluginPackageName);
                context.put("className", (Object)pluginClassName);
                context.put("id", (Object)desc.getId());
                context.put("doPlugin", (Object)doPlugin);
                if (!pluginClassFile.exists() || overwrite) {
                    pluginClassFile.getParentFile().mkdirs();
                    Template template = Velocity.getTemplate((String)"resources/templates/Plugin.vm");
                    writer = new PrintWriter(pluginClassFile);
                    template.merge((Context)context, (Writer)writer);
                    writer.close();
                }
                File generatedFile = new File(pluginFolder, "generated/_" + pluginClassName + ".java");
                generatedFile.getParentFile().mkdirs();
                writer = new PrintWriter(generatedFile);
                TreeSet<String> imports = new TreeSet<String>();
                context.put("imports", imports);
                imports.add("org.java.plugin.Plugin");
                if (!doPlugin) {
                    imports.add("org.java.plugin.PluginManager");
                    imports.add("org.java.plugin.PluginLifecycleException");
                }
                LinkedList<HashMap<String, Object>> exts = new LinkedList<HashMap<String, Object>>();
                for (ExtensionPoint ext : desc.getExtensionPoints()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    exts.add(map);
                    map.put("id", ext.getId());
                    map.put("name", Util.toUpperFirstLetter(ext.getId()));
                    CodeGenerator.recurseParameters(map, ext.getParameterDefinitions(), imports);
                }
                context.put("extensions", exts);
                Template template = Velocity.getTemplate((String)"resources/templates/_Plugin.vm");
                template.merge((Context)context, (Writer)writer);
                writer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void recurseParameters(HashMap<String, Object> map, Collection<ExtensionPoint.ParameterDefinition> parameterDefinitions, Set<String> imports) {
        LinkedList<HashMap<String, Object>> parameters = new LinkedList<HashMap<String, Object>>();
        map.put("paras", parameters);
        if (parameterDefinitions.size() > 0) {
            imports.add("java.util.ArrayList");
            imports.add("java.util.List");
            imports.add("net.sf.jabref.plugin.util.RuntimeExtension");
            imports.add("org.java.plugin.registry.Extension");
            imports.add("org.java.plugin.registry.ExtensionPoint");
            imports.add("org.java.plugin.PluginLifecycleException");
        }
        block6: for (ExtensionPoint.ParameterDefinition pd : parameterDefinitions) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            String pid = pd.getId();
            String cleanedId = Util.toUpperFirstLetter(pid);
            if (pid.equals("class")) {
                cleanedId = cleanedId + "_";
            }
            para.put("id", pid);
            para.put("name", cleanedId);
            para.put("type", pd.getType().toCode());
            Collection<ExtensionPoint.ParameterDefinition> subDefs = pd.getSubDefinitions();
            if (subDefs.size() > 0) {
                para.put("subclass", true);
                para.put("subclassname", cleanedId);
                para.put("name", "Value");
                imports.add("net.sf.jabref.plugin.util.SubParameterAccessor");
                CodeGenerator.recurseParameters(para, subDefs, imports);
            } else {
                para.put("subclass", false);
            }
            if (pd.getMultiplicity() == ParameterMultiplicity.ANY || pd.getMultiplicity() == ParameterMultiplicity.ONE_OR_MORE) {
                imports.add("java.util.Collection");
                if (pd.getType() == ParameterType.FIXED || subDefs.size() > 0) {
                    imports.add("java.util.ArrayList");
                }
                para.put("multiplicity", true);
            } else {
                para.put("multiplicity", false);
            }
            switch (pd.getType()) {
                case STRING: {
                    String customData = pd.getCustomData();
                    if (customData == null) break;
                    para.put("type", "class");
                    para.put("className", customData);
                    break;
                }
                case FIXED: {
                    String customData = pd.getCustomData();
                    if (customData == null) continue block6;
                    para.put("enumValues", Util.join(customData.toUpperCase().split("\\|"), ", ", 0, Integer.MAX_VALUE));
                    break;
                }
                case RESOURCE: {
                    imports.add("java.net.URL");
                    break;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: {
                    imports.add("java.util.Date");
                }
            }
            parameters.add(para);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bla {
        A,
        B,
        C;

    }
}

