/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import net.sf.jabref.plugin.util.Util;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterAccessor {
    HashMap<String, Object> singletonMap = new HashMap();
    HashMap<String, Collection<Object>> singletonCollectionMap = new HashMap();

    public abstract Plugin getDeclaringPlugin();

    public abstract Extension.Parameter getParameter(String var1);

    public abstract Collection<Extension.Parameter> getParameters();

    public abstract Collection<Extension.Parameter> getParameters(String var1);

    public abstract String getId();

    public Number getNumberParameter(String id) {
        return Util.parameter2Number(id, this.getParameter(id));
    }

    public Collection<Number> getNumberParameters(String id) {
        Collection<Extension.Parameter> parameters = this.getParameters(id);
        ArrayList<Number> result = new ArrayList<Number>(parameters.size());
        for (Extension.Parameter para : parameters) {
            result.add(Util.parameter2Number(id, para));
        }
        return result;
    }

    public boolean getBooleanParameter(String id) {
        return Util.parameter2Boolean(id, this.getParameter(id));
    }

    public Collection<Boolean> getBooleanParameters(String id) {
        Collection<Extension.Parameter> parameters = this.getParameters(id);
        ArrayList<Boolean> result = new ArrayList<Boolean>(parameters.size());
        for (Extension.Parameter para : parameters) {
            result.add(Util.parameter2Boolean(id, para));
        }
        return result;
    }

    public String getStringParameter(String id) {
        Extension.Parameter para = this.getParameter(id);
        if (para != null) {
            return para.rawValue();
        }
        return null;
    }

    public Collection<String> getStringParameters(String id) {
        Collection<Extension.Parameter> parameters = this.getParameters(id);
        ArrayList<String> result = new ArrayList<String>(parameters.size());
        for (Extension.Parameter para : parameters) {
            result.add(para.rawValue());
        }
        return result;
    }

    public URL getResourceParameter(String id) {
        return this.getResourceParameter(id, null);
    }

    public Collection<URL> getResourceParameters(String id) {
        return this.getResourceParameters(id, null);
    }

    public URL getResourceParameter(String id, String relative) {
        return Util.parameter2URL(this.getParameter(id), relative, this.getDeclaringPlugin());
    }

    public Collection<URL> getResourceParameters(String id, String relative) {
        Collection<Extension.Parameter> parameters = this.getParameters(id);
        ArrayList<URL> result = new ArrayList<URL>(parameters.size());
        Plugin plugin = this.getDeclaringPlugin();
        for (Extension.Parameter para : parameters) {
            result.add(Util.parameter2URL(para, relative, plugin));
        }
        return result;
    }

    public Date getDateParameter(String id) {
        return Util.parameter2Date(id, this.getParameter(id));
    }

    public Collection<Date> getDateParameters(String id) {
        Collection<Extension.Parameter> parameters = this.getParameters(id);
        ArrayList<Date> result = new ArrayList<Date>(parameters.size());
        for (Extension.Parameter para : parameters) {
            result.add(Util.parameter2Date(id, para));
        }
        return result;
    }

    public Object getClassParameter(String id) {
        if (!this.singletonMap.containsKey(id)) {
            PluginManager manager = this.getDeclaringPlugin().getManager();
            try {
                manager.activatePlugin(this.getDeclaringPlugin().getDescriptor().getId());
                PluginClassLoader classLoader = manager.getPluginClassLoader(this.getDeclaringPlugin().getDescriptor());
                Class<?> classToInstantiate = classLoader.loadClass(this.getParameter(id).valueAsString());
                this.singletonMap.put(id, classToInstantiate.newInstance());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.singletonMap.get(id);
    }

    public Collection<Object> getClassParameters(String id) {
        if (!this.singletonCollectionMap.containsKey(id)) {
            PluginManager manager = this.getDeclaringPlugin().getManager();
            try {
                manager.activatePlugin(this.getDeclaringPlugin().getDescriptor().getId());
                PluginClassLoader classLoader = manager.getPluginClassLoader(this.getDeclaringPlugin().getDescriptor());
                LinkedList instances = new LinkedList();
                for (String classNamesToLoad : this.getStringParameters(id)) {
                    Class<?> classToInstantiate = classLoader.loadClass(classNamesToLoad);
                    instances.add(classToInstantiate.newInstance());
                }
                this.singletonCollectionMap.put(id, Collections.unmodifiableCollection(instances));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.singletonCollectionMap.get(id);
    }
}

