/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import net.sf.jabref.BaseAction;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.undo.NamedCompound;

public class SpecialFieldAction
extends BaseAction {
    private JabRefFrame frame;
    private String doneTextPattern;
    private SpecialField c;
    String value;
    private boolean nullFieldIfValueIsTheSame;
    private String undoText;

    public SpecialFieldAction(JabRefFrame frame, SpecialField c, String value, boolean nullFieldIfValueIsTheSame, String undoText, String doneTextPattern) {
        this.frame = frame;
        this.c = c;
        this.value = value;
        this.nullFieldIfValueIsTheSame = nullFieldIfValueIsTheSame;
        this.undoText = undoText;
        this.doneTextPattern = doneTextPattern;
    }

    @Override
    public void action() {
        try {
            NamedCompound ce = new NamedCompound(this.undoText);
            BibtexEntry[] bes = this.frame.basePanel().getSelectedEntries();
            if (bes == null) {
                return;
            }
            for (BibtexEntry be : bes) {
                SpecialFieldsUtils.updateField(this.c, this.value, be, ce, this.nullFieldIfValueIsTheSame);
            }
            ce.end();
            if (ce.hasEdits()) {
                this.frame.basePanel().undoManager.addEdit(ce);
                this.frame.basePanel().markBaseChanged();
                this.frame.basePanel().updateEntryEditorIfShowing();
                String outText = this.nullFieldIfValueIsTheSame ? Globals.lang(this.doneTextPattern, Integer.toString(bes.length)) : Globals.lang(this.doneTextPattern, this.value, Integer.toString(bes.length));
                this.frame.output(outText);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

