/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.normalize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.quant.QuantError;
import org.encog.mathutil.Equilateral;
import org.encog.util.EngineArray;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;

public class AnalystField {
    public static final int MIN_EQ_CLASSES = 3;
    private double actualHigh;
    private double actualLow;
    private double normalizedHigh;
    private double normalizedLow;
    private NormalizationAction action;
    private String name;
    private final List<ClassItem> classes = new ArrayList<ClassItem>();
    private Equilateral eq;
    private final Map<String, Integer> lookup = new HashMap<String, Integer>();
    private boolean output;
    private int timeSlice;

    public AnalystField() {
        this(1.0, -1.0);
    }

    public AnalystField(AnalystField field) {
        this.actualHigh = field.actualHigh;
        this.actualLow = field.actualLow;
        this.normalizedHigh = field.normalizedHigh;
        this.normalizedLow = field.normalizedLow;
        this.action = field.action;
        this.name = field.name;
        this.output = field.output;
        this.timeSlice = field.timeSlice;
        this.fixSingleValue();
    }

    public AnalystField(double theNormalizedHigh, double theNormalizedLow) {
        this.normalizedHigh = theNormalizedHigh;
        this.normalizedLow = theNormalizedLow;
        this.actualHigh = Double.MIN_VALUE;
        this.actualLow = Double.MAX_VALUE;
        this.action = NormalizationAction.Normalize;
        this.fixSingleValue();
    }

    public AnalystField(NormalizationAction theAction, String theName) {
        this(theAction, theName, 0.0, 0.0, 0.0, 0.0);
    }

    public AnalystField(NormalizationAction theAction, String theName, double ahigh, double alow, double nhigh, double nlow) {
        this.action = theAction;
        this.actualHigh = ahigh;
        this.actualLow = alow;
        this.normalizedHigh = nhigh;
        this.normalizedLow = nlow;
        this.name = theName;
        this.fixSingleValue();
    }

    public AnalystField(String theName, NormalizationAction theAction, double high, double low) {
        this.name = theName;
        this.action = theAction;
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.fixSingleValue();
    }

    public void addRawHeadings(StringBuilder line, String prefix, CSVFormat format) {
        int subFields = this.getColumnsNeeded();
        for (int i = 0; i < subFields; ++i) {
            String str = CSVHeaders.tagColumn(this.name, i, this.timeSlice, subFields > 1);
            BasicFile.appendSeparator(line, format);
            line.append('\"');
            if (prefix != null) {
                line.append(prefix);
            }
            line.append(str);
            line.append('\"');
        }
    }

    public void analyze(double d) {
        this.actualHigh = Math.max(this.actualHigh, d);
        this.actualLow = Math.min(this.actualLow, d);
    }

    public double deNormalize(double value) {
        double result = ((this.actualLow - this.actualHigh) * value - this.normalizedHigh * this.actualLow + this.actualHigh * this.normalizedLow) / (this.normalizedLow - this.normalizedHigh);
        if (Double.isNaN(result)) {
            return (this.normalizedHigh - this.normalizedLow) / 2.0 + this.normalizedLow;
        }
        return result;
    }

    public ClassItem determineClass(double[] data) {
        int resultIndex = 0;
        switch (this.action) {
            case Equilateral: {
                resultIndex = this.eq.decode(data);
                break;
            }
            case OneOf: {
                resultIndex = EngineArray.indexOfLargest(data);
                break;
            }
            case SingleField: {
                resultIndex = (int)data[0];
                break;
            }
            default: {
                throw new AnalystError("Unknown action: " + (Object)((Object)this.action));
            }
        }
        return this.classes.get(resultIndex);
    }

    public ClassItem determineClass(int pos, double[] data) {
        int resultIndex = 0;
        double[] d = new double[this.getColumnsNeeded()];
        EngineArray.arrayCopy(data, pos, d, 0, d.length);
        switch (this.action) {
            case Equilateral: {
                resultIndex = this.eq.decode(d);
                break;
            }
            case OneOf: {
                resultIndex = EngineArray.indexOfLargest(d);
                break;
            }
            case SingleField: {
                resultIndex = (int)Math.round(d[0]);
                break;
            }
            default: {
                throw new AnalystError("Invalid action: " + (Object)((Object)this.action));
            }
        }
        if (resultIndex < 0) {
            return null;
        }
        if (resultIndex >= this.classes.size()) {
            return null;
        }
        return this.classes.get(resultIndex);
    }

    public double[] encode(int classNumber) {
        switch (this.action) {
            case OneOf: {
                return this.encodeOneOf(classNumber);
            }
            case Equilateral: {
                return this.encodeEquilateral(classNumber);
            }
            case SingleField: {
                return this.encodeSingleField(classNumber);
            }
        }
        return null;
    }

    public double[] encode(String str) {
        int classNumber = this.lookup(str);
        if (classNumber == -1) {
            try {
                classNumber = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new QuantError("Can't determine class for: " + str);
            }
        }
        return this.encode(classNumber);
    }

    public double[] encodeEquilateral(int classNumber) {
        return this.eq.encode(classNumber);
    }

    private double[] encodeOneOf(int classNumber) {
        double[] result = new double[this.getColumnsNeeded()];
        for (int i = 0; i < this.classes.size(); ++i) {
            result[i] = i == classNumber ? this.normalizedHigh : this.normalizedLow;
        }
        return result;
    }

    private double[] encodeSingleField(int classNumber) {
        double[] d = new double[]{classNumber};
        return d;
    }

    public void fixSingleValue() {
        if (this.action == NormalizationAction.Normalize && Math.abs(this.actualHigh - this.actualLow) < 1.0E-13) {
            this.actualHigh += 1.0;
            this.actualLow -= 1.0;
        }
    }

    public NormalizationAction getAction() {
        return this.action;
    }

    public double getActualHigh() {
        return this.actualHigh;
    }

    public double getActualLow() {
        return this.actualLow;
    }

    public List<ClassItem> getClasses() {
        return this.classes;
    }

    public int getColumnsNeeded() {
        switch (this.action) {
            case Ignore: {
                return 0;
            }
            case Equilateral: {
                return this.classes.size() - 1;
            }
            case OneOf: {
                return this.classes.size();
            }
        }
        return 1;
    }

    public Equilateral getEq() {
        return this.eq;
    }

    public String getName() {
        return this.name;
    }

    public double getNormalizedHigh() {
        return this.normalizedHigh;
    }

    public double getNormalizedLow() {
        return this.normalizedLow;
    }

    public int getTimeSlice() {
        return this.timeSlice;
    }

    public void init() {
        if (this.action == NormalizationAction.Equilateral) {
            if (this.classes.size() < 3) {
                throw new QuantError("There must be at least three classes to make use of equilateral normalization.");
            }
            this.eq = new Equilateral(this.classes.size(), this.normalizedHigh, this.normalizedLow);
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            this.lookup.put(this.classes.get(i).getName(), this.classes.get(i).getIndex());
        }
    }

    public boolean isClassify() {
        return this.action == NormalizationAction.Equilateral || this.action == NormalizationAction.OneOf || this.action == NormalizationAction.SingleField;
    }

    public final boolean isIgnored() {
        return this.action == NormalizationAction.Ignore;
    }

    public boolean isInput() {
        return !this.output;
    }

    public boolean isOutput() {
        return this.output;
    }

    public int lookup(String str) {
        if (!this.lookup.containsKey(str)) {
            return -1;
        }
        return this.lookup.get(str);
    }

    public void makeClass(NormalizationAction theAction, int classFrom, int classTo, int high, int low) {
        if (this.action != NormalizationAction.Equilateral && this.action != NormalizationAction.OneOf && this.action != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        int index = 0;
        for (int i = classFrom; i < classTo; ++i) {
            this.classes.add(new ClassItem("" + i, index++));
        }
    }

    public void makeClass(NormalizationAction theAction, String[] cls, double high, double low) {
        if (this.action != NormalizationAction.Equilateral && this.action != NormalizationAction.OneOf && this.action != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        for (int i = 0; i < cls.length; ++i) {
            this.classes.add(new ClassItem(cls[i], i));
        }
    }

    public void makePassThrough() {
        this.normalizedHigh = 0.0;
        this.normalizedLow = 0.0;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        this.action = NormalizationAction.PassThrough;
    }

    public double normalize(double value) {
        double result = (value - this.actualLow) / (this.actualHigh - this.actualLow) * (this.normalizedHigh - this.normalizedLow) + this.normalizedLow;
        if (Double.isNaN(result)) {
            return (this.normalizedHigh - this.normalizedLow) / 2.0 + this.normalizedLow;
        }
        return result;
    }

    public void setAction(NormalizationAction theAction) {
        this.action = theAction;
    }

    public void setActualHigh(double theActualHigh) {
        this.actualHigh = theActualHigh;
    }

    public void setActualLow(double theActualLow) {
        this.actualLow = theActualLow;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setNormalizedHigh(double theNormalizedHigh) {
        this.normalizedHigh = theNormalizedHigh;
    }

    public void setNormalizedLow(double theNormalizedLow) {
        this.normalizedLow = theNormalizedLow;
    }

    public void setOutput(boolean b) {
        this.output = b;
    }

    public void setTimeSlice(int theTimeSlice) {
        this.timeSlice = theTimeSlice;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" name=");
        result.append(this.name);
        result.append(", actualHigh=");
        result.append(this.actualHigh);
        result.append(", actualLow=");
        result.append(this.actualLow);
        result.append("]");
        return result.toString();
    }

    public int determineMode(EncogAnalyst analyst) {
        if (!this.isClassify()) {
            throw new AnalystError("Can only calculate the mode for a class.");
        }
        DataField df = analyst.getScript().findDataField(this.name);
        AnalystClassItem m = null;
        int result = 0;
        int idx = 0;
        for (AnalystClassItem item : df.getClassMembers()) {
            if (m == null || m.getCount() < item.getCount()) {
                m = item;
                result = idx;
            }
            ++idx;
        }
        return result;
    }

    public double[] encode(double d) {
        return this.encode((int)d);
    }

    public ClassItem findClass(int index) {
        for (ClassItem itm : this.classes) {
            if (itm.getIndex() != index) continue;
            return itm;
        }
        return null;
    }
}

