/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.ninja;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.encog.app.quant.QuantError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.time.NumericDateUtil;

public class NinjaStreamWriter {
    private int precision = 10;
    private final List<String> columns = new ArrayList<String>();
    private PrintWriter tw;
    private boolean headers;
    private CSVFormat format;
    private StringBuilder line;
    private boolean columnsDefined = false;

    public final void beginBar(Date dt) {
        if (this.tw == null) {
            throw new QuantError("Must open file first.");
        }
        if (this.line != null) {
            throw new QuantError("Must call end bar");
        }
        this.line = new StringBuilder();
        this.line.append(NumericDateUtil.date2Long(dt));
        this.line.append(this.format.getSeparator());
        this.line.append(NumericDateUtil.time2Int(dt));
    }

    public final void close() {
        if (this.tw == null) {
            throw new QuantError("Must open file first.");
        }
        this.tw.close();
    }

    public final void endBar() {
        if (this.tw == null) {
            throw new QuantError("Must open file first.");
        }
        if (this.line == null) {
            throw new QuantError("Must call BeginBar first.");
        }
        if (this.headers && !this.columnsDefined) {
            this.writeHeaders();
        }
        this.tw.println(this.line.toString());
        this.line = null;
        this.columnsDefined = true;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void open(String filename, boolean theHeaders, CSVFormat theFormat) {
        try {
            this.tw = new PrintWriter(new FileWriter(filename));
            this.format = theFormat;
            this.headers = theHeaders;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    public final void setPercision(int thePrecision) {
        this.precision = thePrecision;
    }

    public final void storeColumn(String name, double d) {
        if (this.line == null) {
            throw new QuantError("Must call BeginBar first.");
        }
        if (this.line.length() > 0) {
            this.line.append(this.format.getSeparator());
        }
        this.line.append(this.format.format(d, this.precision));
        if (!this.columnsDefined) {
            this.columns.add(name);
        }
    }

    private void writeHeaders() {
        if (this.tw == null) {
            throw new QuantError("Must open file first.");
        }
        StringBuilder theLine = new StringBuilder();
        theLine.append("date");
        theLine.append(this.format.getSeparator());
        theLine.append("time");
        for (String str : this.columns) {
            if (theLine.length() > 0) {
                theLine.append(this.format.getSeparator());
            }
            theLine.append("\"");
            theLine.append(str);
            theLine.append("\"");
        }
        this.tw.println(theLine.toString());
    }
}

