/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.freeform.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.neural.freeform.FreeformLayer;
import org.encog.neural.freeform.FreeformNeuron;

public class BasicFreeformLayer
implements FreeformLayer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<FreeformNeuron> neurons = new ArrayList<FreeformNeuron>();

    @Override
    public void add(FreeformNeuron basicFreeformNeuron) {
        this.neurons.add(basicFreeformNeuron);
    }

    @Override
    public List<FreeformNeuron> getNeurons() {
        return this.neurons;
    }

    @Override
    public boolean hasBias() {
        for (FreeformNeuron neuron : this.neurons) {
            if (!neuron.isBias()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setActivation(int i, double activation) {
        this.neurons.get(i).setActivation(activation);
    }

    @Override
    public int size() {
        return this.neurons.size();
    }

    @Override
    public int sizeNonBias() {
        int result = 0;
        for (FreeformNeuron neuron : this.neurons) {
            if (neuron.isBias()) continue;
            ++result;
        }
        return result;
    }
}

