/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.server.UserType;
import com.pomodorotechnique.server.api.InvalidStateException;
import com.pomodorotechnique.server.api.Server;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class UsersWindow
extends JDialog {
    private final Server server;
    private final List<UserType> users;
    private JButton closeButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel;
    private JLabel headerTextLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton messageButton;
    private JList usersList;

    public UsersWindow(Frame parent, boolean modal, Server server) {
        super(parent, modal);
        this.initComponents();
        this.server = server;
        this.users = server.getAllUsers().getUser();
        this.populateUsersList();
        this.getRootPane().setDefaultButton(this.closeButton);
        Util.decorate(this, true);
    }

    private void populateUsersList() {
        this.usersList.setModel(new DefaultListModel(){

            public int getSize() {
                return UsersWindow.this.users.size();
            }

            public Object getElementAt(int index) {
                UserType u = (UserType)UsersWindow.this.users.get(index);
                return u.getName() + " (" + u.getId() + ")";
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.usersList = new JList();
        this.messageButton = new JButton();
        this.closeButton = new JButton();
        this.headerPanel = new JPanel();
        this.headerTextLabel = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(UsersWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setAlwaysOnTop(true);
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jScrollPane1.setName("jScrollPane1");
        this.usersList.setName("usersList");
        this.jScrollPane1.setViewportView(this.usersList);
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(UsersWindow.class, this);
        this.messageButton.setAction(actionMap.get("leaveMessage"));
        this.messageButton.setText(resourceMap.getString("messageButton.text", new Object[0]));
        this.messageButton.setName("messageButton");
        this.closeButton.setAction(actionMap.get("close"));
        this.closeButton.setText(resourceMap.getString("closeButton.text", new Object[0]));
        this.closeButton.setName("closeButton");
        this.headerPanel.setBackground(resourceMap.getColor("headerPanel.background"));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel.border.lineColor")));
        this.headerPanel.setName("headerPanel");
        this.headerTextLabel.setFont(this.headerTextLabel.getFont().deriveFont((float)this.headerTextLabel.getFont().getSize() + 7.0f));
        this.headerTextLabel.setText(resourceMap.getString("headerTextLabel.text", new Object[0]));
        this.headerTextLabel.setName("headerTextLabel");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addComponent(this.headerTextLabel, -1, 68, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 312, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.messageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.headerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageButton).addComponent(this.closeButton)).addContainerGap()));
        this.pack();
    }

    @Action
    public void close() {
        this.setVisible(false);
    }

    @Action
    public void leaveMessage() throws InvalidStateException {
        String msg = JOptionPane.showInputDialog(this, "Provide a text for this message", "Leave message", -1);
        String userId = this.users.get(this.usersList.getSelectedIndex()).getId();
        this.server.sendMessage(userId, msg);
    }
}

