/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.InactivatableColorUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class Quaqua13ListUI
extends BasicListUI {
    private boolean isStriped = false;
    private static final int VERTICAL;
    private static final Method getLayoutOrientation;
    private int layoutOrientation;
    static /* synthetic */ Class class$javax$swing$JList;

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("List.alternateBackground.0");
        }
        return UIManager.getColor("List.alternateBackground.1");
    }

    private void updateStriped() {
        Object value = this.list.getClientProperty("Quaqua.List.style");
        this.isStriped = value != null && value.equals("striped") && this.getLayoutOrientation() == VERTICAL;
    }

    private int getLayoutOrientation() {
        if (getLayoutOrientation != null) {
            try {
                return (Integer)getLayoutOrientation.invoke((Object)this.list, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VERTICAL;
    }

    public void paintStripes(Graphics g, JComponent c) {
        if (this.isStriped && this.list.getModel() != null) {
            int y;
            Dimension vs = c.getSize();
            Dimension ts = this.list.getSize();
            Point p = this.list.getLocation();
            int rh = this.list.getFixedCellHeight();
            int n = this.list.getModel().getSize();
            if (rh <= 0) {
                rh = n == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int row = Math.abs(p.y / rh);
            int th = n * rh - row * rh;
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, ts.width, ts.height);
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                y = p.y + row * rh;
                while (y < th) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        }
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean isFocused = this.list.isEnabled() && QuaquaUtilities.isFocused(this.list);
        boolean cellHasFocus = isFocused && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.list.isSelectedIndex(row)) {
            g.setColor(UIManager.getColor("List.selectionBackground"));
            g.fillRect(cx, cy, cw, ch);
        } else if (this.isStriped) {
            g.setColor(this.getAlternateColor(row % 2));
            g.fillRect(cx, cy, cw, ch);
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintStripes(g, c);
        boolean isFocused = QuaquaUtilities.isFocused(c);
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(isFocused);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(isFocused);
        }
        super.paint(g, c);
        if (selectionBackground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionBackground).setActive(true);
        }
        if (selectionForeground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)selectionForeground).setActive(true);
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStriped();
    }

    public static ComponentUI createUI(JComponent list) {
        return new Quaqua13ListUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int value = 0;
        try {
            value = (class$javax$swing$JList == null ? (class$javax$swing$JList = Quaqua13ListUI.class$("javax.swing.JList")) : class$javax$swing$JList).getField("VERTICAL").getInt(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        VERTICAL = value;
        Method value2 = null;
        try {
            value2 = (class$javax$swing$JList == null ? (class$javax$swing$JList = Quaqua13ListUI.class$("javax.swing.JList")) : class$javax$swing$JList).getMethod("getLayoutOrientation", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getLayoutOrientation = value2;
    }

    protected class ListDataHandler
    implements ListDataListener {
        protected ListDataHandler() {
        }

        public void intervalAdded(ListDataEvent e) {
            Quaqua13ListUI.this.updateLayoutStateNeeded = 1;
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            ListSelectionModel sm = Quaqua13ListUI.this.list.getSelectionModel();
            if (sm != null && sm.getMinSelectionIndex() != -1) {
                sm.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
            Quaqua13ListUI.this.redrawList();
        }

        public void intervalRemoved(ListDataEvent e) {
            Quaqua13ListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel sm = Quaqua13ListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
            Quaqua13ListUI.this.redrawList();
        }

        public void contentsChanged(ListDataEvent e) {
            Quaqua13ListUI.this.updateLayoutStateNeeded = 1;
            if (Quaqua13ListUI.this.list.getFixedCellHeight() == -1) {
                Quaqua13ListUI.this.redrawList();
            } else {
                Rectangle bounds = Quaqua13ListUI.this.list.getCellBounds(e.getIndex0(), e.getIndex1());
                if (bounds == null) {
                    Quaqua13ListUI.this.redrawList();
                } else {
                    Quaqua13ListUI.this.list.repaint(bounds);
                }
            }
        }
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super(Quaqua13ListUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Quaqua.List.style")) {
                Quaqua13ListUI.this.updateStriped();
            } else if ("layoutOrientation".equals(propertyName)) {
                Quaqua13ListUI.this.layoutOrientation = (Integer)e.getNewValue();
                Quaqua13ListUI.this.updateStriped();
            }
            super.propertyChange(e);
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            Rectangle r;
            int leadIndex = Quaqua13ListUI.this.list.getLeadSelectionIndex();
            if (leadIndex != -1 && (r = Quaqua13ListUI.this.getCellBounds(Quaqua13ListUI.this.list, leadIndex, leadIndex)) != null) {
                Quaqua13ListUI.this.list.repaint(r.x, r.y, r.width, r.height);
            }
        }

        public void focusGained(FocusEvent event) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent event) {
            this.repaintCellFocus();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean mouseReleaseDeselects;
        private boolean mouseDragSelects;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int index = Quaqua13ListUI.this.locationToIndex(Quaqua13ListUI.this.list, e.getPoint());
            this.mouseDragSelects = false;
            this.mouseReleaseDeselects = false;
            if (!(index == -1 || Quaqua13ListUI.this.list.isSelectedIndex(index) && e.isPopupTrigger())) {
                int anchorIndex = Quaqua13ListUI.this.list.getAnchorSelectionIndex();
                if (e.isMetaDown()) {
                    if (Quaqua13ListUI.this.list.isSelectedIndex(index)) {
                        Quaqua13ListUI.this.list.removeSelectionInterval(index, index);
                    } else {
                        Quaqua13ListUI.this.list.addSelectionInterval(index, index);
                        this.mouseDragSelects = true;
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    Quaqua13ListUI.this.list.setSelectionInterval(anchorIndex, index);
                    this.mouseDragSelects = true;
                } else {
                    if (Quaqua13ListUI.this.list.isSelectedIndex(index)) {
                        this.mouseReleaseDeselects = true;
                    } else {
                        Quaqua13ListUI.this.list.setSelectionInterval(index, index);
                        this.mouseDragSelects = true;
                    }
                    Quaqua13ListUI.this.list.getSelectionModel().setAnchorSelectionIndex(index);
                }
            }
            Quaqua13ListUI.this.list.getSelectionModel().setValueIsAdjusting(this.mouseDragSelects);
            Quaqua13ListUI.this.list.requestFocus();
        }

        public void mouseDragged(MouseEvent e) {
            int index;
            this.mouseReleaseDeselects = false;
            if (this.mouseDragSelects && (index = Quaqua13ListUI.this.locationToIndex(Quaqua13ListUI.this.list, e.getPoint())) != -1) {
                Rectangle cellBounds = Quaqua13ListUI.this.getCellBounds(Quaqua13ListUI.this.list, index, index);
                Quaqua13ListUI.this.list.scrollRectToVisible(cellBounds);
                int anchorIndex = Quaqua13ListUI.this.list.getAnchorSelectionIndex();
                Quaqua13ListUI.this.list.addSelectionInterval(anchorIndex, index);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseDragSelects = false;
            if (this.mouseReleaseDeselects) {
                int index = Quaqua13ListUI.this.locationToIndex(Quaqua13ListUI.this.list, e.getPoint());
                Quaqua13ListUI.this.list.setSelectionInterval(index, index);
            }
            Quaqua13ListUI.this.list.getSelectionModel().setValueIsAdjusting(false);
        }
    }
}

