/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxButton;
import ch.randelshofer.quaqua.QuaquaComboBoxEditor;
import ch.randelshofer.quaqua.QuaquaComboPopup;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class QuaquaComboBoxUI
extends BasicComboBoxUI
implements VisuallyLayoutable {
    private boolean isTableCellEditor = false;
    public static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    private static final Border tableCellEditorBorder = new EmptyBorder(0, 2, 0, 0);
    static final StringBuffer HIDE_POPUP_KEY = new StringBuffer("HidePopupKey");

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Boolean value = (Boolean)c.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (value == null) {
            value = (Boolean)c.getClientProperty("JComboBox.lightweightKeyboardNavigation");
        }
        this.setTableCellEditor(value != null && value.equals(Boolean.TRUE));
        c.setOpaque(QuaquaManager.getBoolean("ComboBox.opaque"));
        this.comboBox.setRequestFocusEnabled(QuaquaManager.getBoolean("ComboBox.requestFocusEnabled"));
    }

    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setMaximumRowCount(UIManager.getInt("ComboBox.maximumRowCount"));
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    boolean isTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected ComboBoxEditor createEditor() {
        return new QuaquaComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        QuaquaComboPopup popup = new QuaquaComboPopup(this.comboBox, this);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    protected JButton createArrowButton() {
        QuaquaComboBoxButton button = new QuaquaComboBoxButton(this, this.comboBox, this.getArrowIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyChangeListener();
    }

    private void setTableCellEditor(boolean b) {
        this.isTableCellEditor = b;
        this.updateTableCellEditor();
    }

    private void updateTableCellEditor() {
        boolean b = this.isTableCellEditor();
        if (this.editor instanceof JComponent) {
            JComponent jeditor = (JComponent)this.editor;
            jeditor.setBorder(b ? tableCellEditorBorder : UIManager.getBorder("TextField.border"));
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (this.editor != null && QuaquaManager.getBoolean("ComboBox.changeEditorForeground")) {
            this.editor.setForeground(c.getForeground());
        }
        Debug.paint(g, c, this);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    protected LayoutManager createLayoutManager() {
        return new QuaquaComboBoxLayoutManager();
    }

    public void layoutComboBox(Container parent, QuaquaComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable()) {
            manager.superLayout(parent);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
    }

    protected Icon getArrowIcon() {
        if (this.isTableCellEditor()) {
            return UIManager.getIcon("ComboBox.smallPopupIcon");
        }
        if (this.comboBox.isEditable()) {
            if (this.isSmall()) {
                return UIManager.getIcon("ComboBox.smallDropDownIcon");
            }
            return UIManager.getIcon("ComboBox.dropDownIcon");
        }
        if (this.isSmall()) {
            return UIManager.getIcon("ComboBox.smallPopupIcon");
        }
        return UIManager.getIcon("ComboBox.popupIcon");
    }

    protected int getArrowWidth() {
        if (this.isTableCellEditor()) {
            return 7;
        }
        if (this.comboBox.isEditable()) {
            if (this.isSmall()) {
                return 17;
            }
            return 19;
        }
        if (this.isSmall()) {
            return 20;
        }
        return 23;
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected boolean isSmall() {
        return this.comboBox.getFont().getSize() <= 11;
    }

    protected Rectangle rectangleForCurrentValue() {
        return this.rectangleForCurrentValue(this.comboBox.getWidth(), this.comboBox.getHeight());
    }

    protected Rectangle rectangleForCurrentValue(int width, int height) {
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        if (this.comboBox.isEditable()) {
            if (!this.isTableCellEditor()) {
                insets.right -= margin.right;
                insets.left -= margin.left - 2;
                insets.top -= margin.top - 2;
                insets.bottom -= margin.bottom - 2;
            }
        } else if (this.isTableCellEditor()) {
            --insets.top;
        } else {
            insets.left += 6;
            insets.top += margin.top;
            insets.left += margin.left;
            insets.bottom += margin.bottom;
        }
        return new Rectangle(insets.left, insets.top, width - this.getArrowWidth() - insets.right - insets.left, height - insets.top - insets.bottom);
    }

    protected Insets getMargin() {
        Insets margin = (Insets)this.comboBox.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return (Insets)margin.clone();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof QuaquaComboBoxButton) {
            QuaquaComboBoxButton button = (QuaquaComboBoxButton)this.arrowButton;
            Insets buttonInsets = new Insets(4, 11, 3, this.getArrowWidth() + 5);
            if (this.isSmall()) {
                --buttonInsets.bottom;
            }
            Insets insets = this.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right + buttonInsets.left + buttonInsets.right;
            size.height += insets.top + insets.bottom + buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            QuaquaComboBoxButton button = (QuaquaComboBoxButton)this.arrowButton;
            Insets insets = this.comboBox.getInsets();
            Insets margin = this.getMargin();
            Insets buttonInsets = new Insets(2 - margin.top, 4 - margin.left, 2 - margin.bottom, this.getArrowWidth());
            size = this.getDisplaySize();
            size.width += insets.left + insets.right + buttonInsets.left + buttonInsets.right;
            size.height += insets.top + insets.bottom + buttonInsets.top + buttonInsets.bottom;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        if (!(c.getParent() instanceof JToolBar)) {
            size.width = Short.MAX_VALUE;
        }
        return size;
    }

    protected FocusListener createFocusListener() {
        return new GlowFocusHandler();
    }

    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    public Rectangle getVisualBounds(JComponent c, int layoutType, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (layoutType == 0) {
            return bounds;
        }
        JComboBox cb = (JComboBox)c;
        Rectangle buttonRect = new Rectangle();
        Rectangle editorRect = null;
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            if (QuaquaUtilities.isLeftToRight(cb)) {
                int plusHeight = this.isSmall() ? 5 : 4;
                buttonRect.setBounds(width - this.getArrowWidth() - insets.right, insets.top + margin.top - 2, this.getArrowWidth(), buttonSize - margin.top - margin.bottom + plusHeight);
            } else {
                buttonRect.setBounds(insets.left, insets.top, this.getArrowWidth(), buttonSize);
            }
        }
        editorRect = this.rectangleForCurrentValue(width, height);
        ++editorRect.x;
        editorRect.width -= 2;
        switch (layoutType) {
            case 1: {
                if (this.isTableCellEditor()) break;
                if (this.editor != null) {
                    bounds.x += margin.left;
                    bounds.y += margin.top;
                    bounds.width -= margin.left + margin.right;
                    bounds.height -= margin.top + margin.bottom + 1;
                    break;
                }
                bounds.x += margin.left;
                bounds.y += margin.top;
                bounds.width -= margin.left + margin.right;
                bounds.height -= margin.top + margin.bottom;
                break;
            }
            case 2: {
                Component renderer;
                Component component = renderer = this.editor == null ? cb.getRenderer().getListCellRendererComponent(this.listBox, cb.getSelectedItem(), cb.getSelectedIndex(), false, cb.hasFocus()) : this.editor;
                if (renderer instanceof JComponent && Methods.invokeGetter((Object)renderer, "getUI", null) instanceof VisuallyLayoutable) {
                    bounds = ((VisuallyLayoutable)Methods.invokeGetter((Object)renderer, "getUI", null)).getVisualBounds((JComponent)renderer, layoutType, editorRect.width, editorRect.height);
                    bounds.x += editorRect.x;
                    bounds.y += editorRect.y;
                    break;
                }
                bounds.setBounds(editorRect);
            }
        }
        return bounds;
    }

    public class GlowFocusHandler
    extends BasicComboBoxUI.FocusHandler {
        public GlowFocusHandler() {
            super(QuaquaComboBoxUI.this);
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.glowyRepaint();
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            this.glowyRepaint();
        }

        private void glowyRepaint() {
            if (QuaquaComboBoxUI.this.comboBox.getParent() != null) {
                Rectangle r = QuaquaComboBoxUI.this.comboBox.getBounds();
                r.grow(2, 2);
                QuaquaComboBoxUI.this.comboBox.getParent().repaint(r.x, r.y, r.width, r.height);
            }
        }
    }

    public class QuaquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public QuaquaComboBoxLayoutManager() {
            super(QuaquaComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            QuaquaComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = QuaquaComboBoxUI.this.getInsets();
            Insets margin = QuaquaComboBoxUI.this.getMargin();
            int buttonSize = height - (insets.top + insets.bottom);
            if (QuaquaComboBoxUI.this.arrowButton != null) {
                if (QuaquaUtilities.isLeftToRight(cb)) {
                    int plusHeight = QuaquaComboBoxUI.this.isSmall() ? -2 : -2;
                    QuaquaComboBoxUI.this.arrowButton.setBounds(width - QuaquaComboBoxUI.this.getArrowWidth() - insets.right, insets.top, QuaquaComboBoxUI.this.getArrowWidth(), buttonSize + plusHeight);
                } else {
                    QuaquaComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, QuaquaComboBoxUI.this.getArrowWidth(), buttonSize);
                }
            }
            if (QuaquaComboBoxUI.this.editor != null) {
                Rectangle cvb = QuaquaComboBoxUI.this.rectangleForCurrentValue();
                QuaquaComboBoxUI.this.editor.setBounds(cvb);
            }
        }
    }

    public class QuaquaPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public QuaquaPropertyChangeListener() {
            super(QuaquaComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                QuaquaComboBoxButton button = (QuaquaComboBoxButton)QuaquaComboBoxUI.this.arrowButton;
                button.setIconOnly(QuaquaComboBoxUI.this.comboBox.isEditable());
                QuaquaComboBoxUI.this.updateTableCellEditor();
                QuaquaComboBoxUI.this.comboBox.repaint();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                QuaquaComboBoxUI.this.arrowButton.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                QuaquaComboBoxUI.this.arrowButton.setForeground(color);
                QuaquaComboBoxUI.this.listBox.setForeground(color);
            } else if (propertyName.equals(QuaquaComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                Boolean inTable = (Boolean)e.getNewValue();
                QuaquaComboBoxUI.this.setTableCellEditor(inTable.equals(Boolean.TRUE));
            } else if (propertyName.equals("JComboBox.lightweightKeyboardNavigation")) {
                QuaquaComboBoxUI.this.setTableCellEditor(e.getNewValue() != null && e.getNewValue().equals("Lightweight"));
            }
        }
    }
}

