/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.FormLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;

class ColumnLayout {
    protected int m_minLocation = 0;
    protected int m_prefLocation = 0;
    protected int m_currLocation = 0;
    private int m_labelWidth = 0;
    private int m_columnIndex = 0;
    protected FormLayout m_containingLayout = null;
    protected Vector m_segments = null;
    private final int DEBUG_LEVEL = 0;

    public ColumnLayout(int n, FormLayout formLayout) {
        this.debug("ColumnLayout.ColumnLayout(int, FormLayout): index " + n, 3);
        this.m_segments = new Vector();
        this.m_columnIndex = n;
        this.m_containingLayout = formLayout;
    }

    private SegmentLayout addSegment(int n) {
        this.debug("ColumnLayout.addSegment(int): index " + this.m_columnIndex, 3);
        SegmentLayout segmentLayout = new SegmentLayout(n);
        this.m_segments.add(segmentLayout);
        return segmentLayout;
    }

    protected void findMinimumLocation() {
        this.debug("ColumnLayout.findMinimumLocation(): index " + this.m_columnIndex, 6);
        this.calculateLabelWidth();
        Enumeration enumeration = this.m_segments.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            n2 = ((SegmentLayout)enumeration.nextElement()).getMinimumLocation();
            if (n2 <= n) continue;
            n = n2;
        }
        this.setMinimumLocation(n);
        this.debug("ColumnLayout.findMinimumLocation(): [index " + this.m_columnIndex + "] setting m_minLocation to " + this.m_minLocation, 6);
    }

    protected void findPreferredLocation() {
        this.debug("ColumnLayout.findPreferredLocation(): index " + this.m_columnIndex, 6);
        this.calculateLabelWidth();
        Enumeration enumeration = this.m_segments.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            n2 = ((SegmentLayout)enumeration.nextElement()).getPreferredLocation();
            if (n2 <= n) continue;
            n = n2;
        }
        this.setPreferredLocation(n);
        this.debug("ColumnLayout.findPreferredLocation(): [index " + this.m_columnIndex + "] setting m_prefLocation to " + this.m_prefLocation, 6);
    }

    protected void findIntermediateLocation(double d) {
        this.debug("ColumnLayout.findIntermediateLocation(double): pct " + d + ", index " + this.m_columnIndex, 8);
        this.m_currLocation = this.m_minLocation + (int)((double)(this.m_prefLocation - this.m_minLocation) * d);
        this.debug("ColumnLayout.findIntermediateLocation(): setting m_currLocation to " + this.m_currLocation, 8);
    }

    protected void setMinimumLocation(int n) {
        this.debug("ColumnLayout.setMinimumLocation(int): index " + this.m_columnIndex, 6);
        this.m_minLocation = n;
    }

    protected void setPreferredLocation(int n) {
        this.debug("ColumnLayout.setPreferredLocation(int): index " + this.m_columnIndex, 6);
        this.m_prefLocation = n;
    }

    protected void doLayout() {
        this.debug("ColumnLayout.doLayout(): index " + this.m_columnIndex, 8);
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.m_segments.elements();
        while (enumeration.hasMoreElements()) {
            ((SegmentLayout)enumeration.nextElement()).doLayout();
        }
        this.debugTimer("ColumnLayout.doLayout() ", l);
    }

    public int getMinimumLocation() {
        this.debug("ColumnLayout.getMinimumLocation(): m_minLocation " + this.m_minLocation + ", index " + this.m_columnIndex, 6);
        return this.m_minLocation;
    }

    public int getPreferredLocation() {
        this.debug("ColumnLayout.getPreferredLocation(): m_prefLocation " + this.m_prefLocation + ", index " + this.m_columnIndex, 6);
        return this.m_prefLocation;
    }

    private int getCurrentLocation() {
        this.debug("ColumnLayout.getCurrentLocation(): m_currLocation " + this.m_currLocation + ", index " + this.m_columnIndex, 8);
        return this.m_currLocation;
    }

    public int getIndex() {
        this.debug("ColumnLayout.getIndex(): index " + this.m_columnIndex, 10);
        return this.m_columnIndex;
    }

    private void calculateLabelWidth() {
        this.m_labelWidth = 0;
        Enumeration enumeration = this.m_segments.elements();
        while (enumeration.hasMoreElements()) {
            SegmentLayout segmentLayout = (SegmentLayout)enumeration.nextElement();
            if (segmentLayout.m_label == null || segmentLayout.m_labelMode == 2 || ((SegmentLayout)segmentLayout).m_label.getPreferredSize().width <= this.m_labelWidth) continue;
            this.m_labelWidth = ((SegmentLayout)segmentLayout).m_label.getPreferredSize().width;
        }
    }

    private void debugTimer(String string, long l) {
        this.debug(string + " total time: " + (System.currentTimeMillis() - l), 1);
    }

    private void debug(String string, int n) {
        if (0 >= n) {
            for (int i = 0; i < n; ++i) {
                string = "-" + string;
            }
            System.out.println(string);
        }
    }

    public class SegmentLayout {
        private Component m_label = null;
        private Vector m_components = null;
        private int m_segmentIndex = 0;
        private int m_labelMode = 0;
        private SegmentLayout m_followingSegment = null;
        private SegmentLayout m_previousSegment = null;
        private boolean m_isGhost = false;
        private double m_pct = 0.0;
        private int m_lastGhost = Integer.MAX_VALUE;

        public SegmentLayout(int n) {
            ColumnLayout.this.debug("SegmentLayout.SegmentLayout(int): segmentIndex " + n + ", column " + ColumnLayout.this.m_columnIndex, 3);
            this.m_components = new Vector();
            this.m_segmentIndex = n;
        }

        public void add(Component component, double d) {
            ColumnLayout.this.debug("SegmentLayout.add(Component): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            this.add(component, this.m_labelMode, d);
        }

        public void add(Component component, int n, double d) {
            ColumnLayout.this.debug("SegmentLayout.add(Component, int): mode " + n + ", segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            this.setPct(d);
            if (this.m_label == null) {
                this.m_label = component;
                this.m_labelMode = n;
                if (n == 0 && component.getPreferredSize().width > ColumnLayout.this.m_labelWidth) {
                    ColumnLayout.this.debug("SegmentLayout.add(Component): setting label width to " + component.getPreferredSize().width + ", segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
                    ColumnLayout.this.m_labelWidth = component.getPreferredSize().width;
                }
            } else {
                this.m_components.add(component);
                if (this.m_isGhost) {
                    this.m_labelMode = n;
                }
            }
        }

        public void addGhost(Component component) {
            ColumnLayout.this.debug("SegmentLayout.addGhost(Component): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            this.m_isGhost = true;
            this.add(component, 0.0);
        }

        public void addGhost(Component component, int n) {
            ColumnLayout.this.debug("SegmentLayout.addGhost(Component, int): mode " + n + ", segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            this.m_isGhost = true;
            this.add(component, n, 0.0);
        }

        public void setLastGhost(int n) {
            ColumnLayout.this.debug("SegmentLayout.setLastGhost(int): setting last ghost to " + n, 3);
            this.m_lastGhost = n;
        }

        protected void removeLayoutComponent(Component component) {
            ColumnLayout.this.debug("SegmentLayout.removeLayoutComponent(Component): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            if (this.m_label == component) {
                if (this.m_components.size() == 0) {
                    this.removeThisSegment();
                } else {
                    this.m_label = (Component)this.m_components.remove(0);
                    this.m_labelMode = 0;
                    if (this.m_label.getPreferredSize().width > ColumnLayout.this.m_labelWidth) {
                        ColumnLayout.this.m_labelWidth = this.m_label.getPreferredSize().width;
                    }
                }
                return;
            }
            if (this.m_components.remove(component)) {
                return;
            }
            if (this.m_previousSegment != null) {
                this.m_previousSegment.removeLayoutComponent(component);
            }
        }

        private void removeThisSegment() {
            ColumnLayout.this.debug("SegmentLayout.removeThisSegment(Component): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 3);
            if (this.m_previousSegment == null) {
                this.m_followingSegment.m_previousSegment = null;
            } else {
                this.m_followingSegment.m_previousSegment = this.m_previousSegment;
                this.m_previousSegment.m_followingSegment = this.m_followingSegment;
            }
        }

        private void setPct(double d) {
            if (d > 1.0) {
                d = 1.0;
            }
            if (d < 0.0) {
                d = 0.0;
            }
            this.m_pct = d;
        }

        public SegmentLayout getSegment(ColumnLayout columnLayout) {
            ColumnLayout.this.debug("SegmentLayout.getSegment(ColumnLayout): column " + columnLayout.getIndex() + ", segmentIndex " + this.m_segmentIndex, 3);
            if (columnLayout.getIndex() == ColumnLayout.this.m_columnIndex) {
                return this;
            }
            if (columnLayout.getIndex() < ColumnLayout.this.m_columnIndex) {
                if (this.m_previousSegment == null) {
                    ColumnLayout.this.debug("SegmentLayout.getSegment(ColumnLayout): adding segmentIndex to the left of column " + ColumnLayout.this.m_columnIndex + ", new column " + columnLayout.getIndex() + ", segmentIndex " + this.m_segmentIndex, 3);
                    SegmentLayout segmentLayout = columnLayout.addSegment(this.m_segmentIndex);
                    segmentLayout.m_previousSegment = null;
                    segmentLayout.m_followingSegment = this;
                    this.m_previousSegment = segmentLayout;
                    return segmentLayout;
                }
                return this.m_previousSegment.getSegment(columnLayout);
            }
            ColumnLayout.this.debug("SegmentLayout.getSegment(ColumnLayout): adding segmentIndex to the right of column " + ColumnLayout.this.m_columnIndex + ", new column " + columnLayout.getIndex() + ", segmentIndex " + this.m_segmentIndex, 3);
            SegmentLayout segmentLayout = columnLayout.addSegment(this.m_segmentIndex);
            segmentLayout.m_followingSegment = this.m_followingSegment;
            this.m_followingSegment.m_previousSegment = segmentLayout;
            segmentLayout.m_previousSegment = this;
            this.m_followingSegment = segmentLayout;
            return segmentLayout;
        }

        public void doLayout() {
            int n;
            int n2;
            ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", m_pct " + this.m_pct, 8);
            if (this.m_isGhost) {
                return;
            }
            if (this.m_label == null) {
                ColumnLayout.this.debug("SegmentLayout.doLayout(): m_label is null", 8);
                return;
            }
            int n3 = 0;
            if (this.m_labelMode == 1) {
                n2 = this.m_label.getPreferredSize().width - ColumnLayout.this.m_labelWidth;
                ColumnLayout.this.debug("SegmentLayout.doLayout(): m_label.getPreferredSize().width " + this.m_label.getPreferredSize().width + ", m_labelWidth " + ColumnLayout.this.m_labelWidth + ", segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 8);
                if (n2 < 0) {
                    n2 = 0;
                }
                n3 = ColumnLayout.this.m_currLocation - n2;
                ColumnLayout.this.debug("SegmentLayout.doLayout(): offset " + n2 + ", labelLocation " + n3 + ", segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 8);
            } else {
                n3 = ColumnLayout.this.m_currLocation;
            }
            if (this.m_labelMode == 2 && this.m_components.size() == 0) {
                int n4;
                ColumnLayout.this.debug("SegmentLayout.doLayout(): FREE_FIELD and no components, so treating as a big field", 8);
                n2 = this.m_followingSegment.getLeftBoundary();
                if (this.m_lastGhost < Integer.MAX_VALUE) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): has ghosts", 8);
                    SegmentLayout segmentLayout = null;
                    Enumeration enumeration = ColumnLayout.this.m_segments.elements();
                    while (enumeration.hasMoreElements()) {
                        segmentLayout = (SegmentLayout)enumeration.nextElement();
                        if (segmentLayout.m_segmentIndex <= this.m_segmentIndex || segmentLayout.m_segmentIndex > this.m_lastGhost) continue;
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): checking ghost for row " + segmentLayout.m_segmentIndex, 8);
                        if (segmentLayout.m_followingSegment.getLeftBoundary() >= n2) continue;
                        n2 = segmentLayout.m_followingSegment.getLeftBoundary();
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): resetting left boundary to " + n2, 8);
                    }
                }
                int n5 = n2 - ColumnLayout.this.m_currLocation;
                ColumnLayout.this.debug("SegmentLayout.doLayout(): room: " + n5, 8);
                if (this.m_label.getMinimumSize().width >= n5) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): not enough room for min; forcing min: " + this.m_label.getMinimumSize().width, 8);
                    int n6 = this.m_label.getMinimumSize().width;
                }
                if (this.m_pct == 1.0) {
                    if (n5 <= this.m_label.getMaximumSize().width || this.m_label.getMaximumSize().width <= this.m_label.getPreferredSize().width) {
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): m_pct is 1; setting size to room: " + n5, 8);
                        n4 = n5;
                    } else {
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): m_pct is 1; room > max; setting size to max: " + this.m_label.getMaximumSize().width, 8);
                        n4 = this.m_label.getMaximumSize().width;
                    }
                } else if (this.m_label.getPreferredSize().width >= n5) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): no extra room; setting size to: " + n5, 8);
                    n4 = n5;
                } else if ((double)this.m_label.getPreferredSize().width + (double)(this.m_label.getPreferredSize().width - this.m_label.getMinimumSize().width) * this.m_pct >= (double)n5) {
                    if (n5 <= this.m_label.getMaximumSize().width || this.m_label.getMaximumSize().width <= this.m_label.getPreferredSize().width) {
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): stretch reaches; setting size to : " + n5, 8);
                        n4 = n5;
                    } else {
                        ColumnLayout.this.debug("SegmentLayout.doLayout(): stretch reaches, but beyond max; setting size to max: " + this.m_label.getMaximumSize().width, 8);
                        n4 = this.m_label.getMaximumSize().width;
                    }
                } else {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): stretch doesn't reach; setting size to preferred0: " + this.m_label.getPreferredSize().width, 8);
                    n4 = this.m_label.getPreferredSize().width;
                }
                this.m_label.setSize(n4, this.m_label.getSize().height);
                if (n4 < ColumnLayout.this.m_labelWidth && this.m_label.getAlignmentX() == 1.0f) {
                    n3 += ColumnLayout.this.m_labelWidth - n4;
                }
                ColumnLayout.this.debug("SegmentLayout.doLayout(): setting labelLocation " + n3 + ", label width " + this.m_label.getPreferredSize().width, 8);
                this.m_label.setLocation(n3, this.m_label.getLocation().y);
                return;
            }
            this.m_label.setSize(this.m_label.getPreferredSize().width, this.m_label.getSize().height);
            if (this.m_label.getPreferredSize().width < ColumnLayout.this.m_labelWidth && this.m_label.getAlignmentX() == 1.0f) {
                n3 += ColumnLayout.this.m_labelWidth - this.m_label.getPreferredSize().width;
            }
            this.m_label.setLocation(n3, this.m_label.getLocation().y);
            n2 = 0;
            int n7 = 0;
            if (this.m_components.size() == 0) {
                return;
            }
            Enumeration enumeration = this.m_components.elements();
            Component component = null;
            while (enumeration.hasMoreElements()) {
                component = (Component)enumeration.nextElement();
                n2 += component.getMinimumSize().width;
                n7 += component.getPreferredSize().width;
            }
            int n8 = (this.m_components.size() - 1) * ColumnLayout.this.m_containingLayout.getInternalHGap();
            n2 += n8;
            n7 += n8;
            int n9 = this.m_followingSegment.getLeftBoundary();
            ColumnLayout.this.debug("SegmentLayout.doLayout(): initial following left boundary is " + n9, 8);
            if (this.m_lastGhost < Integer.MAX_VALUE) {
                SegmentLayout segmentLayout = null;
                enumeration = ColumnLayout.this.m_segments.elements();
                while (enumeration.hasMoreElements()) {
                    segmentLayout = (SegmentLayout)enumeration.nextElement();
                    if (segmentLayout.m_followingSegment.getLeftBoundary() >= n9 || segmentLayout.m_segmentIndex <= this.m_segmentIndex || segmentLayout.m_segmentIndex > this.m_lastGhost) continue;
                    n9 = segmentLayout.m_followingSegment.getLeftBoundary();
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): resetting left boundary to " + n9, 8);
                }
            }
            int n10 = n9 - ColumnLayout.this.m_currLocation;
            ColumnLayout.this.debug("SegmentLayout.doLayout(): room: " + n10, 8);
            int n11 = ColumnLayout.this.m_currLocation;
            if (this.m_labelMode == 2) {
                n10 -= this.m_label.getPreferredSize().width;
                n11 += this.m_label.getPreferredSize().width;
                if (this.m_label.getPreferredSize().width > 0) {
                    n10 -= ColumnLayout.this.m_containingLayout.getInternalHGap();
                    n11 += ColumnLayout.this.m_containingLayout.getInternalHGap();
                }
            } else {
                n10 -= ColumnLayout.this.m_labelWidth;
                n11 += ColumnLayout.this.m_labelWidth;
                if (ColumnLayout.this.m_labelWidth > 0 || this.m_labelMode == 1) {
                    n10 -= ColumnLayout.this.m_containingLayout.getInternalHGap();
                    n11 += ColumnLayout.this.m_containingLayout.getInternalHGap();
                }
            }
            if (n10 > n7 && (double)n7 + (double)(n7 - n2) * this.m_pct < (double)n10 && this.m_pct < 1.0) {
                n10 = n7;
            }
            double d = 0.0;
            if (n7 - n2 > 0) {
                d = (double)(n10 - n2) / (double)(n7 - n2);
            }
            enumeration = this.m_components.elements();
            Component component2 = null;
            Component component3 = null;
            if (enumeration.hasMoreElements()) {
                component3 = (Component)enumeration.nextElement();
                if (this.m_components.size() > 1) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; setting component location to " + n11, 8);
                    component3.setLocation(n11, component3.getLocation().y);
                }
            }
            while (enumeration.hasMoreElements()) {
                component2 = component3;
                component3 = (Component)enumeration.nextElement();
                n11 = component2.getMinimumSize().width < component2.getPreferredSize().width ? (int)((double)n11 + ((double)component2.getMinimumSize().width + (double)(component2.getPreferredSize().width - component2.getMinimumSize().width) * d)) : (n11 += component2.getMinimumSize().width);
                if (component2.getMinimumSize().width > 0) {
                    n11 += ColumnLayout.this.m_containingLayout.getInternalHGap();
                }
                component3.setLocation(n11, component3.getLocation().y);
                n = n11 - component2.getLocation().x - ColumnLayout.this.m_containingLayout.getInternalHGap();
                ColumnLayout.this.debug("SegmentLayout.doLayout(): maximum width " + component3.getMaximumSize().width + ", preferred with " + component3.getPreferredSize().width, 8);
                if (n <= component3.getMaximumSize().width || component3.getMaximumSize().width <= component3.getPreferredSize().width) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; setting component size to " + n, 8);
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; setting component location to " + n11, 8);
                    component2.setSize(n, component2.getSize().height);
                    continue;
                }
                n = component3.getMaximumSize().width;
                ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; setting component size to max " + n, 8);
                ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; setting component location to " + n11, 8);
                component2.setSize(n, component2.getSize().height);
            }
            n = 0;
            if (d == 1.0) {
                ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; final component leaving space, so setting component size to preferred: " + component3.getPreferredSize(), 8);
                n = component3.getPreferredSize().width;
            } else {
                n = n9 - n11;
                if (n <= component3.getMaximumSize().width || component3.getMaximumSize().width <= component3.getPreferredSize().width) {
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", followingLeftBoundary " + n9 + ", startx " + n11, 8);
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; final component meets following boundary, so setting component size to room left: " + n, 8);
                } else {
                    n = component3.getMaximumSize().width;
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", followingLeftBoundary " + n9 + ", startx " + n11, 8);
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; final component meets following boundary, which exceeds max, so setting component size to max: " + n, 8);
                }
            }
            component3.setSize(n, component3.getSize().height);
            if (this.m_components.size() == 1) {
                if (n + n11 < n9 && component3.getAlignmentX() == 1.0f) {
                    n11 += n9 - (n + n11);
                    ColumnLayout.this.debug("SegmentLayout.doLayout(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + "; xalign " + component3.getAlignmentX() + "; setting component location to " + n11, 0);
                }
                component3.setLocation(n11, component3.getLocation().y);
            }
        }

        public int getMinimumLocation() {
            ColumnLayout.this.debug("SegmentLayout.getMinimumLocation(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 6);
            if (this.m_previousSegment == null) {
                return ColumnLayout.this.m_containingLayout.getLeftInset();
            }
            if (this.m_followingSegment == null) {
                return this.m_previousSegment.getMinRightBoundary() + this.getLabelOffset() + ColumnLayout.this.m_containingLayout.getInternalHGap();
            }
            return this.m_previousSegment.getMinRightBoundary() + this.getLabelOffset() + ColumnLayout.this.m_containingLayout.getInternalHGap();
        }

        public int getPreferredLocation() {
            ColumnLayout.this.debug("SegmentLayout.getPreferredLocation(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 6);
            if (this.m_previousSegment == null) {
                return ColumnLayout.this.m_containingLayout.getLeftInset();
            }
            if (this.m_followingSegment == null) {
                return this.m_previousSegment.getPrefRightBoundary() + this.getLabelOffset();
            }
            return this.m_previousSegment.getPrefRightBoundary() + this.getLabelOffset() + ColumnLayout.this.m_containingLayout.getInternalHGap();
        }

        public int getLeftBoundary() {
            ColumnLayout.this.debug("SegmentLayout.getLeftBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 8);
            if (this.m_followingSegment == null) {
                ColumnLayout.this.debug("SegmentLayout.getLeftBoundary(): m_followingSegment is null -- returning column's current location", 8);
                return ColumnLayout.this.m_currLocation;
            }
            return ColumnLayout.this.m_currLocation - this.getLabelOffset() - ColumnLayout.this.m_containingLayout.getInternalHGap();
        }

        public int getMinRightBoundary() {
            ColumnLayout.this.debug("SegmentLayout.getMinRightBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 6);
            int n = ColumnLayout.this.m_labelWidth;
            if (this.m_labelMode == 2 && this.m_label.getMinimumSize().width > ColumnLayout.this.m_labelWidth) {
                n = this.m_label.getMinimumSize().width;
            }
            ColumnLayout.this.debug("SegmentLayout.getMinRightBoundary(): starting with " + n + " for label", 6);
            Enumeration enumeration = this.m_components.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                ColumnLayout.this.debug("SegmentLayout.getMinRightBoundary(): adding " + component.getMinimumSize().width + " for component to get " + (n += component.getMinimumSize().width), 6);
                if (component.getMinimumSize().width <= 0) continue;
                n += ColumnLayout.this.m_containingLayout.getInternalHGap();
            }
            ColumnLayout.this.debug("SegmentLayout.getMinRightBoundary(): returning " + (ColumnLayout.this.m_minLocation + n), 6);
            return ColumnLayout.this.m_minLocation + n;
        }

        public int getPrefRightBoundary() {
            ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", mode " + this.m_labelMode, 6);
            if (this.m_label == null) {
                ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): doh!  m_label is null!", 6);
            }
            int n = ColumnLayout.this.m_labelWidth;
            if (this.m_labelMode == 2 || this.m_label.getPreferredSize().width == 0 && !this.m_isGhost) {
                n = this.m_label.getPreferredSize().width;
                ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", starting with " + n + " for label", 6);
            } else {
                ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", starting with " + n + " for label", 6);
            }
            Enumeration enumeration = this.m_components.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                n += component.getPreferredSize().width;
                ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex + ", adding " + component.getPreferredSize().width + " for component (not including gap)", 6);
                if (component.getPreferredSize().width <= 0 || this.m_isGhost) continue;
                n += ColumnLayout.this.m_containingLayout.getInternalHGap();
            }
            ColumnLayout.this.debug("SegmentLayout.getPrefRightBoundary(): returning " + (ColumnLayout.this.m_prefLocation + n), 6);
            return ColumnLayout.this.m_prefLocation + n;
        }

        private int getLabelOffset() {
            ColumnLayout.this.debug("SegmentLayout.getLabelOffset(): segmentIndex " + this.m_segmentIndex + ", column " + ColumnLayout.this.m_columnIndex, 6);
            int n = 0;
            if (this.m_labelMode == 1 && this.m_label.getPreferredSize().width > ColumnLayout.this.m_labelWidth) {
                n = this.m_label.getPreferredSize().width - ColumnLayout.this.m_labelWidth;
            }
            ColumnLayout.this.debug("SegmentLayout.getLabelOffset(): returning " + n, 10);
            return n;
        }

        public int getIndex() {
            return this.m_segmentIndex;
        }
    }
}

