/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFDocument;
import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPageFormat;
import com.infocom.print.PFPoint;
import com.infocom.print.PFPrintObject;
import com.infocom.print.PFSize;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Vector;

public class PFPage
implements Printable {
    private PFPageFormat pageFormat = new PFPageFormat();
    private Vector pageObjectCollection = new Vector();
    private PFPrintObject header = null;
    private PFPrintObject footer = null;
    private PFDocument document = null;

    public void setPageFormat(PFPageFormat pFPageFormat) {
        if (pFPageFormat != null) {
            this.pageFormat = pFPageFormat;
        }
    }

    public PFPageFormat getPageFormat() {
        return (PFPageFormat)this.pageFormat.clone();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        PFPrintObject pFPrintObject;
        Graphics2D graphics2D = (Graphics2D)graphics;
        PFPrintObject pFPrintObject2 = this.getHeader();
        if (pFPrintObject2 != null) {
            pFPrintObject2.setRelativeMode(false);
            pFPrintObject2.setPosition(new PFPoint(this.pageFormat.getLeftMargin(), this.pageFormat.getTopMargin()));
            pFPrintObject2.print(graphics2D);
        }
        if ((pFPrintObject = this.getFooter()) != null) {
            pFPrintObject.setRelativeMode(false);
            PFSize pFSize = this.pageFormat.getPageAreaSize();
            PFPoint pFPoint = new PFPoint(this.pageFormat.getLeftMargin(), this.pageFormat.getPageAreaSize().getHeight().substract(pFPrintObject.getSize().getHeight()).add(this.pageFormat.getBottomMargin()));
            pFPrintObject.setPosition(pFPoint);
            pFPrintObject.print(graphics2D);
        }
        for (int i = 0; i < this.pageObjectCollection.size(); ++i) {
            PFPrintObject pFPrintObject3 = (PFPrintObject)this.pageObjectCollection.get(i);
            pFPrintObject3.print(graphics2D);
        }
        return 0;
    }

    public void add(PFPrintObject pFPrintObject) {
        this.pageObjectCollection.add(pFPrintObject);
        pFPrintObject.setPage(this);
    }

    public void remove(PFPrintObject pFPrintObject) {
        this.pageObjectCollection.remove(pFPrintObject);
    }

    public void setDocument(PFDocument pFDocument) {
        this.document = pFDocument;
    }

    public PFPoint getPrintableAreaOrigin() {
        PFPoint pFPoint = this.getHeader() != null ? new PFPoint(this.pageFormat.getLeftMargin().add(this.pageFormat.getGutter()), this.pageFormat.getTopMargin().add(this.getHeader().getSize().getHeight())) : new PFPoint(this.pageFormat.getLeftMargin().add(this.pageFormat.getGutter()), this.pageFormat.getTopMargin());
        return pFPoint;
    }

    public PFSize getPrintableAreaSize() {
        PFSize pFSize = new PFSize(new PFInchUnit(0.0), new PFInchUnit(0.0));
        pFSize.setWidth((PFInchUnit)this.pageFormat.getPageSize().getWidth().substract(this.pageFormat.getLeftMargin()).substract(this.pageFormat.getGutter()).substract(this.pageFormat.getRightMargin()));
        pFSize.setHeight(this.pageFormat.getPageSize().getHeight().substract(this.pageFormat.getTopMargin()).substract(this.pageFormat.getBottomMargin()));
        if (this.header != null) {
            pFSize.setHeight(pFSize.getHeight().substract(this.header.getSize().getHeight()));
        }
        if (this.footer != null) {
            pFSize.setHeight(pFSize.getHeight().substract(this.footer.getSize().getHeight()));
        }
        return pFSize;
    }

    public void setHeader(PFPrintObject pFPrintObject) {
        this.header = pFPrintObject;
        this.header.setPage(this);
    }

    public PFPrintObject getHeader() {
        if (this.document != null && this.header == null && this.document.getHeader(this) != null) {
            return this.document.getHeader();
        }
        return this.header;
    }

    public void setFooter(PFPrintObject pFPrintObject) {
        this.footer = pFPrintObject;
        this.footer.setPage(this);
    }

    public PFPrintObject getFooter() {
        if (this.document != null && this.footer == null && this.document.getFooter(this) != null) {
            return this.document.getFooter();
        }
        return this.footer;
    }

    public int getPageNo() {
        return this.document.getPageNo(this);
    }
}

