/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapTile;
import com.informagen.giv.MosaicLayout;
import java.awt.Component;
import java.awt.Dimension;

class GlyphPanel
extends MapTile {
    private int mPanelWidth = 0;
    private double mMinExtent;
    private double mMaxExtent;
    private double mHScale;
    boolean hidden = false;

    GlyphPanel() {
        this(0);
    }

    GlyphPanel(int n) {
        this(n, 0.0, 1000.0);
    }

    GlyphPanel(int n, double d, double d2) {
        this.setLayout(new MosaicLayout(n));
        this.setExtent(d, d2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.hidden) {
            dimension = new Dimension(this.mPanelWidth, 0);
        } else {
            dimension = this.getLayout().preferredLayoutSize(this);
            dimension.width = this.mPanelWidth;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.hidden = !bl;
        if (bl) {
            this.setPanelWidth(this.mPanelWidth);
        }
    }

    public boolean isVisible() {
        return !this.hidden;
    }

    void setExtent(double d, double d2) {
        this.mMinExtent = d < d2 ? d : d2;
        this.mMaxExtent = d2 > d ? d2 : d;
    }

    void setPanelWidth(int n) {
        this.mPanelWidth = n;
        this.mHScale = (double)this.mPanelWidth / (this.mMaxExtent - this.mMinExtent);
        if (this.hidden) {
            return;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            if (component instanceof MapTile) {
                ((MapTile)component).adjustSize(this.mMinExtent, this.mHScale);
                continue;
            }
            if (!(component instanceof MapGlyph)) continue;
            MapGlyph mapGlyph = (MapGlyph)component;
            int n2 = (int)(((double)mapGlyph.mStart - this.mMinExtent) * this.mHScale);
            int n3 = (int)(((double)mapGlyph.mStop - this.mMinExtent) * this.mHScale);
            mapGlyph.setBarWidth(n3 - n2 + 1);
            int n4 = n2 - mapGlyph.mBarInset;
            mapGlyph.setLocation(n4, 0);
        }
    }
}

