/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.ElementStyle;
import com.informagen.giv.GIVColors;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapPanel;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapView;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class NorthXMLHandler
extends DefaultHandler {
    private static final int kNoPCDATA = 0;
    private static final double kEdgeBorder = 0.05;
    private final Hashtable elementStyleTable = new Hashtable();
    String xmlSource;
    private MapView mapView;
    private final MapPanel bacMapPanel = new MapPanel();
    private final MapPanel estMapPanel = new MapPanel();
    private MapTile clusterTile;
    private MapTile consensusTile;
    private MapTile exonTile;
    private MapTile ebTile;
    private MapTile cDnaTile;
    private MapTile estTile;

    NorthXMLHandler(MapView mapView) {
        this.mapView = mapView;
    }

    public void setXMLSource(String string) {
        this.xmlSource = string;
    }

    public void startDocument() {
    }

    public void characters(char[] cArray, int n, int n2) {
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("Hybrid")) {
            this.doInitialize(attributes);
        } else if (string.equals("DNAClone")) {
            this.doDNAClone(attributes);
        } else if (string.equals("Gene")) {
            this.doGene(attributes);
        } else if (string.equals("cDNA")) {
            this.doCDNA(attributes);
        } else if (string.equals("PlusFrameEST")) {
            this.addEST(attributes, "+ Frame EST");
        } else if (string.equals("MinusFrameEST")) {
            this.addEST(attributes, "- Frame EST");
        } else if (string.equals("Exons")) {
            this.addHSP(attributes);
        } else if (string.equals("HSP")) {
            this.addHSP(attributes);
        } else if (string.equals("mRNAspan")) {
            this.doRNAspan(attributes);
        } else if (string.equals("Consensus")) {
            this.doRNAspan(attributes);
        } else if (string.equals("Coding")) {
            this.doRNA("Exon", attributes);
        } else if (string.equals("NonCoding")) {
            this.doRNA("Intron", attributes);
        } else if (string.equals("ExonBoundary")) {
            this.doExonBoundary(attributes);
        }
    }

    public void endElement(String string) {
        if (string.equals("Gene")) {
            this.estMapPanel.add(this.clusterTile);
        } else if (string.equals("cDNA")) {
            this.clusterTile.add(this.cDnaTile);
        } else if (string.equals("PlusFrameEST")) {
            this.cDnaTile.add(this.estTile);
        } else if (string.equals("MinusFrameEST")) {
            this.cDnaTile.add(this.estTile);
        }
    }

    public void endDocument() {
    }

    private void doInitialize(Attributes attributes) {
        this.addStyleFor("DNAClone", "Navy", "Always", "Below", 15);
        this.addStyleFor("mRNA Span", "Orange", "Never", "Below", 4);
        this.addStyleFor("Exon", "Blue", "Never", "Below", 4);
        this.addStyleFor("Intron", "Black", "Never", "Below", 3);
        this.addStyleFor("ExonBoundary", "Blue", "Never", "Below", 10);
        this.addStyleFor("Gene", "Magenta", "Always", "Above", 7);
        this.addStyleFor("HSP", "Blue", "Never", "Below", 5);
        String string = attributes.getValue("title");
    }

    private void createBACpanel(int n, int n2) {
        String string = "Apricot";
        String string2 = "Floating";
        int n3 = 0;
        int n4 = 1;
        this.bacMapPanel.setBuoyancy(string2, n3, n4);
        this.bacMapPanel.setWallpaper(GIVColors.getColor(string));
        this.bacMapPanel.setTitle("BAC");
        this.bacMapPanel.setExtent(n, n2);
        this.mapView.add(this.bacMapPanel);
    }

    private void createESTpanel(int n, int n2) {
        String string = "Apricot";
        String string2 = "Floating";
        int n3 = 0;
        int n4 = 1;
        this.estMapPanel.setBuoyancy(string2, n3, n4);
        this.estMapPanel.setWallpaper(GIVColors.getColor(string));
        this.estMapPanel.setTitle("BAC");
        this.estMapPanel.setExtent(n, n2);
        this.mapView.add(this.estMapPanel);
    }

    private void addStyleFor(String string, String string2, String string3, String string4, int n) {
        ElementStyle elementStyle = new ElementStyle();
        int n2 = 0;
        if (string3.equalsIgnoreCase("Always")) {
            n2 = 0;
        } else if (string3.equalsIgnoreCase("Bigger")) {
            n2 = 1;
        } else if (string3.equalsIgnoreCase("Never")) {
            n2 = 2;
        }
        elementStyle.labelDisplay(n2);
        int n3 = 0;
        if (string4.equalsIgnoreCase("Below")) {
            n3 = 0;
        } else if (string4.equalsIgnoreCase("Above")) {
            n3 = 1;
        }
        elementStyle.labelPosition(n3);
        elementStyle.barHeight(n);
        elementStyle.setColor(GIVColors.getColor(string2));
        this.elementStyleTable.put(string, elementStyle);
    }

    private void doDNAClone(Attributes attributes) {
        String string = attributes.getValue("name");
        int n = Integer.parseInt(attributes.getValue("length"));
        int n2 = -((int)((double)n * 0.05));
        int n3 = (int)((double)n * 1.05);
        this.createBACpanel(n2, n3);
        this.createESTpanel(n2, n3);
        String string2 = "DNAClone";
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string2);
        MapGlyph mapGlyph = new MapGlyph(string, 1.0f, n, elementStyle);
        this.bacMapPanel.add(mapGlyph);
    }

    private void doGene(Attributes attributes) {
        String string = attributes.getValue("number");
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        String string2 = "StackDown";
        int n3 = 0;
        int n4 = 8;
        this.clusterTile = new MapTile(string2, n3, n4);
        String string3 = "Gene " + string;
        String string4 = string3 + " Cluster";
        this.clusterTile.setName(string4);
        string2 = "Floating";
        n3 = 0;
        n4 = 2;
        this.consensusTile = new MapTile(string2, n3, n4);
        this.clusterTile.add(this.consensusTile);
        n3 = 0;
        n4 = 0;
        this.exonTile = new MapTile(string2, 0, 0);
        this.exonTile.setName("Exon, Introns, and No EST Coverage group");
        this.clusterTile.add(this.exonTile);
        n3 = 0;
        n4 = 0;
        this.ebTile = new MapTile(string2, 0, 0);
        this.ebTile.setName("Exon boundaries group");
        this.clusterTile.add(this.ebTile);
        String string5 = "Gene";
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string5);
        MapGlyph mapGlyph = new MapGlyph(string3, n, n2, elementStyle);
        this.clusterTile.add(mapGlyph);
    }

    private void doCDNA(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("name");
        String string3 = attributes.getValue("src");
        String string4 = attributes.getValue("url");
        String string5 = "Floating";
        String string6 = "AGA 06";
        int n = 0;
        int n2 = 1;
        this.cDnaTile = new MapTile(string5, n, n2);
        this.cDnaTile.setBkgColor(GIVColors.getColor(string6));
        this.cDnaTile.setName(string3 + ":" + string2);
    }

    private void addEST(Attributes attributes, String string) {
        String string2 = "Floating";
        int n = 0;
        int n2 = 2;
        this.estTile = new MapTile(string2, n, n2);
        if (string.equals("+ Frame EST")) {
            this.estTile.setBkgColor(GIVColors.getColor("Red"));
        } else if (string.equals("- Frame EST")) {
            this.estTile.setBkgColor(GIVColors.getColor("Green"));
        }
        String string3 = attributes.getValue("dir");
        StringBuffer stringBuffer = new StringBuffer();
        if (string3.equals("NA")) {
            stringBuffer.append(this.cDnaTile.getName());
        } else {
            stringBuffer.append(this.cDnaTile.getName()).append(" ").append(string3);
        }
        this.estTile.setName(stringBuffer.toString());
    }

    private void addHSP(Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        String string = "HSP";
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string);
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append(this.estTile.getName()).append(" ").append(string);
        MapGlyph mapGlyph = new MapGlyph(stringBuffer.toString(), n, n2, elementStyle);
        this.estTile.add(mapGlyph);
    }

    private void doRNA(String string, Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string);
        MapGlyph mapGlyph = new MapGlyph(string, n, n2, elementStyle);
        this.exonTile.add(mapGlyph);
    }

    private void doExonBoundary(Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("at"));
        String string = "ExonBoundary";
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string);
        MapGlyph mapGlyph = new MapGlyph(string, n, n, elementStyle);
        this.ebTile.add(mapGlyph);
    }

    private void doRNAspan(Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        String string = "mRNA Span";
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cDnaTile.getName());
        stringBuffer.append(" mRNA span");
        MapGlyph mapGlyph = new MapGlyph(stringBuffer.toString(), n, n2, elementStyle);
        this.consensusTile.add(mapGlyph);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("XML Parsing Error: " + sAXParseException.getMessage());
        System.out.println("       XML source: " + this.xmlSource);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("XML Parsing Warning: " + sAXParseException.getMessage());
        System.out.println("         XML source: " + this.xmlSource);
    }
}

