/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import ch.randelshofer.quaqua.JSheet;
import ch.randelshofer.quaqua.SheetEvent;
import ch.randelshofer.quaqua.SheetListener;
import com.informagen.CODATAFile;
import com.informagen.DNASISFile;
import com.informagen.DNAStarFile;
import com.informagen.DNAStriderFile;
import com.informagen.EMBLFile;
import com.informagen.FASTAFile;
import com.informagen.GCGFile;
import com.informagen.GenBANKFile;
import com.informagen.MacVectorFile;
import com.informagen.PIRFile;
import com.informagen.RAWFile;
import com.informagen.Sequence;
import com.informagen.SequenceFile;
import com.informagen.StateMonitor;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.FarFetch;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.composition.CompositionPanel;
import com.informagen.sa.dialogs.LengthDialog;
import com.informagen.sa.dialogs.SampledDialog;
import com.informagen.sa.dialogs.SequenceInfoDialog;
import com.informagen.sa.digest.DigestPanel;
import com.informagen.sa.format.FormatPanel;
import com.informagen.sa.giv.FeaturesPanel;
import com.informagen.sa.orf.ORFAnalysisPanel;
import com.informagen.sa.pI.IsoElectricPointPanel;
import com.informagen.sa.pairwise.PairwisePanel;
import com.informagen.sa.pattern.PatternPanel;
import com.informagen.sa.primerdesign.PrimerDesignPanel;
import com.informagen.sa.publish.PublishPanel;
import com.informagen.sa.structure.StructurePanel;
import com.informagen.sequence.editor.Editor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.roydesign.io.SpecialFolder;
import net.roydesign.mac.MRJAdapter;
import net.roydesign.ui.JScreenMenu;
import net.roydesign.ui.JScreenMenuBar;
import net.roydesign.ui.JScreenMenuItem;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class SAFrame
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = -8104373208510333245L;
    public static final int WINDOW_FONTSIZE = 10;
    public static final int MACOS_FONTSIZE = 12;
    private final SequenceAnalysis application;
    private final StateMonitor stateMonitor = new StateMonitor();
    private final JScreenMenuBar menubar = new JScreenMenuBar();
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private static int randomSequenceID = 1;
    private static int sampledSequenceID = 1;
    private static int untitledSequenceID = 1;
    private final JScreenMenu fileMenu = new JScreenMenu("File");
    private final JScreenMenuItem newMenuItem = new JScreenMenuItem("New sequence");
    private final JScreenMenuItem farfetchMenuItem = new JScreenMenuItem("Fetch from NCBI");
    private final JScreenMenu randomMenu = new JScreenMenu("Generate Random...");
    private final JScreenMenuItem randomNucleicMenuItem = new JScreenMenuItem("Nucleic Acid Sequence");
    private final JScreenMenuItem randomProteinMenuItem = new JScreenMenuItem("Protein Sequence");
    private final JScreenMenu sampledMenu = new JScreenMenu("Generate Sampled...");
    private final JScreenMenuItem sampledNucleicMenuItem = new JScreenMenuItem("Nucleic Acid Sequence");
    private final JScreenMenuItem sampledProteinMenuItem = new JScreenMenuItem("Protein Sequence");
    private final JScreenMenu openMenu = new JScreenMenu("Open");
    private final JScreenMenuItem rawMenuItem = new JScreenMenuItem("sequence-only file...");
    private final JScreenMenuItem fastaMenuItem = new JScreenMenuItem("FASTA file...");
    private final JScreenMenuItem gcgMenuItem = new JScreenMenuItem("GCG file...");
    private final JScreenMenuItem pirMenuItem = new JScreenMenuItem("PIR file...");
    private final JScreenMenuItem dnastarMenuItem = new JScreenMenuItem("DNA Star file...");
    private final JScreenMenuItem striderMenuItem = new JScreenMenuItem("DNA Strider file...");
    private final JScreenMenuItem dnasisMenuItem = new JScreenMenuItem("DNASIS file...");
    private final JScreenMenuItem macvectorMenuItem = new JScreenMenuItem("MacVector file...");
    private final JScreenMenuItem saveMenuItem = new JScreenMenuItem("Save");
    private final JScreenMenu saveAsMenu = new JScreenMenu("Save As");
    private final JScreenMenuItem asRawMenuItem = new JScreenMenuItem("sequence-only file...");
    private final JScreenMenuItem asFastaMenuItem = new JScreenMenuItem("FASTA file...");
    private final JScreenMenuItem asGCGMenuItem = new JScreenMenuItem("GCG file...");
    private final JScreenMenuItem asPIRMenuItem = new JScreenMenuItem("PIR file...");
    private final JScreenMenuItem asDnastarMenuItem = new JScreenMenuItem("DNA Star file...");
    private final JScreenMenuItem asStriderMenuItem = new JScreenMenuItem("DNA Strider file...");
    private final JScreenMenuItem asDNasisMenuItem = new JScreenMenuItem("DNASIS file...");
    private final JScreenMenuItem asMacVectorMenuItem = new JScreenMenuItem("MacVector file...");
    private final JScreenMenuItem asGenBANKMenuItem = new JScreenMenuItem("GenBANK file...");
    private final JScreenMenuItem asEMBLMenuItem = new JScreenMenuItem("EMBL/IBI file...");
    private final JScreenMenuItem asCODATAMenuItem = new JScreenMenuItem("CODATA file...");
    private final JScreenMenuItem revertToFileMenuItem = new JScreenMenuItem("Revert");
    private final JScreenMenuItem printMenuItem = new JScreenMenuItem("Print");
    private final JScreenMenuItem savePanelMenuItem = new JScreenMenuItem("Save Panel");
    private final JScreenMenu editMenu = new JScreenMenu("Edit");
    private final JScreenMenu modifyMenu = new JScreenMenu("Modify");
    private final JScreenMenuItem editSequenceMenuItem = new JScreenMenuItem("Change UID/Title");
    private final JScreenMenuItem toDNAMenuItem = new JScreenMenuItem("RNA to DNA");
    private final JScreenMenuItem toRNAMenuItem = new JScreenMenuItem("DNA to RNA");
    private final JScreenMenuItem ucMenuItem = new JScreenMenuItem("To uppercase");
    private final JScreenMenuItem lcMenuItem = new JScreenMenuItem("To lowercase");
    private final JScreenMenuItem xlateMenuItem = new JScreenMenuItem("Translate to Protein");
    private final JScreenMenuItem rcMenuItem = new JScreenMenuItem("Reverse complement");
    private final JScreenMenuItem shuffleMenuItem = new JScreenMenuItem("Shuffle");
    private final JScreenMenuItem revertMenuItem = new JScreenMenuItem("Revert to Original");
    private final JScreenMenuItem prefsMenuItem = new JScreenMenuItem("Preferences");
    private final JScreenMenu sequencesMenu = new JScreenMenu("Sequence");
    private final JScreenMenuItem removeSequenceMenuItem = new JScreenMenuItem("Remove this sequence");
    private final JScreenMenuItem removeDerivedMenuItem = new JScreenMenuItem("Remove derived sequences");
    private final JScreenMenuItem removeAllMenuItem = new JScreenMenuItem("Remove all sequences");
    private final ButtonGroup sequencesButtonGroup = new ButtonGroup();
    private final JScreenMenu windowMenu = new JScreenMenu("Window");
    private final JScreenMenuItem minimizeMenuItem = new JScreenMenuItem("Minimize");
    private final JScreenMenuItem closeMenuItem = new JScreenMenuItem("Close ");
    private final JScreenMenuItem newWindowMenuItem = new JScreenMenuItem("New Window");
    private ActionListener sequenceMenuListener;
    private SequenceInfoDialog infoDialog = null;
    private LengthDialog lengthDialog = null;
    private SampledDialog sampledDialog = null;
    private JMenuItem selectedMenuItem = null;
    private SAObject currentSAObject = null;
    private final JLabel descriptionLbl = new JLabel(" ");
    private final JLabel titleLbl = new JLabel(" ");
    private final Editor editor = new Editor();
    private final JSplitPane splitPane = new JSplitPane(0);
    private final JButton closeBtn = new JButton("Quit");
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private ORFAnalysisPanel orfAnalysisPanel;
    private FeaturesPanel featuresPanel;
    private StructurePanel structurePanel;
    private PatternPanel patternPanel;
    private FormatPanel formatPanel;
    private PublishPanel publishPanel;
    private PairwisePanel pairwisePanel;
    private CompositionPanel compositionPanel;
    private IsoElectricPointPanel isoElectricPointPanel;
    private PrimerDesignPanel primer3Panel;
    private DigestPanel digestPanel;
    PropertyChangeListener currentListener = null;
    AnalysisPanel currentAnalysisPanel = null;
    private int nextTabPosition = 0;

    SAFrame(SequenceAnalysis sequenceAnalysis) {
        super("Sequence Analysis");
        this.application = sequenceAnalysis;
        this.buildUI();
        this.wireUI();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editorTextChanged")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (this.currentSAObject == null) {
                if (string2.length() >= 20) {
                    Sequence sequence = new Sequence(string2);
                    sequence.setUID("Untitled-" + untitledSequenceID++);
                    sequence.setTitle("Untitled " + (sequence.isNucleic() ? "nucleic acid" : "protein") + " sequence");
                    int n = this.editor.getPosition();
                    this.addSequence(sequence);
                    this.editor.setPosition(n);
                    return;
                }
                return;
            }
            this.currentSAObject.update(string2);
            Sequence sequence = this.currentSAObject.getSequence();
            if (sequence != null) {
                this.stateMonitor.changeState("finiteProtein", sequence.getLength() > 0 && sequence.isProtein());
                this.stateMonitor.changeState("finiteNucleic", sequence.getLength() > 0 && sequence.isNucleic());
                this.stateMonitor.changeState("finiteSequence", sequence.getLength() > 0);
            }
            if (this.currentAnalysisPanel != null) {
                this.currentAnalysisPanel.sequenceChanged(this.currentSAObject);
            }
        } else if (string.equals("editorSelectionChanged")) {
            if (this.currentAnalysisPanel == null) {
                return;
            }
            int[] nArray = (int[])propertyChangeEvent.getNewValue();
            if (nArray == null) {
                this.currentAnalysisPanel.selectionCancelled();
                return;
            }
            if (nArray[0] == nArray[1]) {
                this.currentAnalysisPanel.selectionCancelled();
                this.currentAnalysisPanel.cursorPositionChanged(nArray[0]);
            } else {
                this.currentAnalysisPanel.selectionChanged(nArray);
            }
        } else if (string.equals("editorCaretPositionChanged")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (this.currentAnalysisPanel != null) {
                this.currentAnalysisPanel.cursorPositionChanged(n);
            }
        } else if (string.equals("editorIsEmpty")) {
            this.currentAnalysisPanel.sequenceUnavailable();
        } else if (string.equals("action.translate")) {
            this.translate();
        }
    }

    public void addSequence(Sequence sequence) {
        this.addSequence(sequence, null);
    }

    public void addSequence(Sequence sequence, String string) {
        this.addSequence(sequence, string, null, false);
    }

    public void addSequence(Sequence sequence, boolean bl) {
        this.addSequence(sequence, null, null, bl);
    }

    public void addSequence(SequenceFile sequenceFile) {
        this.addSequence(sequenceFile.read(), null, sequenceFile, false);
    }

    private void addSequence(Sequence sequence, String string, SequenceFile sequenceFile, boolean bl) {
        if (sequence == null) {
            return;
        }
        String string2 = sequence.getUID();
        if (string2 == null || string2.equals("")) {
            string2 = sequence.getTitle();
        }
        if (string2 == null || string2.equals("")) {
            string2 = sequence.getDescription();
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        jRadioButtonMenuItem.addActionListener(this.sequenceMenuListener);
        SAObject sAObject = new SAObject(sequence);
        sAObject.setFeaturesXML(string);
        jRadioButtonMenuItem.putClientProperty("sequence.file", sequenceFile);
        jRadioButtonMenuItem.putClientProperty("sequence.object", sAObject);
        jRadioButtonMenuItem.putClientProperty("sequence.derived", new Boolean(bl));
        if (bl) {
            this.stateMonitor.changeState("hasDerivedSequences", true);
        }
        if (sequenceFile != null) {
            this.stateMonitor.changeState("saveableBackToFile", true);
            sequenceFile.close();
        }
        this.sequencesMenu.add(jRadioButtonMenuItem);
        this.sequencesButtonGroup.add(jRadioButtonMenuItem);
        this.broadcastSequenceAdded(jRadioButtonMenuItem.getClientProperty("sequence.object"));
        this.stateMonitor.enterState("hasSequences");
        jRadioButtonMenuItem.doClick();
        this.setTitle(SequenceAnalysis.getApplicationName() + ":" + (this.sequencesMenu.getItemCount() - 4));
    }

    private void buildUI() {
        this.assignMenuAccelerators();
        this.buildMenuBar();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.buildNorthPanel(), "North");
        boolean bl = true;
        boolean bl2 = true;
        this.splitPane.setTopComponent(this.editor);
        this.splitPane.setBottomComponent(this.tabbedPane);
        this.splitPane.setOneTouchExpandable(bl2);
        this.splitPane.setContinuousLayout(bl);
        container.add((Component)this.splitPane, "Center");
        if (SequenceAnalysis.loadORF()) {
            this.addNewTab(ORFAnalysisPanel.getAnalysisName(), null);
        }
        if (SequenceAnalysis.loadFeatures()) {
            this.addNewTab(FeaturesPanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "GIV" : null);
        }
        if (SequenceAnalysis.loadPSEM()) {
            this.addNewTab(StructurePanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "Structure" : null);
        }
        if (SequenceAnalysis.loadPattern()) {
            this.addNewTab(PatternPanel.getAnalysisName(), null);
        }
        if (SequenceAnalysis.loadFormat()) {
            this.addNewTab(FormatPanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "Format" : null);
        }
        if (SequenceAnalysis.loadPublish()) {
            this.addNewTab(PublishPanel.getAnalysisName(), null);
        }
        if (SequenceAnalysis.loadPairwise()) {
            this.addNewTab(PairwisePanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "Pairwise" : null);
        }
        if (SequenceAnalysis.loadComposition()) {
            this.addNewTab(CompositionPanel.getAnalysisName(), null);
        }
        if (SequenceAnalysis.loadPI()) {
            this.addNewTab(IsoElectricPointPanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "pI" : null);
        }
        if (SequenceAnalysis.loadPrimer3()) {
            this.addNewTab(PrimerDesignPanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "Primers" : null);
        }
        if (SequenceAnalysis.loadDigest()) {
            this.addNewTab(DigestPanel.getAnalysisName(), SequenceAnalysis.showTabIcons() ? "Digest" : null);
        }
        Thread thread = new Thread(){

            public void run() {
                int n = 0;
                if (SequenceAnalysis.loadORF()) {
                    SAFrame.this.orfAnalysisPanel = new ORFAnalysisPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.orfAnalysisPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadFeatures()) {
                    SAFrame.this.featuresPanel = new FeaturesPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.featuresPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPSEM()) {
                    SAFrame.this.structurePanel = new StructurePanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.structurePanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPattern()) {
                    SAFrame.this.patternPanel = new PatternPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.patternPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadFormat()) {
                    SAFrame.this.formatPanel = new FormatPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.formatPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPublish()) {
                    SAFrame.this.publishPanel = new PublishPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.publishPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPairwise()) {
                    SAFrame.this.pairwisePanel = new PairwisePanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.pairwisePanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadComposition()) {
                    SAFrame.this.compositionPanel = new CompositionPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.compositionPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPI()) {
                    SAFrame.this.isoElectricPointPanel = new IsoElectricPointPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.isoElectricPointPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadPrimer3()) {
                    SAFrame.this.primer3Panel = new PrimerDesignPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.primer3Panel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                if (SequenceAnalysis.loadDigest()) {
                    SAFrame.this.digestPanel = new DigestPanel();
                    SAFrame.this.tabbedPane.setComponentAt(n, SAFrame.this.digestPanel);
                    SAFrame.this.tabbedPane.setEnabledAt(n++, true);
                }
                Enumeration<AbstractButton> enumeration = SAFrame.this.sequencesButtonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
                    SAFrame.this.broadcastSequenceAdded(jMenuItem.getClientProperty("sequence.object"));
                }
                SAFrame.this.activatePanel(SAFrame.this.orfAnalysisPanel);
            }
        };
        thread.setPriority(Thread.currentThread().getPriority() - 1);
        thread.start();
        if (SequenceAnalysis.showQuitBtn()) {
            container.add((Component)this.buildSouthPanel(), "South");
        }
    }

    private void wireUI() {
        this.editor.propertyChange(new PropertyChangeEvent(this, "addPropertyChangeListener", null, this));
        this.editor.setEditable(true);
        this.stateMonitor.associate(this.editSequenceMenuItem, "hasSequences");
        this.stateMonitor.associate(this.removeSequenceMenuItem, "hasSequences");
        this.stateMonitor.associate(this.removeAllMenuItem, "hasSequences");
        this.stateMonitor.associate(this.removeDerivedMenuItem, "hasDerivedSequences");
        this.stateMonitor.associate(this.saveMenuItem, "saveableBackToFile");
        this.stateMonitor.associate(this.saveAsMenu, "hasSequences");
        this.stateMonitor.associate(this.revertToFileMenuItem, "saveableBackToFile");
        this.stateMonitor.associate(this.toDNAMenuItem, "finiteRNA");
        this.stateMonitor.associate(this.toRNAMenuItem, "finiteDNA");
        this.stateMonitor.associate(this.ucMenuItem, "finiteSequence");
        this.stateMonitor.associate(this.lcMenuItem, "finiteSequence");
        this.stateMonitor.associate(this.xlateMenuItem, "finiteNucleic");
        this.stateMonitor.associate(this.rcMenuItem, "finiteNucleic");
        this.stateMonitor.associate(this.shuffleMenuItem, "finiteSequence");
        this.stateMonitor.associate(this.revertMenuItem, "hasSequences");
        this.stateMonitor.associate(this.printMenuItem, "panelCanPrint");
        this.stateMonitor.associate(this.savePanelMenuItem, "panelCanSave");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SAFrame.this.closeWindow();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.closeWindow();
            }
        });
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.createNewSequence();
            }
        });
        this.farfetchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doFarFetch();
            }
        });
        this.randomNucleicMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doRandomMenuItem("nucleic acid", 500, "ACGT", "SA.nucleic.length");
            }
        });
        this.randomProteinMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doRandomMenuItem("protein", 200, "ACDEFGHIKLMNPQRSTVWY", "SA.protein.length");
            }
        });
        this.sampledNucleicMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSampledMenuItem("nucleic acid", 500, "ACGT", "SA.nucleic.length", "SA.nucleic.alphabet");
            }
        });
        this.sampledProteinMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSampledMenuItem("protein", 200, "ACDEFGHIKLMNPQRSTVWY", "SA.protein.length", "SA.protein.alphabet");
            }
        });
        this.rawMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new RAWFile());
            }
        });
        this.dnasisMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new DNASISFile());
            }
        });
        this.fastaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new FASTAFile());
            }
        });
        this.gcgMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new GCGFile());
            }
        });
        this.pirMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new PIRFile());
            }
        });
        this.dnastarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new DNAStarFile());
            }
        });
        this.striderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new DNAStriderFile());
            }
        });
        this.macvectorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doOpenFile(new MacVectorFile());
            }
        });
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SAFrame.this.selectedMenuItem == null) {
                    return;
                }
                Sequence sequence = ((SAObject)SAFrame.this.selectedMenuItem.getClientProperty("sequence.object")).getSequence();
                SequenceFile sequenceFile = (SequenceFile)SAFrame.this.selectedMenuItem.getClientProperty("sequence.file");
                if (sequence != null && sequenceFile != null) {
                    sequenceFile.write(sequence);
                }
            }
        });
        this.asRawMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new RAWFile(), ".seq");
            }
        });
        this.asFastaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new FASTAFile(), ".fasta");
            }
        });
        this.asGCGMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new GCGFile(), ".gcg");
            }
        });
        this.asPIRMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new PIRFile(), ".pir");
            }
        });
        this.asDnastarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new DNAStarFile());
            }
        });
        this.asStriderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new DNAStriderFile());
            }
        });
        this.asDNasisMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new DNASISFile(), ".dnasis");
            }
        });
        this.asMacVectorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new MacVectorFile());
            }
        });
        this.asGenBANKMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new GenBANKFile(), ".genbank");
            }
        });
        this.asEMBLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new EMBLFile(), ".embl");
            }
        });
        this.asCODATAMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doSaveAs(new CODATAFile(), ".codata");
            }
        });
        this.revertToFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SAFrame.this.selectedMenuItem == null) {
                    return;
                }
                SequenceFile sequenceFile = (SequenceFile)SAFrame.this.selectedMenuItem.getClientProperty("sequence.file");
                if (sequenceFile != null) {
                    Sequence sequence = sequenceFile.read();
                    SAObject sAObject = new SAObject(sequence);
                    SAFrame.this.selectedMenuItem.putClientProperty("sequence.file", sequenceFile);
                    SAFrame.this.selectedMenuItem.putClientProperty("sequence.object", sAObject);
                    SAFrame.this.selectedMenuItem.putClientProperty("sequence.derived", new Boolean(false));
                    SAFrame.this.selectedMenuItem.setSelected(true);
                    SAFrame.this.selectSequenceObject(sAObject);
                }
            }
        });
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SAFrame.this.currentAnalysisPanel != null) {
                    SAFrame.this.currentAnalysisPanel.printPanel();
                }
            }
        });
        this.savePanelMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SAFrame.this.currentAnalysisPanel != null) {
                    SAFrame.this.currentAnalysisPanel.savePanel();
                }
            }
        });
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.closeWindow();
            }
        });
        this.newWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.application.createNewWindow();
            }
        });
        this.sequenceMenuListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.selectedMenuItem = (JMenuItem)actionEvent.getSource();
                SAFrame.this.selectSequenceObject((SAObject)SAFrame.this.selectedMenuItem.getClientProperty("sequence.object"));
                boolean bl = SAFrame.this.selectedMenuItem.getClientProperty("sequence.file") != null;
                boolean bl2 = true;
                SAFrame.this.stateMonitor.changeState("saveableBackToFile", bl & bl2);
            }
        };
        this.removeSequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.removeSelectedSequence();
            }
        });
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.removeAllSequences();
            }
        });
        this.removeDerivedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.removeDerivedSequences();
            }
        });
        this.editSequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.editSequenceInfo();
            }
        });
        this.toRNAMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.toRNA();
            }
        });
        this.toDNAMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.toDNA();
            }
        });
        this.rcMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.reverseComplement();
            }
        });
        this.shuffleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.doShuffle();
            }
        });
        this.xlateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.translate();
            }
        });
        this.lcMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.editor.doLowercase();
            }
        });
        this.ucMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.editor.doUppercase();
            }
        });
        this.revertMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.revertToOriginal(SAFrame.this.selectedMenuItem);
            }
        });
        this.prefsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.minimizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAFrame.this.setState(1);
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SAFrame.this.activatePanel(SAFrame.this.tabbedPane.getSelectedComponent());
            }
        });
        this.closeBtn.setToolTipText("Quit the Application");
    }

    private void addNewTab(String string, String string2) {
        ImageIcon imageIcon = null;
        if (string2 != null) {
            imageIcon = new ImageIcon(this.getClass().getResource("/com/informagen/sa/icons/" + string2 + ".gif"));
        }
        if (imageIcon != null) {
            this.tabbedPane.addTab(string, imageIcon, new JPanel());
        } else {
            this.tabbedPane.addTab(string, new JPanel());
        }
        this.tabbedPane.setEnabledAt(this.nextTabPosition++, false);
    }

    void selectSequenceObject(SAObject sAObject) {
        this.currentSAObject = sAObject;
        Sequence sequence = this.currentSAObject.getSequence();
        this.descriptionLbl.setText(sequence.getUID());
        this.titleLbl.setText(sequence.getTitle());
        this.stateMonitor.changeState("finiteProtein", sequence.getLength() > 0 && sequence.isProtein());
        this.stateMonitor.changeState("finiteNucleic", sequence.getLength() > 0 && sequence.isNucleic());
        this.stateMonitor.changeState("finiteRNA", sequence.getLength() > 0 && sequence.isRNA());
        this.stateMonitor.changeState("finiteDNA", sequence.getLength() > 0 && sequence.isDNA());
        this.stateMonitor.changeState("finiteSequence", sequence.getLength() > 0);
        this.editor.setSequence(sequence);
        if (this.currentAnalysisPanel != null) {
            this.currentAnalysisPanel.changeSequence(this.currentSAObject, this.editor.getSelectionRange());
        }
    }

    void activatePanel(Component component) {
        this.currentAnalysisPanel = (AnalysisPanel)component;
        if (this.currentListener != null) {
            this.currentListener.propertyChange(new PropertyChangeEvent(this, "removePropertyChangeListener", null, this));
            this.currentListener.propertyChange(new PropertyChangeEvent(this, "removePropertyChangeListener", null, this.editor));
        }
        this.currentListener = (PropertyChangeListener)((Object)component);
        this.currentListener.propertyChange(new PropertyChangeEvent(this, "addPropertyChangeListener", null, this));
        this.currentListener.propertyChange(new PropertyChangeEvent(this, "addPropertyChangeListener", null, this.editor));
        if (this.currentSAObject != null) {
            this.currentAnalysisPanel.changeSequence(this.currentSAObject, this.editor.getSelectionRange());
        } else {
            this.currentAnalysisPanel.sequenceUnavailable();
        }
        this.stateMonitor.changeState("panelCanPrint", false);
        this.stateMonitor.changeState("panelCanSave", false);
        if (this.currentListener instanceof FormatPanel) {
            this.stateMonitor.changeState("panelCanSave", true);
            this.stateMonitor.changeState("panelCanPrint", true);
        } else if (this.currentListener instanceof FeaturesPanel) {
            this.stateMonitor.changeState("panelCanSave", false);
            this.stateMonitor.changeState("panelCanPrint", false);
        } else if (this.currentListener instanceof PatternPanel) {
            this.stateMonitor.changeState("panelCanSave", true);
            this.stateMonitor.changeState("panelCanPrint", true);
        } else if (this.currentListener instanceof PublishPanel) {
            this.stateMonitor.changeState("panelCanSave", true);
            this.stateMonitor.changeState("panelCanPrint", true);
        } else if (this.currentListener instanceof CompositionPanel) {
            this.stateMonitor.changeState("panelCanPrint", true);
            this.stateMonitor.changeState("panelCanSave", true);
        } else if (this.currentListener instanceof DigestPanel) {
            this.stateMonitor.changeState("panelCanSave", true);
            this.stateMonitor.changeState("panelCanPrint", true);
        } else if (this.currentListener instanceof PrimerDesignPanel) {
            this.stateMonitor.changeState("panelCanPrint", true);
            this.stateMonitor.changeState("panelCanSave", true);
        } else if (this.currentListener instanceof PairwisePanel) {
            this.stateMonitor.changeState("panelCanPrint", true);
            this.stateMonitor.changeState("panelCanSave", true);
        } else if (this.currentListener instanceof IsoElectricPointPanel) {
            this.stateMonitor.changeState("panelCanPrint", true);
            this.stateMonitor.changeState("panelCanSave", true);
        } else if (this.currentListener instanceof ORFAnalysisPanel) {
            this.stateMonitor.changeState("panelCanPrint", true);
            this.stateMonitor.changeState("panelCanSave", true);
        }
    }

    private void closeWindow() {
        this.application.closeWindow(this);
    }

    private JPanel buildNorthPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 17, 0);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagLayout.setConstraints(this.descriptionLbl, gridBagConstraints);
        jPanel.add(this.descriptionLbl);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 1.0, 0.0, 17, 0);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagLayout.setConstraints(this.titleLbl, gridBagConstraints);
        jPanel.add(this.titleLbl);
        return jPanel;
    }

    private JPanel buildSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 13, 0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 20);
        jPanel.add((Component)this.closeBtn, gridBagConstraints);
        return jPanel;
    }

    private void assignMenuAccelerators() {
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 4));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 4));
        this.savePanelMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 5));
        this.minimizeMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 4));
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 4));
        this.newWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 5));
    }

    private void buildMenuBar() {
        if (!MRJAdapter.isSwingUsingScreenMenuBar()) {
            JScreenMenuItem jScreenMenuItem;
            JScreenMenu jScreenMenu = new JScreenMenu("Application");
            if (!MRJAdapter.isAboutAutomaticallyPresent()) {
                jScreenMenuItem = new JScreenMenuItem("About " + SequenceAnalysis.getApplicationName());
                jScreenMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SAFrame.this.application.doAboutBox();
                    }
                });
                jScreenMenu.add(jScreenMenuItem);
            }
            if (!MRJAdapter.isPreferencesAutomaticallyPresent()) {
                jScreenMenuItem = new JScreenMenuItem("Preferences...");
                jScreenMenuItem.setEnabled(false);
                jScreenMenu.add(jScreenMenuItem);
            }
            if (!MRJAdapter.isQuitAutomaticallyPresent()) {
                jScreenMenuItem = new JScreenMenuItem("Quit");
                jScreenMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SAFrame.this.application.doQuit();
                    }
                });
                jScreenMenu.add(jScreenMenuItem);
            }
            this.menubar.add(jScreenMenu);
        }
        this.fileMenu.add(this.newMenuItem);
        this.fileMenu.add(this.farfetchMenuItem);
        this.fileMenu.add(this.randomMenu);
        this.randomMenu.add(this.randomNucleicMenuItem);
        this.randomMenu.add(this.randomProteinMenuItem);
        this.fileMenu.add(this.sampledMenu);
        this.sampledMenu.add(this.sampledNucleicMenuItem);
        this.sampledMenu.add(this.sampledProteinMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openMenu);
        this.openMenu.add(this.rawMenuItem);
        this.openMenu.add(this.fastaMenuItem);
        this.openMenu.add(this.gcgMenuItem);
        this.openMenu.add(this.pirMenuItem);
        this.openMenu.add(this.dnastarMenuItem);
        this.openMenu.add(this.striderMenuItem);
        this.openMenu.add(this.dnasisMenuItem);
        this.openMenu.add(this.macvectorMenuItem);
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.saveAsMenu);
        this.saveAsMenu.add(this.asRawMenuItem);
        this.saveAsMenu.add(this.asFastaMenuItem);
        this.saveAsMenu.add(this.asGCGMenuItem);
        this.saveAsMenu.add(this.asPIRMenuItem);
        this.saveAsMenu.add(this.asDnastarMenuItem);
        this.saveAsMenu.add(this.asStriderMenuItem);
        this.saveAsMenu.add(this.asDNasisMenuItem);
        this.saveAsMenu.add(this.asMacVectorMenuItem);
        this.saveAsMenu.addSeparator();
        this.saveAsMenu.add(this.asGenBANKMenuItem);
        this.saveAsMenu.add(this.asEMBLMenuItem);
        this.saveAsMenu.add(this.asCODATAMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.revertToFileMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.printMenuItem);
        this.fileMenu.add(this.savePanelMenuItem);
        this.menubar.add(this.fileMenu);
        this.menubar.add(this.editMenu);
        this.modifyMenu.add(this.editSequenceMenuItem);
        this.modifyMenu.addSeparator();
        this.modifyMenu.add(this.toDNAMenuItem);
        this.modifyMenu.add(this.toRNAMenuItem);
        this.modifyMenu.add(this.rcMenuItem);
        this.modifyMenu.add(this.ucMenuItem);
        this.modifyMenu.add(this.lcMenuItem);
        this.modifyMenu.add(this.xlateMenuItem);
        this.modifyMenu.add(this.shuffleMenuItem);
        this.modifyMenu.addSeparator();
        this.modifyMenu.add(this.revertMenuItem);
        this.menubar.add(this.modifyMenu);
        this.sequencesMenu.add(this.removeSequenceMenuItem);
        this.sequencesMenu.add(this.removeDerivedMenuItem);
        this.sequencesMenu.add(this.removeAllMenuItem);
        this.sequencesMenu.addSeparator();
        this.menubar.add(this.sequencesMenu);
        this.windowMenu.add(this.minimizeMenuItem);
        this.windowMenu.add(this.closeMenuItem);
        this.windowMenu.add(this.newWindowMenuItem);
        this.menubar.add(this.windowMenu);
        this.setJMenuBar(this.menubar);
    }

    private void doFarFetch() {
        JSheet.showInputSheet(this, "NCBI GID or Accession number:", new SheetListener(){

            public void optionSelected(SheetEvent sheetEvent) {
                String string;
                int n = (Integer)sheetEvent.getValue();
                if (n == 0 && (string = (String)sheetEvent.getInputValue()) != null) {
                    SAFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    Sequence sequence = FarFetch.fetchViaGID(string);
                    if (sequence == null) {
                        SAFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    String string2 = FarFetch.fetchGBXViaGID(string);
                    String string3 = "Default-GBX.xsl";
                    string3 = sequence.isProtein() ? "Protein-GBX.xsl" : "Nucleotide-GBX.xsl";
                    string2 = FeaturesPanel.transformGBX(string2, SAFrame.this.fetchXSL(string3));
                    SAFrame.this.addSequence(sequence, string2);
                    SAFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public String fetchXSL(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream("/com/informagen/sa/giv/" + string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = inputStreamReader.read()) != -1) {
                stringWriter.write(n);
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private void doRandomMenuItem(final String string, int n, final String string2, final String string3) {
        if (this.lengthDialog == null) {
            this.lengthDialog = new LengthDialog(this);
            this.lengthDialog.addSheetListener(new SheetListener(){

                public void optionSelected(SheetEvent sheetEvent) {
                    if (SAFrame.this.lengthDialog.isOK()) {
                        SAFrame.this.doCreateSampledSequence("Sampled " + sampledSequenceID++, "Uniformly distributed " + string + " sequence", string2, SAFrame.this.lengthDialog.getLength());
                        SAFrame.this.preferences.putInt(string3, SAFrame.this.lengthDialog.getLength());
                    }
                    SAFrame.this.lengthDialog.dispose();
                    SAFrame.this.lengthDialog = null;
                }
            });
        }
        this.lengthDialog.setLength(this.preferences.getInt(string3, n));
        this.lengthDialog.interact();
    }

    private void doSampledMenuItem(final String string, int n, String string2, final String string3, final String string4) {
        if (this.sampledDialog == null) {
            this.sampledDialog = new SampledDialog((Frame)this, string2);
            this.sampledDialog.addSheetListener(new SheetListener(){

                public void optionSelected(SheetEvent sheetEvent) {
                    if (SAFrame.this.sampledDialog.isOK()) {
                        SAFrame.this.doCreateSampledSequence("Sampled " + sampledSequenceID++, "Sampled " + string + " acid sequence", SAFrame.this.sampledDialog.getAlphabet(), SAFrame.this.sampledDialog.getLength());
                        SAFrame.this.preferences.put(string4, SAFrame.this.sampledDialog.getAlphabet());
                        SAFrame.this.preferences.putInt(string3, SAFrame.this.sampledDialog.getLength());
                    }
                    SAFrame.this.sampledDialog.dispose();
                    SAFrame.this.sampledDialog = null;
                }
            });
        }
        this.sampledDialog.setAlphabet(this.preferences.get(string4, string2));
        this.sampledDialog.setLength(this.preferences.getInt(string3, n));
        this.sampledDialog.interact();
    }

    private void createNewSequence() {
        String string = "UID-" + untitledSequenceID++;
        String string2 = "";
        if (this.infoDialog == null) {
            this.infoDialog = new SequenceInfoDialog(this);
            this.infoDialog.addSheetListener(new SheetListener(){

                public void optionSelected(SheetEvent sheetEvent) {
                    if (SAFrame.this.infoDialog.isOK()) {
                        Sequence sequence = new Sequence();
                        sequence.setUID(SAFrame.this.infoDialog.getUID());
                        sequence.setTitle(SAFrame.this.infoDialog.getSequenceTitle());
                        sequence.setType(SAFrame.this.infoDialog.getSequenceType());
                        SAFrame.this.addSequence(sequence);
                    }
                    SAFrame.this.infoDialog.dispose();
                    SAFrame.this.infoDialog = null;
                }
            });
        }
        this.infoDialog.setUID(string);
        this.infoDialog.setSequenceTitle(string2);
        this.infoDialog.setTitle("Create a new sequence");
        this.infoDialog.setSequenceType(2);
        this.infoDialog.setTypeEnabled(true);
        this.infoDialog.interact();
    }

    private void doOpenFile(final SequenceFile sequenceFile) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(sequenceFile.getFileFilter());
        try {
            String string = this.preferences.get("SA.defaultDirectory", SpecialFolder.getDesktopFolder().getCanonicalPath());
            jFileChooser.setCurrentDirectory(new File(string));
        }
        catch (IOException iOException) {
            jFileChooser.setCurrentDirectory(null);
        }
        JSheet.showOpenSheet(jFileChooser, this, new SheetListener(){

            public void optionSelected(SheetEvent sheetEvent) {
                File file;
                if (sheetEvent.getOption() == 0 && (file = sheetEvent.getFileChooser().getSelectedFile()) != null) {
                    SAFrame.this.preferences.put("SA.defaultDirectory", file.getParentFile().getAbsolutePath());
                    sequenceFile.setFile(file);
                    SAFrame.this.addSequence(sequenceFile);
                }
            }
        });
    }

    void openDocument(File file) {
        String string = null;
        try {
            string = MRJAdapter.getFileType(file);
        }
        catch (IOException iOException) {
            return;
        }
        if (string == null) {
            return;
        }
        SequenceFile sequenceFile = null;
        if (string.equals("NUCL") || string.equals("PROT")) {
            sequenceFile = new MacVectorFile(file);
        } else if (string.equals("SEQA") || string.equals("SEQU")) {
            sequenceFile = new DNAStarFile(file);
        } else if (string.equals("xDNA") || string.equals("xRNA") || string.equals("xPRT")) {
            sequenceFile = new DNAStriderFile(file);
        }
        if (sequenceFile != null) {
            this.addSequence(sequenceFile);
        }
    }

    private void doSaveAs(SequenceFile sequenceFile) {
        if (this.currentSAObject == null) {
            return;
        }
        this.doSaveAs(sequenceFile, this.currentSAObject.getSequence().isNucleic() ? ".seq" : ".pro");
    }

    private void doSaveAs(final SequenceFile sequenceFile, String string) {
        if (this.currentSAObject == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = this.currentSAObject.getSequence().getUID();
        string2 = string2 != null ? string2 : "UNTITLED";
        string2 = StringUtils.substringBefore(string2, "(");
        string2 = string2.trim();
        string2 = string2.replace(' ', '_');
        String string3 = string2 + string;
        try {
            String string4 = this.preferences.get("SA.defaultDirectory", SpecialFolder.getDesktopFolder().getCanonicalPath());
            jFileChooser.setSelectedFile(new File(string4, string3));
        }
        catch (IOException iOException) {
            jFileChooser.setCurrentDirectory(null);
        }
        JSheet.showSaveSheet(jFileChooser, this, new SheetListener(){

            public void optionSelected(SheetEvent sheetEvent) {
                File file;
                if (sheetEvent.getOption() == 0 && (file = sheetEvent.getFileChooser().getSelectedFile()) != null) {
                    SAFrame.this.preferences.put("SA.defaultDirectory", file.getParentFile().getAbsolutePath());
                    sequenceFile.setFile(file);
                    sequenceFile.write(SAFrame.this.currentSAObject.getSequence());
                }
            }
        });
    }

    private void removeDerivedSequences() {
        Enumeration<AbstractButton> enumeration = this.sequencesButtonGroup.getElements();
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        while (enumeration.hasMoreElements()) {
            JRadioButtonMenuItem jRadioButtonMenuItem2 = (JRadioButtonMenuItem)enumeration.nextElement();
            boolean bl = (Boolean)jRadioButtonMenuItem2.getClientProperty("sequence.derived");
            if (bl) {
                this.sequencesMenu.remove(jRadioButtonMenuItem2);
                this.sequencesButtonGroup.remove(jRadioButtonMenuItem2);
                if (this.selectedMenuItem == jRadioButtonMenuItem2) {
                    this.selectedMenuItem = null;
                }
                jRadioButtonMenuItem2.removeActionListener(this.sequenceMenuListener);
                if (jRadioButtonMenuItem != null) {
                    jRadioButtonMenuItem.doClick();
                }
                this.broadcastSequenceRemoval(jRadioButtonMenuItem2.getClientProperty("sequence.object"));
                enumeration = this.sequencesButtonGroup.getElements();
                continue;
            }
            jRadioButtonMenuItem = jRadioButtonMenuItem2;
        }
        int n = this.sequencesButtonGroup.getButtonCount();
        this.setTitle(SequenceAnalysis.getApplicationName() + ":" + n);
        this.stateMonitor.changeState("hasSequences", n > 0);
        this.stateMonitor.changeState("hasDerivedSequences", false);
    }

    private void removeSelectedSequence() {
        JMenuItem jMenuItem;
        Enumeration<AbstractButton> enumeration = this.sequencesButtonGroup.getElements();
        JMenuItem jMenuItem2 = null;
        while (enumeration.hasMoreElements()) {
            jMenuItem = (JMenuItem)enumeration.nextElement();
            if (jMenuItem.isSelected()) {
                this.sequencesButtonGroup.remove(jMenuItem);
                this.sequencesMenu.remove(jMenuItem);
                this.broadcastSequenceRemoval(jMenuItem.getClientProperty("sequence.object"));
                if (this.selectedMenuItem == jMenuItem) {
                    this.selectedMenuItem = null;
                }
                jMenuItem.removeActionListener(this.sequenceMenuListener);
                if (jMenuItem2 == null) break;
                jMenuItem2.doClick();
                break;
            }
            jMenuItem2 = jMenuItem;
        }
        this.stateMonitor.changeState("hasDerivedSequences", false);
        enumeration = this.sequencesButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            jMenuItem = (JRadioButtonMenuItem)enumeration.nextElement();
            boolean bl = (Boolean)jMenuItem.getClientProperty("sequence.derived");
            if (!bl) continue;
            this.stateMonitor.changeState("hasDerivedSequences", true);
        }
        int n = this.sequencesButtonGroup.getButtonCount();
        if (n == 0) {
            this.editor.setSequence(null);
            this.descriptionLbl.setText(" ");
            this.titleLbl.setText(" ");
            this.stateMonitor.exitState("hasSequences");
        } else {
            this.stateMonitor.changeState("hasSequences", n > 0);
        }
        this.setTitle(SequenceAnalysis.getApplicationName() + ":" + n);
    }

    private void broadcastSequenceAdded(Object object) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "sequenceAdded", null, object);
        if (this.pairwisePanel != null) {
            this.pairwisePanel.propertyChange(propertyChangeEvent);
        }
    }

    private void broadcastSequenceRemoval(Object object) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "sequenceRemoved", null, object);
        if (this.pairwisePanel != null) {
            this.pairwisePanel.propertyChange(propertyChangeEvent);
        }
    }

    private void removeAllSequences() {
        this.sequencesMenu.removeAll();
        Enumeration<AbstractButton> enumeration = this.sequencesButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            jMenuItem.removeActionListener(this.sequenceMenuListener);
            this.sequencesButtonGroup.remove(jMenuItem);
            this.sequencesMenu.remove(jMenuItem);
            this.broadcastSequenceRemoval(jMenuItem.getClientProperty("sequence.object"));
        }
        this.sequencesMenu.add(this.removeSequenceMenuItem);
        this.sequencesMenu.add(this.removeDerivedMenuItem);
        this.sequencesMenu.add(this.removeAllMenuItem);
        this.sequencesMenu.addSeparator();
        this.editor.setSequence(null);
        this.descriptionLbl.setText(" ");
        this.titleLbl.setText(" ");
        this.currentSAObject = null;
        this.selectedMenuItem = null;
        this.setTitle(SequenceAnalysis.getApplicationName() + ":0");
        this.stateMonitor.exitState("hasSequences");
        this.stateMonitor.changeState("hasDerivedSequences", false);
    }

    private void editSequenceInfo() {
        if (this.selectedMenuItem == null) {
            return;
        }
        final SAObject sAObject = (SAObject)this.selectedMenuItem.getClientProperty("sequence.object");
        final Sequence sequence = sAObject.getEditableSequence();
        if (this.infoDialog == null) {
            this.infoDialog = new SequenceInfoDialog(this);
            this.infoDialog.addSheetListener(new SheetListener(){

                public void optionSelected(SheetEvent sheetEvent) {
                    if (SAFrame.this.infoDialog.isOK()) {
                        sequence.setUID(SAFrame.this.infoDialog.getUID());
                        sequence.setTitle(SAFrame.this.infoDialog.getSequenceTitle());
                        SAFrame.this.selectedMenuItem.setText(SAFrame.this.infoDialog.getUID());
                        SAFrame.this.selectSequenceObject(sAObject);
                    }
                    SAFrame.this.infoDialog.dispose();
                    SAFrame.this.infoDialog = null;
                }
            });
        }
        this.infoDialog.setUID(sequence.getUID());
        this.infoDialog.setSequenceTitle(sequence.getTitle());
        this.infoDialog.setTitle("Edit sequence UID/Title");
        this.infoDialog.setSequenceType(sequence.getType());
        this.infoDialog.setTypeEnabled(false);
        this.infoDialog.interact();
    }

    private void reverseComplement() {
        if (this.selectedMenuItem == null) {
            return;
        }
        Sequence sequence = ((SAObject)this.selectedMenuItem.getClientProperty("sequence.object")).getSequence();
        if (sequence == null || sequence.isProtein()) {
            return;
        }
        String string = this.editor.hasSelection() ? this.editor.getSelection() : this.editor.getText();
        Sequence sequence2 = new Sequence(string);
        sequence2.revComp();
        StringBuffer stringBuffer = new StringBuffer(this.selectedMenuItem.getText());
        stringBuffer.append(" (");
        if (this.editor.hasSelection()) {
            int[] nArray = this.editor.getSelectionRange();
            stringBuffer.append(nArray[0] + 1).append("-").append(nArray[1] + 1);
        } else {
            stringBuffer.append("RevComp");
        }
        stringBuffer.append(", ");
        stringBuffer.append(sequence2.getLength());
        stringBuffer.append(" na)");
        sequence2.setUID(stringBuffer.toString());
        sequence2.setTitle("Reverse Complement from " + this.selectedMenuItem.getText());
        this.addSequence(sequence2, true);
    }

    private void doShuffle() {
        if (this.selectedMenuItem == null) {
            return;
        }
        Sequence sequence = ((SAObject)this.selectedMenuItem.getClientProperty("sequence.object")).getSequence();
        if (sequence == null) {
            return;
        }
        String string = this.editor.hasSelection() ? this.editor.getSelection() : this.editor.getText();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (string.length() > 0) {
            n2 = string.length();
            n = (int)(Math.random() * (double)n2);
            if ((n = Math.round(n)) > n2 - 1) {
                n = 0;
            }
            char c = string.charAt(n);
            stringBuffer.append(c);
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1, string.length());
            string = string2 + string3;
        }
        Sequence sequence2 = new Sequence(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer(this.selectedMenuItem.getText());
        stringBuffer2.append(" (");
        if (this.editor.hasSelection()) {
            int[] nArray = this.editor.getSelectionRange();
            stringBuffer2.append(nArray[0] + 1).append("-").append(nArray[1] + 1);
        } else {
            stringBuffer2.append("Shuffle");
        }
        stringBuffer2.append(", ");
        stringBuffer2.append(sequence2.getLength()).append(" ");
        stringBuffer2.append(sequence.isProtein() ? "aa" : "na");
        stringBuffer2.append(")");
        sequence2.setUID(stringBuffer2.toString());
        sequence2.setTitle("Shuffle from " + this.selectedMenuItem.getText());
        this.addSequence(sequence2, true);
    }

    private void doCreateSampledSequence(String string, String string2, String string3, int n) {
        String string4 = RandomStringUtils.random(n, string3);
        Sequence sequence = new Sequence();
        sequence.setSequence(string4, string3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(sequence.getLength()).append(" ");
        stringBuffer.append(sequence.isProtein() ? "aa" : "na");
        stringBuffer.append(")");
        sequence.setUID(stringBuffer.toString());
        sequence.setTitle(string2 + " using " + string3);
        this.addSequence(sequence, true);
    }

    private void translate() {
        if (this.selectedMenuItem == null) {
            return;
        }
        Sequence sequence = ((SAObject)this.selectedMenuItem.getClientProperty("sequence.object")).getSequence();
        if (sequence == null || sequence.isProtein()) {
            return;
        }
        String string = this.editor.hasSelection() ? this.editor.getSelection() : this.editor.getText();
        Sequence sequence2 = new Sequence(string);
        sequence2.nucToProtein();
        StringBuffer stringBuffer = new StringBuffer(this.selectedMenuItem.getText());
        stringBuffer.append(" (");
        if (this.editor.hasSelection()) {
            int[] nArray = this.editor.getSelectionRange();
            stringBuffer.append(nArray[0] + 1).append("-").append(nArray[1] + 1);
        } else {
            stringBuffer.append("Xlated");
        }
        stringBuffer.append(", ");
        stringBuffer.append(sequence2.getLength());
        stringBuffer.append(" aa)");
        sequence2.setUID(stringBuffer.toString());
        sequence2.setTitle("Translated ORF from " + this.selectedMenuItem.getText());
        this.addSequence(sequence2, true);
    }

    private void toDNA() {
        if (this.currentSAObject == null) {
            return;
        }
        if (this.currentSAObject.getSequence().isProtein()) {
            return;
        }
        this.currentSAObject.update(this.editor.getText());
        this.currentSAObject.getSequence().RNAtoDNA();
        this.selectSequenceObject(this.currentSAObject);
    }

    private void toRNA() {
        if (this.currentSAObject == null) {
            return;
        }
        if (this.currentSAObject.getSequence().isProtein()) {
            return;
        }
        this.currentSAObject.update(this.editor.getText());
        this.currentSAObject.getSequence().DNAtoRNA();
        this.selectSequenceObject(this.currentSAObject);
    }

    private void revertToOriginal(JMenuItem jMenuItem) {
        if (jMenuItem == null) {
            return;
        }
        SAObject sAObject = (SAObject)jMenuItem.getClientProperty("sequence.object");
        sAObject.revert();
        this.selectSequenceObject(sAObject);
    }
}

