/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.format;

import com.informagen.F;
import com.informagen.sa.format.SequenceFormatter;

public class CODATA
extends SequenceFormatter {
    public CODATA() {
        this.mLineSize = 30;
        this.mBlockSize = 1;
    }

    public StringBuffer allocate() {
        int n = this.mSequence.length();
        return new StringBuffer(n * 2 + 10 * (n / 30) + 120);
    }

    protected void formatHeader() {
        this.mFormatted.append("ENTRY    ");
        this.mFormatted.append(this.mCodeword != null ? this.mCodeword : "UNTITLED");
        this.mFormatted.append("   #Type ");
        this.mFormatted.append(this.mIsProtein ? "Protein\n" : "dna linear\n");
        if (this.mTitle != null) {
            this.mFormatted.append("TITLE    " + this.mTitle + '\n');
        }
        this.mFormatted.append("DATE     ").append(this.formatTime("dd-MMM-yyyy HH:mm") + '\n');
        this.mFormatted.append("SUMMARY  #Molecular-weight ").append(F.f(this.molwt, 4, 2, (short)1024)).append("   ");
        this.mFormatted.append("#Length ").append(this.mSequence.length());
        this.mFormatted.append("  #Checksum ").append(this.checkSum(this.mSequence)).append('\n');
        this.mFormatted.append("SEQUENCE\n");
    }

    protected void formatSequence() {
        this.mFormatted.append("                5        10        15        20        25        30\n");
        this.mFormatted.append("      1 ");
        char[] cArray = this.mSequence.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            this.mFormatted.append(cArray[i]);
            if (++n < this.mLineSize) {
                this.mFormatted.append(' ');
            }
            if (n != this.mLineSize) continue;
            this.mFormatted.append('\n').append(F.f(i + 2, 7)).append(' ');
            n = 0;
        }
    }

    protected void formatEnding() {
        this.mFormatted.append("\n//\n");
    }
}

