/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.giv;

import com.informagen.Util;
import com.informagen.giv.GIVPanel;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapGlyphListener;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapTileListener;
import com.informagen.giv.MapView;
import com.informagen.giv.XMLFormat;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.ImagePrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class FeaturesPanel
extends AnalysisPanel
implements MapGlyphListener,
MapTileListener {
    final Label reporterLabel = new Label();
    GIVPanel theGIVPanel = null;

    public static String getAnalysisName() {
        return "Features";
    }

    public FeaturesPanel() {
        this.buildUI();
        this.wireUI();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("orfSelectionChanged")) {
            if (this.saObject == null) {
                return;
            }
            this.pcs.firePropertyChange("selectionChanged", null, propertyChangeEvent.getNewValue());
        }
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.createGIV();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.emptyPanel();
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.createGIV();
    }

    public void selectionChanged(int[] nArray) {
    }

    public void selectionCancelled() {
    }

    public void cursorPositionChanged(int n) {
    }

    public void savePanel() {
        int n = this.theGIVPanel.getSize().width;
        int n2 = this.theGIVPanel.getSize().height;
        Image image = this.theGIVPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.theGIVPanel.paintAll(graphics);
        graphics.dispose();
        String string = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveImage(frame, image, string, "GIV");
    }

    public void printPanel() {
        ImagePrinter imagePrinter = new ImagePrinter();
        int n = this.theGIVPanel.getSize().width;
        int n2 = this.theGIVPanel.getSize().height;
        Image image = this.theGIVPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.theGIVPanel.paintAll(graphics);
        graphics.dispose();
        imagePrinter.setImage(image);
        imagePrinter.print();
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.theGIVPanel = new GIVPanel(true, true, true);
        this.add((Component)this.theGIVPanel, "Center");
        this.add((Component)this.reporterLabel, "South");
    }

    void wireUI() {
    }

    public void glyphSelected(MapGlyph mapGlyph) {
        if (mapGlyph == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(mapGlyph.getName()).append(", ");
        int n = (int)mapGlyph.mStart;
        int n2 = (int)mapGlyph.mStop;
        if (n == n2) {
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n + "-" + n2);
            stringBuffer.append(" (" + (n2 - n + 1) + " bp)");
        }
        this.reporterLabel.setText(stringBuffer.toString());
        int[] nArray = new int[]{n - 1, n2};
        this.propertyChange(new PropertyChangeEvent(this, "orfSelectionChanged", null, nArray));
    }

    public void glyphLaunched(MapGlyph mapGlyph) {
    }

    public void tileSelected(MapTile mapTile) {
        if (mapTile == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(mapTile.getName());
        this.reporterLabel.setText(stringBuffer.toString());
    }

    public void tileLaunched(MapTile mapTile) {
    }

    private void createGIV() {
        String string = this.saObject.getFeaturesXML();
        if (string == null) {
            this.emptyPanel();
        }
        MapView mapView = null;
        try {
            StringReader stringReader = new StringReader(string);
            mapView = XMLFormat.create(stringReader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mapView == null) {
            return;
        }
        mapView.addGlyphListener(this);
        mapView.addTileListener(this);
        this.theGIVPanel.installMapView(mapView);
        this.theGIVPanel.initialZoom();
        this.theGIVPanel.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FeaturesPanel.this.revalidate();
            }
        });
    }

    private void emptyPanel() {
        MapView mapView = new MapView();
        this.theGIVPanel.installMapView(mapView);
        this.theGIVPanel.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FeaturesPanel.this.revalidate();
            }
        });
    }

    public static String transformGBX(String string, String string2) {
        StreamSource streamSource = new StreamSource(new StringReader(string));
        StreamSource streamSource2 = new StreamSource(new StringReader(string2));
        StringWriter stringWriter = new StringWriter();
        try {
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource2);
            transformer.transform(streamSource, streamResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

