/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.publish;

import com.informagen.F;
import com.informagen.Sequence;

public class Publish {
    protected char[] mSequence;
    int mBlocksPerLine;
    int mBlockSize;
    char[] mFormat;
    int mTranslateFrom;
    boolean mUseStopCodons;
    int mCursor;
    int mCapacity;
    StringBuffer[] mLines;
    StringBuffer mFormatted;

    public Publish() {
        this(3, 20);
    }

    public Publish(int n, int n2) {
        this.mBlockSize = n;
        this.mBlocksPerLine = n2;
        this.setFormat("s+ra  ");
        this.mTranslateFrom = 1;
        this.mUseStopCodons = true;
    }

    public void setSequence(String string) {
        this.mSequence = string.toCharArray();
    }

    public void setFormat(String string) {
        this.mFormat = string.toCharArray();
    }

    public void setTranslateFrom(int n) {
        this.mTranslateFrom = n;
    }

    public void setUseStopCodons(boolean bl) {
        this.mUseStopCodons = bl;
    }

    public String format() {
        int n;
        if (this.mSequence == null) {
            return null;
        }
        this.allocate();
        block19: for (n = 0; n < this.mFormat.length; ++n) {
            switch (this.mFormat[n]) {
                case '#': {
                    this.numberLine(n);
                    continue block19;
                }
                case '.': {
                    this.dotLine(n);
                    continue block19;
                }
                case 'S': 
                case 's': {
                    this.seqLine(n);
                    continue block19;
                }
                case '+': 
                case '-': {
                    this.dashLine(n);
                    continue block19;
                }
                case 'R': 
                case 'r': {
                    this.compLine(n);
                    continue block19;
                }
                case 'A': 
                case 'a': {
                    this.threeTransLine(n, 0, false);
                    continue block19;
                }
                case 'B': 
                case 'b': {
                    this.threeTransLine(n, 1, false);
                    continue block19;
                }
                case 'C': 
                case 'c': {
                    this.threeTransLine(n, 2, false);
                    continue block19;
                }
                case 'D': 
                case 'd': {
                    this.threeTransLine(n, 2, true);
                    continue block19;
                }
                case 'E': 
                case 'e': {
                    this.threeTransLine(n, 1, true);
                    continue block19;
                }
                case 'F': 
                case 'f': {
                    this.threeTransLine(n, 0, true);
                    continue block19;
                }
                case '1': {
                    this.oneTransLine(n, 0, false);
                    continue block19;
                }
                case '2': {
                    this.oneTransLine(n, 1, false);
                    continue block19;
                }
                case '3': {
                    this.oneTransLine(n, 2, false);
                    continue block19;
                }
                case '4': {
                    this.oneTransLine(n, 2, true);
                    continue block19;
                }
                case '5': {
                    this.oneTransLine(n, 1, true);
                    continue block19;
                }
                case '6': {
                    this.oneTransLine(n, 0, true);
                    continue block19;
                }
                default: {
                    this.blankLine(n);
                }
            }
        }
        n = this.mBlocksPerLine * this.mBlockSize;
        this.mCursor = 0;
        while (this.mCursor < this.mSequence.length) {
            for (int i = 0; i < this.mLines.length; ++i) {
                if (this.mFormat[i] == '#') {
                    this.writeNumberLine(i);
                    continue;
                }
                this.writeLine(i);
            }
            this.mCursor += n;
        }
        return this.mFormatted.toString();
    }

    private void allocate() {
        this.mCapacity = this.mSequence.length;
        this.mLines = new StringBuffer[this.mFormat.length];
        for (int i = 0; i < this.mFormat.length; ++i) {
            this.mLines[i] = new StringBuffer(this.mCapacity);
        }
        this.mFormatted = new StringBuffer(this.mCapacity * this.mFormat.length);
    }

    private void numberLine(int n) {
        this.mLines[n] = null;
    }

    private void dotLine(int n) {
        StringBuffer stringBuffer = this.mLines[n];
        for (int i = 0; i < this.mSequence.length; ++i) {
            stringBuffer.append((i + 1) % 10 == 0 ? (char)'.' : ' ');
        }
    }

    private void seqLine(int n) {
        this.mLines[n].append(this.mSequence);
    }

    private void dashLine(int n) {
        StringBuffer stringBuffer = this.mLines[n];
        for (int i = 0; i < this.mSequence.length; ++i) {
            stringBuffer.append((i + 1) % 10 == 0 ? (char)'+' : '-');
        }
    }

    private void compLine(int n) {
        StringBuffer stringBuffer = this.mLines[n];
        for (int i = 0; i < this.mSequence.length; ++i) {
            stringBuffer.append(Sequence.compBase(this.mSequence[i]));
        }
    }

    private void threeTransLine(int n, int n2, boolean bl) {
        int n3;
        StringBuffer stringBuffer = this.mLines[n];
        for (n3 = 0; n3 + 1 < this.mTranslateFrom && n3 < this.mSequence.length; ++n3) {
            stringBuffer.append(' ');
        }
        if (n2 == 1) {
            stringBuffer.append(' ');
        } else if (n2 == 2) {
            stringBuffer.append("  ");
        }
        while (n3 <= this.mSequence.length - (3 + n2)) {
            String string = new String(this.mSequence, n3 + n2, 3);
            if (bl) {
                string = Sequence.revComp(string);
            }
            char c = Sequence.codonToAA(string);
            stringBuffer.append(Sequence.oneToThree(c));
            if (this.mUseStopCodons && c == '*') break;
            n3 += 3;
        }
        this.padLine(n);
    }

    private void oneTransLine(int n, int n2, boolean bl) {
        int n3;
        StringBuffer stringBuffer = this.mLines[n];
        for (n3 = 0; n3 + 1 < this.mTranslateFrom && n3 < this.mSequence.length; ++n3) {
            stringBuffer.append(" ");
        }
        if (n2 == 1) {
            stringBuffer.append(" ");
        } else if (n2 == 2) {
            stringBuffer.append("  ");
        }
        while (n3 <= this.mSequence.length - (3 + n2)) {
            String string = new String(this.mSequence, n3 + n2, 3);
            if (bl) {
                string = Sequence.revComp(string);
            }
            char c = Sequence.codonToAA(string);
            stringBuffer.append(c).append("  ");
            if (this.mUseStopCodons && c == '*') break;
            n3 += 3;
        }
        this.padLine(n);
    }

    private void centeredTransLine(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = this.mLines[n];
        for (n3 = 0; n3 + 1 < this.mTranslateFrom && n3 < this.mSequence.length; ++n3) {
            stringBuffer.append(" ");
        }
        if (n2 == 1) {
            stringBuffer.append(" ");
        } else if (n2 == 2) {
            stringBuffer.append("  ");
        }
        while (n3 <= this.mSequence.length - (3 + n2)) {
            String string = new String(this.mSequence, n3, 3);
            char c = Sequence.codonToAA(string);
            stringBuffer.append(' ').append(c).append(' ');
            if (this.mUseStopCodons && c == '*') break;
            n3 += 3;
        }
        this.padLine(n);
    }

    private void blankLine(int n) {
        for (int i = 0; i < this.mSequence.length; ++i) {
            this.mLines[n].append(" ");
        }
    }

    private void padLine(int n) {
        int n2 = this.mSequence.length - this.mLines[n].length();
        if (n2 > 0) {
            this.mLines[n].append(F.f((Object)" ", n2));
        }
    }

    private void writeLine(int n) {
        int n2;
        int n3;
        int n4;
        StringBuffer stringBuffer = this.mLines[n];
        int n5 = this.mCursor + 1;
        switch (this.mFormat[n]) {
            case '-': 
            case '.': 
            case 'r': 
            case 's': {
                this.mFormatted.append(F.f(' ', 6));
                break;
            }
            case '+': 
            case 'R': 
            case 'S': {
                this.mFormatted.append(F.f(n5, 6));
            }
        }
        switch (this.mFormat[n]) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                n5 = n5 <= this.mTranslateFrom ? 1 : n5 - this.mTranslateFrom;
                n5 = (int)Math.floor((double)(n5 + 3) / 3.0);
                n4 = 1;
                n3 = Math.min(this.mCursor + this.mBlockSize * this.mBlocksPerLine, stringBuffer.length());
                for (n2 = this.mCursor; n2 < n3 && (n4 &= !Character.isLetter(stringBuffer.charAt(n2)) ? 1 : 0) != 0; ++n2) {
                }
                if (n4 == 0) break;
                return;
            }
        }
        switch (this.mFormat[n]) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                this.mFormatted.append(F.f(n5, 6));
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                this.mFormatted.append(F.f(' ', 6));
            }
        }
        this.mFormatted.append(' ');
        n4 = 0;
        n3 = 0;
        for (n2 = this.mCursor; n2 < this.mSequence.length; ++n2) {
            this.mFormatted.append(stringBuffer.charAt(n2));
            if (++n4 == this.mBlockSize) {
                this.mFormatted.append(' ');
                ++n3;
                n4 = 0;
            }
            if (n3 == this.mBlocksPerLine) break;
        }
        if (n4 != 0) {
            this.mFormatted.append(' ');
        }
        int n6 = n2 + 1;
        if (n2 == this.mSequence.length) {
            --n6;
        }
        switch (this.mFormat[n]) {
            case '+': 
            case 'R': 
            case 'S': {
                this.mFormatted.append(F.f(n6, 6, (short)2));
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                n6 = n6 - this.mTranslateFrom + 1;
                if (this.mUseStopCodons) {
                    int n7 = Math.min(this.mCursor + this.mBlockSize * this.mBlocksPerLine, stringBuffer.length());
                    for (int i = this.mCursor; i < n7; ++i) {
                        if (stringBuffer.charAt(i) != '*') continue;
                        n6 = i + 1 - this.mTranslateFrom + 1 - 3;
                    }
                }
                n6 = (int)Math.ceil((double)n6 / 3.0);
                this.mFormatted.append(F.f(n6, 6, (short)2));
            }
        }
        this.mFormatted.append('\n');
    }

    private void writeNumberLine(int n) {
        int n2;
        this.mFormatted.append(F.f((Object)" ", 6));
        this.mFormatted.append(' ');
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.mBlocksPerLine * this.mBlockSize;
        int n7 = n2 - 1;
        for (n2 = this.mCursor + 1; n2 <= this.mSequence.length; ++n2) {
            if (n2 % 10 == 0) {
                int n8 = n2 - n7 + n5;
                int n9 = F.f(n2).length();
                if (n8 >= n9) {
                    if (n8 > n9) {
                        this.mFormatted.append(F.f(' ', n8 - n9));
                    }
                    this.mFormatted.append(F.f(n2));
                } else {
                    this.mFormatted.append(F.f(' ', n8));
                }
                n5 = 0;
                n7 = n2;
            }
            if (++n3 == this.mBlockSize) {
                ++n5;
                ++n4;
                n3 = 0;
            }
            if (n4 == this.mBlocksPerLine) break;
        }
        this.mFormatted.append('\n');
    }
}

