/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sequence.editor;

import com.informagen.Sequence;
import com.informagen.sequence.editor.Model;
import com.informagen.sequence.editor.StatusBar;
import com.informagen.sequence.editor.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class Editor
extends JPanel
implements PropertyChangeListener {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Font defaultFont = new Font("monospaced", 0, 10);
    private Model model;
    private View view;
    private StatusBar statusBar = new StatusBar();
    private Sequence sequence = null;
    private final String mNucleicAlphabet = "ACGTUNacgtun";
    private final String mProteinAlphabet = "ABCDEFGHIKLMNPQRSTVWXYZabcdefghiklmnpqrstvwxyz";

    public Editor() {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.model = new Model(this, "ABCDEFGHIKLMNPQRSTVWXYZabcdefghiklmnpqrstvwxyz");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JScrollBar jScrollBar = new JScrollBar(1);
        jPanel.add((Component)jScrollBar, "East");
        this.view = new View(jScrollBar, this.model);
        this.view.setFont(this.defaultFont);
        jPanel.add((Component)this.view, "Center");
        this.add((Component)jPanel, "Center");
        this.statusBar.setFont(this.defaultFont);
        this.statusBar.setNucleic();
        this.add((Component)this.statusBar, "North");
        this.validate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getPropertyName().equals("addPropertyChangeListener")) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)propertyChangeEvent.getNewValue();
            if (propertyChangeListener != null) {
                this.pcs.addPropertyChangeListener(propertyChangeListener);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("removePropertyChangeListener")) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)propertyChangeEvent.getNewValue();
            if (propertyChangeListener != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        } else if (string.equals("selectionChanged")) {
            int[] nArray = (int[])propertyChangeEvent.getNewValue();
            if (nArray != null && nArray.length == 2) {
                this.view.select(nArray[0], nArray[1]);
            }
        } else if (string.equals("positionChanged")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.view.select(n, n);
            this.model.setPosition(n);
            this.view.placeCursor();
        }
    }

    void propertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    void modelHasNoObject() {
        this.statusBar.setCaretPosition(0);
        this.statusBar.setLength(0);
        this.propertyChange("editorIsEmpty", null, null);
    }

    void modelPositionChanged(int n) {
        this.statusBar.setCaretPosition(n);
        this.propertyChange("editorCaretPositionChanged", null, new Integer(n));
    }

    void modelSelectionChanged(int n, int n2) {
        int[] nArray = this.model.getSelectionRange();
        this.statusBar.setSelection(nArray[0], nArray[1]);
        if (this.sequence != null) {
            this.propertyChange("editorSelectionChanged", null, nArray);
        }
    }

    void modelTextChanged() {
        this.statusBar.setLength(this.model.getLength());
        String string = this.model.getText();
        this.propertyChange("editorTextChanged", null, string);
    }

    void fireCreateSequenceObject(String string) {
        this.propertyChange("createSequenceObject", null, string);
    }

    void fireTypeChanged(int n) {
    }

    public void doUppercase() {
        this.model.doUppercase();
        this.repaint();
    }

    public void doLowercase() {
        this.model.doLowercase();
        this.repaint();
    }

    public void setFontSize(int n) {
        this.view.setFontSize(n);
    }

    public int getPosition() {
        return this.model.getPosition();
    }

    public void setPosition(int n) {
        this.model.setPosition(n);
    }

    public String getText() {
        return this.model.getText();
    }

    public void setText(String string) {
        this.model.setText(string);
        this.repaint();
    }

    public String getSelection() {
        return this.model.getSelection();
    }

    public int[] getSelectionRange() {
        return this.hasSelection() ? this.model.getSelectionRange() : null;
    }

    public boolean hasSelection() {
        return this.model.hasSelection();
    }

    public void clear() {
        this.view.clear();
        this.model.setAlphabet("ABCDEFGHIKLMNPQRSTVWXYZabcdefghiklmnpqrstvwxyz");
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
        this.setEditable(true);
        this.view.select(0, 0);
        if (sequence == null) {
            this.clear();
            return;
        }
        if (sequence.isProtein()) {
            this.model.setAlphabet("ABCDEFGHIKLMNPQRSTVWXYZabcdefghiklmnpqrstvwxyz");
        } else {
            this.model.setAlphabet("ACGTUNacgtun");
        }
        this.setText(sequence.getSequence());
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setEditable(boolean bl) {
        this.view.setEditable(bl);
    }

    public boolean getEditable() {
        return this.view.getEditable();
    }

    public void repaint() {
        if (this.view != null) {
            this.view.redoCanvas();
        }
    }

    public void select(int n, int n2) {
        this.view.select(n, n2);
    }

    public String copy() {
        return this.view.copy();
    }

    public void cut() {
        this.view.cut();
    }

    public void paste() {
        this.view.paste();
    }

    public void toClipboard(String string) {
        this.view.toClipboard(string);
    }

    public void setAlphabet(String string) {
        this.model.setAlphabet(string);
    }

    boolean isProtein() {
        return this.sequence == null ? false : this.sequence.isProtein();
    }

    boolean isNucleic() {
        return this.sequence == null ? false : this.sequence.isNucleic();
    }
}

