/*
 * Decompiled with CFR 0.152.
 */
package neobio.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import neobio.gui.AboutDialog;
import neobio.gui.PairwiseAlignmentFrame;

public class NeoBio
extends JFrame {
    private JMenu file_menu;
    private JMenu help_menu;
    private JMenuBar menu_bar;
    private JMenuItem new_alignment_item;
    private JMenuItem exit_menuitem;
    private JMenuItem about_menuitem;
    private JSeparator mid_separator;
    private JToolBar file_toolbar;
    private JPanel toolbar_panel;
    private JButton alignment_button;
    private JDesktopPane desktop_pane;

    public NeoBio() {
        this.setTitle("NeoBio");
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.show();
        this.pairwiseAlignment();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NeoBio.this.exitForm();
            }
        });
        Container container = this.getContentPane();
        this.desktop_pane = new JDesktopPane();
        container.add((Component)this.desktop_pane, "Center");
        this.new_alignment_item = new JMenuItem("Pairwise Alignment");
        this.new_alignment_item.setMnemonic('p');
        this.new_alignment_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeoBio.this.newAlignmentActionPerformed(actionEvent);
            }
        });
        URL uRL = this.getClass().getResource("icons/alignment.gif");
        if (uRL != null) {
            this.new_alignment_item.setIcon(new ImageIcon(uRL));
        }
        this.mid_separator = new JSeparator();
        this.exit_menuitem = new JMenuItem("Exit");
        this.exit_menuitem.setMnemonic('x');
        this.exit_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeoBio.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.file_menu = new JMenu("File");
        this.file_menu.setMnemonic('f');
        this.file_menu.add(this.new_alignment_item);
        this.file_menu.add(this.mid_separator);
        this.file_menu.add(this.exit_menuitem);
        this.about_menuitem = new JMenuItem("About");
        this.about_menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeoBio.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        uRL = this.getClass().getResource("icons/help.gif");
        if (uRL != null) {
            this.about_menuitem.setIcon(new ImageIcon(uRL));
        }
        this.help_menu = new JMenu("Help");
        this.help_menu.add(this.about_menuitem);
        this.menu_bar = new JMenuBar();
        this.menu_bar.add(this.file_menu);
        this.menu_bar.add(this.help_menu);
        this.setJMenuBar(this.menu_bar);
        this.alignment_button = new JButton();
        this.alignment_button.setMnemonic('p');
        this.alignment_button.setToolTipText("Pairwise Alignment...");
        this.alignment_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeoBio.this.newAlignmentActionPerformed(actionEvent);
            }
        });
        uRL = this.getClass().getResource("icons/alignment.gif");
        if (uRL != null) {
            this.alignment_button.setIcon(new ImageIcon(uRL));
        }
        this.file_toolbar = new JToolBar();
        this.file_toolbar.setRollover(true);
        this.file_toolbar.add(this.alignment_button);
        this.toolbar_panel = new JPanel();
        this.toolbar_panel.setLayout(new FlowLayout(0, 0, 0));
        this.toolbar_panel.setBorder(new EtchedBorder());
        this.toolbar_panel.add(this.file_toolbar);
        container.add((Component)this.toolbar_panel, "North");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width * 2 / 3, dimension.height * 7 / 8);
        this.setLocation(dimension.width / 6, dimension.height / 16);
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        new AboutDialog(this).show();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.exitForm();
    }

    private void exitForm() {
        System.exit(0);
    }

    private void newAlignmentActionPerformed(ActionEvent actionEvent) {
        this.pairwiseAlignment();
    }

    private void pairwiseAlignment() {
        PairwiseAlignmentFrame pairwiseAlignmentFrame = new PairwiseAlignmentFrame(this);
        this.desktop_pane.add(pairwiseAlignmentFrame);
        pairwiseAlignmentFrame.setBounds(0, 0, 500, 500);
        pairwiseAlignmentFrame.show();
        pairwiseAlignmentFrame.toFront();
        try {
            pairwiseAlignmentFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        new NeoBio();
    }
}

