/*
 * Decompiled with CFR 0.152.
 */
package neobio.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import neobio.alignment.BasicScoringScheme;
import neobio.alignment.CrochemoreLandauZivUkelsonGlobalAlignment;
import neobio.alignment.CrochemoreLandauZivUkelsonLocalAlignment;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidScoringMatrixException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.NeedlemanWunsch;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;
import neobio.alignment.ScoringMatrix;
import neobio.alignment.SmithWaterman;

public class PairwiseAlignmentFrame
extends JInternalFrame {
    private static int window_number = 1;
    private Frame parent_frame;
    private JPanel input_panel;
    private JPanel scoring_panel;
    private JPanel algorithm_panel;
    private JPanel output_panel;
    private JPanel progress_tab_panel;
    private JPanel output_tab_panel;
    private JTextField seq1_field;
    private JTextField seq2_field;
    private JTextField matrix_field;
    private JTextField output_field;
    private JTextField match_field;
    private JTextField mismatch_field;
    private JTextField gap_field;
    private JTextArea progress_area;
    private JTextArea output_area;
    private JButton find_seq1_button;
    private JButton find_seq2_button;
    private JButton find_output_button;
    private JButton find_matrix_button;
    private JButton run_button;
    private JComboBox algorithm_combo;
    private JTabbedPane output_tab;
    private JRadioButton screen_button;
    private JRadioButton file_button;
    private JRadioButton basic_button;
    private JRadioButton matrix_button;
    private ButtonGroup scoring_group;
    private ButtonGroup output_group;
    private JLabel seq1_label;
    private JLabel seq2_label;
    private JLabel match_label;
    private JLabel mismatch_label;
    private JLabel gap_label;
    private JFileChooser find_dialog;
    private boolean output_to_file;
    private boolean basic_scheme;
    private String[] algorithm_name = new String[]{"Needleman & Wunsch (global alignment)", "Smith & Waterman (local alignment)", "Crochemore, Landau & Ziv-Ukelson for global alignment", "Crochemore, Landau & Ziv-Ukelson for local alignment"};
    private PairwiseAlignmentAlgorithm[] algorithm = new PairwiseAlignmentAlgorithm[]{new NeedlemanWunsch(), new SmithWaterman(), new CrochemoreLandauZivUkelsonGlobalAlignment(), new CrochemoreLandauZivUkelsonLocalAlignment()};

    public PairwiseAlignmentFrame(Frame frame) {
        this.parent_frame = frame;
        this.initComponents();
    }

    private void initComponents() {
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setTitle("Pairwise Sequence Alignment " + window_number++);
        this.setMinimumSize(new Dimension(500, 500));
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.input_panel = new JPanel();
        this.add(jComponent, this.input_panel, gridBagConstraints, 0, 0);
        this.scoring_panel = new JPanel();
        this.add(jComponent, this.scoring_panel, gridBagConstraints, 0, 1);
        this.output_panel = new JPanel();
        this.add(jComponent, this.output_panel, gridBagConstraints, 0, 2);
        this.algorithm_panel = new JPanel();
        this.add(jComponent, this.algorithm_panel, gridBagConstraints, 0, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.output_tab = new JTabbedPane();
        this.add(jComponent, this.output_tab, gridBagConstraints, 0, 4);
        this.find_dialog = new JFileChooser();
        this.find_dialog.setDialogTitle("Find...");
        this.find_dialog.setDialogType(0);
        this.input_panel.setLayout(new GridBagLayout());
        this.input_panel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Input"));
        this.seq1_label = new JLabel("Sequence 1:");
        this.seq2_label = new JLabel("Sequence 2:");
        this.seq1_field = new JTextField();
        this.seq1_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.seq2_field = new JTextField();
        this.seq2_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.find_seq1_button = new JButton("Find...");
        this.find_seq1_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwiseAlignmentFrame.this.findSeq1ButtonActionPerformed();
            }
        });
        this.find_seq2_button = new JButton("Find...");
        this.find_seq2_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwiseAlignmentFrame.this.findSeq2ButtonActionPerformed();
            }
        });
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        this.add(this.input_panel, this.seq1_label, gridBagConstraints, 0, 0);
        this.add(this.input_panel, this.seq2_label, gridBagConstraints, 0, 1);
        gridBagConstraints.anchor = 10;
        this.add(this.input_panel, this.find_seq1_button, gridBagConstraints, 2, 0);
        this.add(this.input_panel, this.find_seq2_button, gridBagConstraints, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add(this.input_panel, this.seq1_field, gridBagConstraints, 1, 0);
        this.add(this.input_panel, this.seq2_field, gridBagConstraints, 1, 1);
        this.scoring_panel.setLayout(new GridBagLayout());
        this.scoring_panel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Scoring Scheme"));
        this.basic_scheme = true;
        this.basic_button = new JRadioButton("Basic:");
        this.basic_button.setSelected(true);
        this.basic_button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PairwiseAlignmentFrame.this.schemeOptionStateChanged();
            }
        });
        this.matrix_button = new JRadioButton("Substitution Matrix:");
        this.matrix_button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PairwiseAlignmentFrame.this.schemeOptionStateChanged();
            }
        });
        this.match_label = new JLabel("Match:");
        this.mismatch_label = new JLabel("Mismatch:");
        this.gap_label = new JLabel("Gap:");
        this.match_field = new JTextField("1", 2);
        this.match_field.setHorizontalAlignment(4);
        this.match_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.mismatch_field = new JTextField("-1", 2);
        this.mismatch_field.setHorizontalAlignment(4);
        this.mismatch_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.gap_field = new JTextField("-1", 2);
        this.gap_field.setHorizontalAlignment(4);
        this.gap_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.matrix_field = new JTextField();
        this.matrix_field.setEnabled(false);
        this.matrix_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.find_matrix_button = new JButton("Find...");
        this.find_matrix_button.setEnabled(false);
        this.find_matrix_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwiseAlignmentFrame.this.findMatrixButtonActionPerformed();
            }
        });
        this.scoring_group = new ButtonGroup();
        this.scoring_group.add(this.basic_button);
        this.scoring_group.add(this.matrix_button);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add(this.scoring_panel, this.basic_button, gridBagConstraints, 0, 0);
        gridBagConstraints.anchor = 13;
        this.add(this.scoring_panel, this.match_label, gridBagConstraints, 1, 0);
        this.add(this.scoring_panel, this.mismatch_label, gridBagConstraints, 3, 0);
        this.add(this.scoring_panel, this.gap_label, gridBagConstraints, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add(this.scoring_panel, this.matrix_button, gridBagConstraints, 0, 1);
        gridBagConstraints.anchor = 10;
        this.add(this.scoring_panel, this.find_matrix_button, gridBagConstraints, 7, 1);
        gridBagConstraints.weightx = 0.3333333333333333;
        gridBagConstraints.fill = 2;
        this.add(this.scoring_panel, this.match_field, gridBagConstraints, 2, 0);
        this.add(this.scoring_panel, this.mismatch_field, gridBagConstraints, 4, 0);
        this.add(this.scoring_panel, this.gap_field, gridBagConstraints, 6, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 6;
        this.add(this.scoring_panel, this.matrix_field, gridBagConstraints, 1, 1);
        gridBagConstraints.gridwidth = 1;
        this.output_panel.setLayout(new GridBagLayout());
        this.output_panel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Output"));
        this.screen_button = new JRadioButton("Screen");
        this.screen_button.setSelected(true);
        this.output_to_file = false;
        this.file_button = new JRadioButton("File:");
        this.file_button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PairwiseAlignmentFrame.this.outputOptionStateChanged();
            }
        });
        this.output_field = new JTextField();
        this.output_field.setEnabled(false);
        this.output_field.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                PairwiseAlignmentFrame.this.checkRunButtonStatus();
            }
        });
        this.find_output_button = new JButton("Find...");
        this.find_output_button.setEnabled(false);
        this.find_output_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwiseAlignmentFrame.this.findOutputButtonActionPerformed();
            }
        });
        this.output_group = new ButtonGroup();
        this.output_group.add(this.screen_button);
        this.output_group.add(this.file_button);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.add(this.output_panel, this.screen_button, gridBagConstraints, 0, 0);
        this.add(this.output_panel, this.file_button, gridBagConstraints, 1, 0);
        this.add(this.output_panel, this.find_output_button, gridBagConstraints, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add(this.output_panel, this.output_field, gridBagConstraints, 2, 0);
        this.algorithm_panel.setLayout(new GridBagLayout());
        this.algorithm_panel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Alignment Algorithm"));
        this.algorithm_combo = new JComboBox<String>(this.algorithm_name);
        this.run_button = new JButton("Run");
        this.run_button.setEnabled(false);
        this.run_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PairwiseAlignmentFrame.this.runButtonActionPerformed();
            }
        });
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add(this.algorithm_panel, this.algorithm_combo, gridBagConstraints, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.add(this.algorithm_panel, this.run_button, gridBagConstraints, 1, 0);
        this.progress_area = new JTextArea();
        this.progress_area.setEditable(false);
        this.progress_area.setBorder(BorderFactory.createBevelBorder(1));
        this.progress_tab_panel = new JPanel();
        this.progress_tab_panel.setLayout(new GridLayout());
        this.progress_tab_panel.add(new JScrollPane(this.progress_area));
        this.output_tab.addTab("Progress", this.progress_tab_panel);
        this.output_area = new JTextArea();
        this.output_area.setEditable(false);
        this.output_area.setBorder(BorderFactory.createBevelBorder(1));
        this.output_area.setFont(new Font("Monospaced", 0, 12));
        this.output_tab_panel = new JPanel();
        this.output_tab_panel.setLayout(new GridLayout());
        this.output_tab_panel.add(new JScrollPane(this.output_area));
        this.output_tab.addTab("Output", this.output_tab_panel);
    }

    private void add(JComponent jComponent, JComponent jComponent2, GridBagConstraints gridBagConstraints, int n, int n2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        jComponent.add((Component)jComponent2, gridBagConstraints);
    }

    private void findSeq1ButtonActionPerformed() {
        int n = this.find_dialog.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.seq1_field.setText(this.find_dialog.getSelectedFile().getPath());
    }

    private void findSeq2ButtonActionPerformed() {
        int n = this.find_dialog.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.seq2_field.setText(this.find_dialog.getSelectedFile().getPath());
    }

    private void findMatrixButtonActionPerformed() {
        int n = this.find_dialog.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.matrix_field.setText(this.find_dialog.getSelectedFile().getPath());
    }

    private void findOutputButtonActionPerformed() {
        int n = this.find_dialog.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.output_field.setText(this.find_dialog.getSelectedFile().getPath());
    }

    private void schemeOptionStateChanged() {
        this.basic_scheme = this.basic_button.isSelected();
        this.match_label.setEnabled(this.basic_scheme);
        this.match_field.setEnabled(this.basic_scheme);
        this.mismatch_label.setEnabled(this.basic_scheme);
        this.mismatch_field.setEnabled(this.basic_scheme);
        this.gap_label.setEnabled(this.basic_scheme);
        this.gap_field.setEnabled(this.basic_scheme);
        this.matrix_field.setEnabled(!this.basic_scheme);
        this.find_matrix_button.setEnabled(!this.basic_scheme);
        this.checkRunButtonStatus();
    }

    private void outputOptionStateChanged() {
        this.output_to_file = this.file_button.isSelected();
        this.output_field.setEnabled(this.output_to_file);
        this.find_output_button.setEnabled(this.output_to_file);
        this.checkRunButtonStatus();
    }

    private void checkRunButtonStatus() {
        boolean bl = true;
        if (this.seq1_field.getText().length() == 0 || this.seq2_field.getText().length() == 0) {
            bl = false;
        } else if (this.file_button.isSelected() && this.output_field.getText().length() == 0) {
            bl = false;
        } else if (this.matrix_button.isSelected()) {
            if (this.matrix_field.getText().length() == 0) {
                bl = false;
            }
        } else if (this.match_field.getText().length() == 0 || this.mismatch_field.getText().length() == 0 || this.gap_field.getText().length() == 0) {
            bl = false;
        }
        if (this.run_button.isEnabled() && !bl || !this.run_button.isEnabled() && bl) {
            this.run_button.setEnabled(bl);
        }
    }

    private void runButtonActionPerformed() {
        PairwiseAlignment pairwiseAlignment;
        long l;
        long l2;
        FileReader fileReader;
        FileReader fileReader2;
        FileReader fileReader3;
        int n = this.algorithm_combo.getSelectedIndex();
        this.output_tab.setSelectedIndex(0);
        this.output_area.setText("");
        if (this.basic_scheme) {
            this.progress_area.setText("Creating scoring scheme... ");
            try {
                int n2 = Integer.parseInt(this.match_field.getText());
                int n3 = Integer.parseInt(this.mismatch_field.getText());
                int n4 = Integer.parseInt(this.gap_field.getText());
                BasicScoringScheme basicScoringScheme = new BasicScoringScheme(n2, n3, n4);
                this.algorithm[n].setScoringScheme(basicScoringScheme);
                this.progress_area.append("OK");
            }
            catch (NumberFormatException numberFormatException) {
                String string = "Invalid scoring arguments.";
                this.progress_area.append("\n" + string);
                this.showError(string);
                return;
            }
        }
        String string = this.matrix_field.getText();
        this.progress_area.setText("Loading matrix file... ");
        try {
            fileReader3 = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "File \"" + string + "\" not found.";
            this.progress_area.append("\n" + string2);
            this.showError(string2);
            return;
        }
        try {
            try {
                ScoringMatrix scoringMatrix = new ScoringMatrix(fileReader3);
                this.algorithm[n].setScoringScheme(scoringMatrix);
                this.progress_area.append("OK");
            }
            catch (InvalidScoringMatrixException invalidScoringMatrixException) {
                fileReader3.close();
                String string3 = "Invalid matrix file \"" + string + "\".";
                this.progress_area.append("\n" + string3);
                this.showError(string3);
                return;
            }
            fileReader3.close();
        }
        catch (IOException iOException) {
            String string4 = "Error reading file.";
            this.progress_area.append("\n" + string4);
            this.showError(string4);
            return;
        }
        this.progress_area.append("\n\nLoading sequences... ");
        String string5 = this.seq1_field.getText();
        try {
            fileReader2 = new FileReader(string5);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string6 = "File \"" + string5 + "\" not found.";
            this.progress_area.append("\n" + string6);
            this.showError(string6);
            return;
        }
        String string7 = this.seq2_field.getText();
        try {
            fileReader = new FileReader(string7);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string8 = "File \"" + string7 + "\" not found.";
            this.progress_area.append("\n" + string8);
            this.showError(string8);
            return;
        }
        try {
            try {
                l2 = System.currentTimeMillis();
                this.algorithm[n].loadSequences(fileReader2, fileReader);
                l = System.currentTimeMillis() - l2;
                this.progress_area.append("OK");
                this.progress_area.append("\n[ Elapsed time: " + l + " milliseconds ]");
            }
            catch (InvalidSequenceException invalidSequenceException) {
                fileReader2.close();
                fileReader.close();
                String string9 = "Invalid sequence files.";
                this.progress_area.append("\n" + string9);
                this.showError(string9);
                return;
            }
            fileReader2.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            String string10 = "Error reading sequence files.";
            this.progress_area.append("\n" + string10);
            this.showError(string10);
            return;
        }
        this.progress_area.append("\n\nRunning " + this.algorithm_combo.getSelectedItem() + "... ");
        try {
            l2 = System.currentTimeMillis();
            pairwiseAlignment = this.algorithm[n].getPairwiseAlignment();
            l = System.currentTimeMillis() - l2;
            this.progress_area.append("OK");
            this.progress_area.append("\n[ Elapsed time: " + l + " milliseconds ]");
        }
        catch (IncompatibleScoringSchemeException incompatibleScoringSchemeException) {
            String string11 = "Scoring matrix is not compatible with loaded sequences.";
            this.progress_area.append("\n" + string11);
            this.showError(string11);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string12 = "Insufficient memory to compute an alignment";
            this.progress_area.append("\n" + string12);
            this.showError(string12);
            return;
        }
        if (this.output_to_file) {
            String string13 = this.output_field.getText();
            this.progress_area.append("\n\nSaving alignment... ");
            try {
                int n5 = pairwiseAlignment.getGappedSequence1().length();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string13));
                bufferedWriter.write(pairwiseAlignment.getGappedSequence1(), 0, n5);
                bufferedWriter.newLine();
                bufferedWriter.write(pairwiseAlignment.getScoreTagLine(), 0, n5);
                bufferedWriter.newLine();
                bufferedWriter.write(pairwiseAlignment.getGappedSequence2(), 0, n5);
                bufferedWriter.newLine();
                String string14 = "Score: " + pairwiseAlignment.getScore();
                bufferedWriter.write(string14, 0, string14.length());
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                String string15 = "Error writing file \"" + string13 + "\".";
                this.progress_area.append("\n" + string15);
                this.showError(string15);
                return;
            }
            this.progress_area.append("OK");
        } else {
            this.output_area.setText(pairwiseAlignment.toString());
            this.output_tab.setSelectedIndex(1);
        }
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }
}

