/*
 * Decompiled with CFR 0.152.
 */
package neobio.textui;

import java.io.FileReader;
import java.io.IOException;
import neobio.alignment.BasicScoringScheme;
import neobio.alignment.CrochemoreLandauZivUkelsonGlobalAlignment;
import neobio.alignment.CrochemoreLandauZivUkelsonLocalAlignment;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidScoringMatrixException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.NeedlemanWunsch;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;
import neobio.alignment.ScoringMatrix;
import neobio.alignment.ScoringScheme;
import neobio.alignment.SmithWaterman;

public class NeoBio {
    public static void main(String[] stringArray) {
        ScoringScheme scoringScheme;
        String string;
        String string2;
        PairwiseAlignmentAlgorithm pairwiseAlignmentAlgorithm;
        block23: {
            try {
                String string3 = stringArray[0];
                if (string3.equalsIgnoreCase("nw")) {
                    pairwiseAlignmentAlgorithm = new NeedlemanWunsch();
                } else if (string3.equalsIgnoreCase("sw")) {
                    pairwiseAlignmentAlgorithm = new SmithWaterman();
                } else if (string3.equalsIgnoreCase("clzg")) {
                    pairwiseAlignmentAlgorithm = new CrochemoreLandauZivUkelsonGlobalAlignment();
                } else if (string3.equalsIgnoreCase("clzl")) {
                    pairwiseAlignmentAlgorithm = new CrochemoreLandauZivUkelsonLocalAlignment();
                } else {
                    NeoBio.usage();
                    System.exit(1);
                    return;
                }
                string2 = stringArray[1];
                string = stringArray[2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                NeoBio.usage();
                System.exit(1);
                return;
            }
            try {
                String string4 = stringArray[3];
                try {
                    if (string4.equalsIgnoreCase("M")) {
                        scoringScheme = new ScoringMatrix(new FileReader(stringArray[4]));
                        break block23;
                    }
                    if (string4.equalsIgnoreCase("S")) {
                        int n = Integer.parseInt(stringArray[4]);
                        int n2 = Integer.parseInt(stringArray[5]);
                        int n3 = Integer.parseInt(stringArray[6]);
                        scoringScheme = new BasicScoringScheme(n, n2, n3);
                        break block23;
                    }
                    NeoBio.usage();
                    System.exit(1);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    NeoBio.usage();
                    System.exit(1);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    NeoBio.usage();
                    System.exit(1);
                    return;
                }
                catch (InvalidScoringMatrixException invalidScoringMatrixException) {
                    System.err.println(invalidScoringMatrixException.getMessage());
                    System.exit(2);
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    System.exit(2);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                scoringScheme = new BasicScoringScheme(1, -1, -1);
            }
        }
        pairwiseAlignmentAlgorithm.setScoringScheme(scoringScheme);
        try {
            System.err.println("\nLoading sequences...");
            FileReader fileReader = new FileReader(string2);
            FileReader fileReader2 = new FileReader(string);
            long l = System.currentTimeMillis();
            pairwiseAlignmentAlgorithm.loadSequences(fileReader, fileReader2);
            long l2 = System.currentTimeMillis() - l;
            fileReader.close();
            fileReader2.close();
            System.err.println("[ Elapsed time: " + l2 + " milliseconds ]\n");
            System.err.println("Computing alignment...");
            l = System.currentTimeMillis();
            PairwiseAlignment pairwiseAlignment = pairwiseAlignmentAlgorithm.getPairwiseAlignment();
            l2 = System.currentTimeMillis() - l;
            System.err.println("[ Elapsed time: " + l2 + " milliseconds ]\n");
            System.out.println("Alignment:\n" + pairwiseAlignment);
        }
        catch (InvalidSequenceException invalidSequenceException) {
            System.err.println("Invalid sequence file.");
            System.exit(2);
            return;
        }
        catch (IncompatibleScoringSchemeException incompatibleScoringSchemeException) {
            System.err.println("Incompatible scoring scheme.");
            System.exit(2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(2);
            return;
        }
        System.exit(0);
    }

    public static void usage() {
        System.err.println("\nUsage: NeoBio <alg> <S1> <S2> [M <matrix> | S <match> <mismatch> <gap>]\n\nwhere:\n\n   <alg> = NW   for Needleman & Wunsch (global alignment)\n        or SW   for Smith & Waterman (local alignment)\n        or CLZG for Crochemore, Landau & Ziv-Ukelson global alignment\n        or CLZL for Crochemore, Landau & Ziv-Ukelson local alignment\n\n   <S1> = first sequence file\n\n   <S2> = second sequence file\n\n   M <matrix> for using a scoring matrix file\n\nor\n\n   S <match> <mismatch> <gap> for using a simple scoring scheme\n     where <match> = match reward value\n           <mismatch> = mismatch penalty value\n           <gap> = cost of a gap (linear gap cost function)");
    }
}

