/*
 * Decompiled with CFR 0.152.
 */
package neobio.textui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RandomSequenceGenerator {
    private static final char[] DNA_CHARS = new char[]{'A', 'C', 'G', 'T'};
    private static final char[] PROT_CHARS = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'B', 'Z', 'X'};

    public static void main(String[] stringArray) {
        Writer writer;
        String string;
        char[] cArray;
        int n;
        String string2;
        try {
            string2 = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            RandomSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            RandomSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        if (string2.equalsIgnoreCase("DNA")) {
            cArray = DNA_CHARS;
        } else if (string2.equalsIgnoreCase("PROT")) {
            cArray = PROT_CHARS;
        } else {
            RandomSequenceGenerator.usage();
            System.exit(1);
            return;
        }
        if (n < 1) {
            System.err.println("Error: size must be greater than 1.");
            System.exit(1);
            return;
        }
        try {
            string = stringArray[2];
            try {
                writer = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                System.err.println("Error: couldn't open " + string + " for writing.");
                iOException.printStackTrace();
                System.exit(2);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
            writer = new OutputStreamWriter(System.out);
        }
        int[] nArray = new int[cArray.length];
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = (int)(Math.random() * (double)cArray.length);
                nArray[n4] = nArray[n4] + 1;
                writer.write(cArray[n3]);
                ++n2;
            }
            writer.flush();
            if (string != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error: failed to write sequence.");
            iOException.printStackTrace();
            System.exit(2);
            return;
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("\nUsage: RandomSequenceGenerator <type> <size> [<file>]\n\nwhere:\n\n   <type> = DNA for nucleotide sequences\n         or PROT for protein sequences\n\n   <size> = number os characters\n\n   <file> = name of a file to where the sequence is to be written\n            (if ommited, sequence is written to standard output)");
    }
}

