/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Hackit
extends JFrame
implements ActionListener {
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu fileMenu;
    protected JMenu editMenu;
    public static final int MAXPARS = 16;
    public static final String READY = "Ready..\n";
    JButton addB;
    JButton writeB;
    JButton resetB;
    JScrollPane jsp;
    JTextArea textA;
    FileReader reader;
    ClipBox clipper;
    Vector files;
    int pBytes;

    public Hackit() {
        super("Hackit: FCS Concatenator");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.reader = new FileReader(this);
        this.clipper = new ClipBox(this);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 3));
        this.addB = new JButton("Add an Input File");
        this.addB.addActionListener(this);
        this.writeB = new JButton("Write Output File");
        this.writeB.addActionListener(this);
        this.resetB = new JButton("Reset");
        this.resetB.addActionListener(this);
        buttons.add(this.addB);
        buttons.add(this.resetB);
        buttons.add(this.writeB);
        this.textA = new JTextArea("Program for clipping and joining FCS list mode data files.\n");
        this.jsp = new JScrollPane(this.textA);
        this.getContentPane().add("Center", this.jsp);
        this.getContentPane().add("South", buttons);
        this.setSize(new Dimension(600, 300));
        this.setLocation(new Point(400, 0));
        this.reset();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addB) {
            this.addFile();
        } else if (evt.getSource() == this.writeB) {
            this.writeFile();
        } else if (evt.getSource() == this.resetB) {
            this.reset();
        }
    }

    private void addFile() {
        try {
            FileSpec fs = this.reader.read(this.pBytes);
            if (fs != null) {
                this.clipper.set(fs.pathname, fs.total);
                this.clipper.setVisible(true);
                if (this.clipper.getStatus()) {
                    fs.clip = this.clipper.getClip();
                    fs.retain = this.clipper.getRetain();
                    this.textA.append(fs.pathname + " Total: " + fs.total + " Clip first " + fs.clip + " Clip last " + (fs.total - fs.retain - fs.clip) + '\n');
                    this.files.addElement(fs);
                    this.pBytes = fs.pBytes;
                    this.writeB.setEnabled(true);
                    this.resetB.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeFile() {
        String name = this.reader.write(this.files);
        if (name != null) {
            this.textA.append(name + " Written.\n");
            this.reset();
        } else {
            this.textA.append("No file written.\n");
        }
    }

    private void reset() {
        this.files = new Vector();
        this.pBytes = -1;
        this.writeB.setEnabled(false);
        this.resetB.setEnabled(false);
        this.textA.append(READY);
    }

    public static void main(String[] args) {
        new Hackit();
    }
}

