/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class LoggingSystem {
    public static final String SYSTEM_PROPERTY = LoggingSystem.class.getName();
    public static final String NONE = "none";
    private static final Map<String, String> SYSTEMS;

    public abstract void beforeInitialize();

    public void initialize(LoggingInitializationContext initializationContext, String configLocation, LogFile logFile) {
    }

    public void cleanUp() {
    }

    public Runnable getShutdownHandler() {
        return null;
    }

    public abstract void setLogLevel(String var1, LogLevel var2);

    public static LoggingSystem get(ClassLoader classLoader) {
        String loggingSystem = System.getProperty(SYSTEM_PROPERTY);
        if (StringUtils.hasLength((String)loggingSystem)) {
            if (NONE.equals(loggingSystem)) {
                return new NoOpLoggingSystem();
            }
            return LoggingSystem.get(classLoader, loggingSystem);
        }
        for (Map.Entry<String, String> entry : SYSTEMS.entrySet()) {
            if (!ClassUtils.isPresent((String)entry.getKey(), (ClassLoader)classLoader)) continue;
            return LoggingSystem.get(classLoader, entry.getValue());
        }
        throw new IllegalStateException("No suitable logging system located");
    }

    private static LoggingSystem get(ClassLoader classLoader, String loggingSystemClass) {
        try {
            Class systemClass = ClassUtils.forName((String)loggingSystemClass, (ClassLoader)classLoader);
            return (LoggingSystem)systemClass.getConstructor(ClassLoader.class).newInstance(classLoader);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        LinkedHashMap<String, String> systems = new LinkedHashMap<String, String>();
        systems.put("ch.qos.logback.core.Appender", "org.springframework.boot.logging.logback.LogbackLoggingSystem");
        systems.put("org.apache.logging.log4j.core.impl.Log4jContextFactory", "org.springframework.boot.logging.log4j2.Log4J2LoggingSystem");
        systems.put("java.util.logging.LogManager", "org.springframework.boot.logging.java.JavaLoggingSystem");
        SYSTEMS = Collections.unmodifiableMap(systems);
    }

    static class NoOpLoggingSystem
    extends LoggingSystem {
        NoOpLoggingSystem() {
        }

        @Override
        public void beforeInitialize() {
        }

        @Override
        public void setLogLevel(String loggerName, LogLevel level) {
        }
    }
}

